/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClientBuilder;
import org.apache.distributedlog.api.MetadataAccessor;
import org.apache.distributedlog.exceptions.AlreadyClosedException;
import org.apache.distributedlog.exceptions.DLInterruptedException;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.impl.metadata.BKDLConfig;
import org.apache.distributedlog.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKMetadataAccessor
implements MetadataAccessor {
    static final Logger LOG = LoggerFactory.getLogger(ZKMetadataAccessor.class);
    protected final String name;
    protected CompletableFuture<Void> closePromise;
    protected final URI uri;
    protected final ZooKeeperClientBuilder writerZKCBuilder;
    protected final ZooKeeperClient writerZKC;
    protected final boolean ownWriterZKC;
    protected final ZooKeeperClientBuilder readerZKCBuilder;
    protected final ZooKeeperClient readerZKC;
    protected final boolean ownReaderZKC;

    ZKMetadataAccessor(String name, DistributedLogConfiguration conf, URI uri, ZooKeeperClientBuilder writerZKCBuilder, ZooKeeperClientBuilder readerZKCBuilder, StatsLogger statsLogger) {
        this.name = name;
        this.uri = uri;
        if (null == writerZKCBuilder) {
            BoundExponentialBackoffRetryPolicy retryPolicy = null;
            if (conf.getZKNumRetries() > 0) {
                retryPolicy = new BoundExponentialBackoffRetryPolicy((long)conf.getZKRetryBackoffStartMillis(), (long)conf.getZKRetryBackoffMaxMillis(), conf.getZKNumRetries());
            }
            this.writerZKCBuilder = ZooKeeperClientBuilder.newBuilder().name(String.format("dlzk:%s:dlm_writer_shared", name)).sessionTimeoutMs(conf.getZKSessionTimeoutMilliseconds()).retryThreadCount(conf.getZKClientNumberRetryThreads()).requestRateLimit(conf.getZKRequestRateLimit()).zkAclId(conf.getZkAclId()).uri(uri).retryPolicy((RetryPolicy)retryPolicy).statsLogger(statsLogger.scope("dlzk_dlm_writer_shared"));
            this.ownWriterZKC = true;
        } else {
            this.writerZKCBuilder = writerZKCBuilder;
            this.ownWriterZKC = false;
        }
        this.writerZKC = this.writerZKCBuilder.build();
        if (null == readerZKCBuilder) {
            String zkServersForReader;
            String zkServersForWriter = BKNamespaceDriver.getZKServersFromDLUri(uri);
            try {
                BKDLConfig bkdlConfig = BKDLConfig.resolveDLConfig(this.writerZKC, uri);
                zkServersForReader = bkdlConfig.getDlZkServersForReader();
            }
            catch (IOException e) {
                LOG.warn("Error on resolving dl metadata bindings for {} : ", (Object)uri, (Object)e);
                zkServersForReader = zkServersForWriter;
            }
            if (zkServersForReader.equals(zkServersForWriter)) {
                LOG.info("Used same zookeeper servers '{}' for both writers and readers for {}.", (Object)zkServersForWriter, (Object)name);
                this.readerZKCBuilder = this.writerZKCBuilder;
                this.ownReaderZKC = false;
            } else {
                BoundExponentialBackoffRetryPolicy retryPolicy = null;
                if (conf.getZKNumRetries() > 0) {
                    retryPolicy = new BoundExponentialBackoffRetryPolicy((long)conf.getZKRetryBackoffStartMillis(), (long)conf.getZKRetryBackoffMaxMillis(), conf.getZKNumRetries());
                }
                this.readerZKCBuilder = ZooKeeperClientBuilder.newBuilder().name(String.format("dlzk:%s:dlm_reader_shared", name)).sessionTimeoutMs(conf.getZKSessionTimeoutMilliseconds()).retryThreadCount(conf.getZKClientNumberRetryThreads()).requestRateLimit(conf.getZKRequestRateLimit()).zkServers(zkServersForReader).retryPolicy((RetryPolicy)retryPolicy).zkAclId(conf.getZkAclId()).statsLogger(statsLogger.scope("dlzk_dlm_reader_shared"));
                this.ownReaderZKC = true;
            }
        } else {
            this.readerZKCBuilder = readerZKCBuilder;
            this.ownReaderZKC = false;
        }
        this.readerZKC = this.readerZKCBuilder.build();
    }

    @Override
    public String getStreamName() {
        return this.name;
    }

    @Override
    public void createOrUpdateMetadata(byte[] metadata) throws IOException {
        this.checkClosedOrInError("createOrUpdateMetadata");
        String zkPath = this.getZKPath();
        LOG.debug("Setting application specific metadata on {}", (Object)zkPath);
        try {
            Stat currentStat = this.writerZKC.get().exists(zkPath, false);
            if (currentStat == null) {
                if (metadata.length > 0) {
                    Utils.zkCreateFullPathOptimistic(this.writerZKC, zkPath, metadata, this.writerZKC.getDefaultACL(), CreateMode.PERSISTENT);
                }
            } else {
                this.writerZKC.get().setData(zkPath, metadata, currentStat.getVersion());
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new DLInterruptedException("Interrupted on creating or updating container metadata", (Throwable)ie);
        }
        catch (Exception exc) {
            throw new IOException("Exception creating or updating container metadata", exc);
        }
    }

    @Override
    public void deleteMetadata() throws IOException {
        this.checkClosedOrInError("createOrUpdateMetadata");
        this.createOrUpdateMetadata(null);
    }

    @Override
    public byte[] getMetadata() throws IOException {
        this.checkClosedOrInError("createOrUpdateMetadata");
        String zkPath = this.getZKPath();
        LOG.debug("Getting application specific metadata from {}", (Object)zkPath);
        try {
            Stat currentStat = this.readerZKC.get().exists(zkPath, false);
            if (currentStat == null) {
                return null;
            }
            return this.readerZKC.get().getData(zkPath, false, currentStat);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new DLInterruptedException("Error reading the max tx id from zk", (Throwable)ie);
        }
        catch (Exception e) {
            throw new IOException("Error reading the max tx id from zk", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> asyncClose() {
        CompletableFuture<Void> closeFuture;
        ZKMetadataAccessor zKMetadataAccessor = this;
        synchronized (zKMetadataAccessor) {
            if (null != this.closePromise) {
                return this.closePromise;
            }
            this.closePromise = new CompletableFuture<Void>();
            closeFuture = this.closePromise;
        }
        try {
            if (this.ownWriterZKC) {
                this.writerZKC.close();
            }
            if (this.ownReaderZKC) {
                this.readerZKC.close();
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while closing distributed log manager", (Throwable)e);
        }
        FutureUtils.complete(closeFuture, null);
        return closeFuture;
    }

    @Override
    public void close() throws IOException {
        Utils.ioResult(this.asyncClose());
    }

    public synchronized void checkClosedOrInError(String operation) throws AlreadyClosedException {
        if (null != this.closePromise) {
            throw new AlreadyClosedException("Executing " + operation + " on already closed ZKMetadataAccessor");
        }
    }

    protected String getZKPath() {
        return String.format("%s/%s", this.uri.getPath(), this.name);
    }

    @VisibleForTesting
    protected ZooKeeperClient getReaderZKC() {
        return this.readerZKC;
    }

    @VisibleForTesting
    protected ZooKeeperClient getWriterZKC() {
        return this.writerZKC;
    }
}

