/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.client;

import com.beust.jcommander.Parameter;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.api.BookKeeper;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.tools.cli.helpers.ClientCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTestCommand
extends ClientCommand<Flags> {
    private static final String NAME = "simpletest";
    private static final String DESC = "Simple test to create a ledger and write entries to it.";
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTestCommand.class);

    public SimpleTestCommand() {
        this(new Flags());
    }

    public SimpleTestCommand(Flags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)flags).build());
    }

    @Override
    protected void run(BookKeeper bk, Flags flags) throws Exception {
        byte[] data = new byte[100];
        try (WriteHandle wh = (WriteHandle)FutureUtils.result(bk.newCreateLedgerOp().withEnsembleSize(flags.ensembleSize).withWriteQuorumSize(flags.writeQuorumSize).withAckQuorumSize(flags.ackQuorumSize).withDigestType(DigestType.CRC32C).withPassword(new byte[0]).execute());){
            LOG.info("Ledger ID: " + wh.getId());
            long lastReport = System.nanoTime();
            for (int i = 0; i < flags.numEntries; ++i) {
                wh.append(data);
                if (TimeUnit.SECONDS.convert(System.nanoTime() - lastReport, TimeUnit.NANOSECONDS) <= 1L) continue;
                LOG.info(i + " entries written");
                lastReport = System.nanoTime();
            }
            LOG.info(flags.numEntries + " entries written to ledger " + wh.getId());
        }
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-e", "--ensemble-size"}, description="Ensemble size (default 3)")
        private int ensembleSize = 3;
        @Parameter(names={"-w", "--write-quorum-size"}, description="Write quorum size (default 2)")
        private int writeQuorumSize = 2;
        @Parameter(names={"-a", "--ack-quorum-size"}, description="Ack quorum size (default 2)")
        private int ackQuorumSize = 2;
        @Parameter(names={"-n", "--num-entries"}, description="Entries to write (default 100)")
        private int numEntries = 100;

        public Flags ensembleSize(int ensembleSize) {
            this.ensembleSize = ensembleSize;
            return this;
        }

        public Flags writeQuorumSize(int writeQuorumSize) {
            this.writeQuorumSize = writeQuorumSize;
            return this;
        }

        public Flags ackQuorumSize(int ackQuorumSize) {
            this.ackQuorumSize = ackQuorumSize;
            return this;
        }

        public Flags numEntries(int numEntries) {
            this.numEntries = numEntries;
            return this;
        }
    }
}

