/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import mockit.Invocation;
import mockit.Mock;
import mockit.MockUp;
import org.apache.jute.Record;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.TxnLogDigestTest;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.metric.SimpleCounter;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.txn.TxnDigest;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumDigestTest
extends QuorumPeerTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumDigestTest.class);
    private QuorumPeerTestBase.Servers servers;
    private String forceSnapSyncValue;

    @BeforeClass
    public static void applyMockUps() {
        new DataTreeMock();
    }

    @Before
    public void setup() throws Exception {
        this.forceSnapSyncValue = System.getProperty("zookeeper.forceSnapshotSync");
        ZooKeeperServer.setDigestEnabled((boolean)true);
        ((SimpleCounter)ServerMetrics.getMetrics().DIGEST_MISMATCHES_COUNT).reset();
        this.servers = this.LaunchServers(3, 1, null);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.servers != null) {
            this.servers.shutDownAllServers();
        }
        ZooKeeperServer.setDigestEnabled((boolean)false);
        System.clearProperty("zookeeper.forceSnapshotSync");
        DataTreeMock.reset();
    }

    @Test
    public void testDigestMatchesDuringDiffSync() throws Exception {
        this.triggerSync(false);
    }

    @Test
    public void testDigestMatchesDuringSnapSync() throws Exception {
        this.triggerSync(true);
        int leader = this.servers.findLeader();
        TxnLogDigestTest.performOperations(this.servers.zk[leader], "/testDigestMatchesDuringSnapSync");
        Assert.assertEquals((long)0L, (long)QuorumDigestTest.getMismatchDigestCount());
    }

    @Test
    public void testDigestMatchesWithAsyncRequests() throws Exception {
        int leader = this.servers.findLeader();
        final ZooKeeper client = this.servers.zk[leader];
        final AtomicBoolean stopped = new AtomicBoolean(true);
        String prefix = "/testDigestMatchesWithAsyncRequests";
        Thread createTrafficThread = new Thread(){

            @Override
            public void run() {
                int i = 0;
                while (!stopped.get()) {
                    String path = "/testDigestMatchesWithAsyncRequests-" + i;
                    client.create(path, path.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, new AsyncCallback.StringCallback(){

                        public void processResult(int rc, String path, Object ctx, String name) {
                        }
                    }, null);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        createTrafficThread.start();
        List<Integer> targets = Arrays.asList(this.servers.findAnyFollower(), this.servers.findAnyObserver());
        this.stopServers(targets);
        this.startServers(targets);
        Assert.assertEquals((long)0L, (long)QuorumDigestTest.getMismatchDigestCount());
        targets = Arrays.asList(leader);
        this.stopServers(targets);
        this.startServers(targets);
        Assert.assertEquals((long)0L, (long)QuorumDigestTest.getMismatchDigestCount());
        stopped.set(true);
    }

    @Test
    public void testDigestMismatchesWhenTxnLost() throws Exception {
        Assert.assertEquals((long)0L, (long)QuorumDigestTest.getMismatchDigestCount());
        List<Integer> targets = Arrays.asList(this.servers.findAnyFollower(), this.servers.findAnyObserver());
        this.stopServers(targets);
        int leader = this.servers.findLeader();
        this.triggerOps(leader, "/p1");
        Assert.assertEquals((long)0L, (long)QuorumDigestTest.getMismatchDigestCount());
        DataTreeMock.skipTxnZxid = "100000006";
        this.startServers(targets);
        long misMatchCount = QuorumDigestTest.getMismatchDigestCount();
        Assert.assertNotEquals((long)0L, (long)misMatchCount);
        this.triggerOps(leader, "/p2");
        Assert.assertNotEquals((long)misMatchCount, (long)QuorumDigestTest.getMismatchDigestCount());
    }

    private void stopServers(List<Integer> sids) throws InterruptedException {
        for (int sid : sids) {
            if (sid == -1) continue;
            this.servers.mt[sid].shutdown();
            QuorumDigestTest.waitForOne(this.servers.zk[sid], ZooKeeper.States.CONNECTING);
        }
    }

    private void startServers(List<Integer> sids) throws InterruptedException {
        for (int sid : sids) {
            this.servers.mt[sid].start();
            QuorumDigestTest.waitForOne(this.servers.zk[sid], ZooKeeper.States.CONNECTED);
        }
    }

    private void triggerOps(int sid, String prefix) throws Exception {
        TxnLogDigestTest.performOperations(this.servers.zk[sid], prefix);
        this.servers.restartClient(sid, null);
        QuorumDigestTest.waitForOne(this.servers.zk[sid], ZooKeeper.States.CONNECTED);
    }

    private void triggerSync(boolean snapSync) throws Exception {
        if (snapSync) {
            System.setProperty("zookeeper.forceSnapshotSync", "true");
        }
        Assert.assertEquals((long)0L, (long)QuorumDigestTest.getMismatchDigestCount());
        int leader = this.servers.findLeader();
        this.triggerOps(leader, "/p1");
        Assert.assertEquals((long)0L, (long)QuorumDigestTest.getMismatchDigestCount());
        List<Integer> targets = Arrays.asList(this.servers.findAnyFollower(), this.servers.findAnyObserver());
        this.stopServers(targets);
        this.triggerOps(leader, "/p2");
        this.startServers(targets);
        Assert.assertEquals((long)0L, (long)QuorumDigestTest.getMismatchDigestCount());
    }

    public static long getMismatchDigestCount() {
        return ((SimpleCounter)ServerMetrics.getMetrics().DIGEST_MISMATCHES_COUNT).get();
    }

    public static final class DataTreeMock
    extends MockUp<DataTree> {
        static String skipTxnZxid = "";

        @Mock
        public DataTree.ProcessTxnResult processTxn(Invocation invocation, TxnHeader header, Record txn, TxnDigest digest) {
            if (header != null && Long.toHexString(header.getZxid()).equals(skipTxnZxid)) {
                LOG.info("skip process txn {}", (Object)header.getZxid());
                DataTree.ProcessTxnResult rc = new DataTree.ProcessTxnResult();
                rc.path = "";
                rc.stat = new Stat();
                rc.multiResult = new ArrayList();
                return rc;
            }
            return (DataTree.ProcessTxnResult)invocation.proceed(new Object[]{header, txn, digest});
        }

        public static void reset() {
            skipTxnZxid = "";
        }
    }
}

