/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.DomainSocketAddress;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.transport.Transport;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;

class KQueueTransport
extends Transport {
    KQueueTransport() {
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address, boolean resolved) {
        if (address.path() != null) {
            return new DomainSocketAddress(address.path());
        }
        if (resolved) {
            return new InetSocketAddress(address.host(), address.port());
        }
        return InetSocketAddress.createUnresolved(address.host(), address.port());
    }

    @Override
    public boolean isAvailable() {
        return KQueue.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return KQueue.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int nThreads, ThreadFactory threadFactory, int ioRatio) {
        KQueueEventLoopGroup eventLoopGroup = new KQueueEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new KQueueDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new KQueueDatagramChannel();
    }

    @Override
    public Class<? extends Channel> channelType(boolean domain) {
        if (domain) {
            return KQueueDomainSocketChannel.class;
        }
        return KQueueSocketChannel.class;
    }

    @Override
    public Class<? extends ServerChannel> serverChannelType(boolean domain) {
        if (domain) {
            return KQueueServerDomainSocketChannel.class;
        }
        return KQueueServerSocketChannel.class;
    }

    @Override
    public void configure(NetServerOptions options, ServerBootstrap bootstrap) {
        bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)options.isReusePort());
        super.configure(options, bootstrap);
    }
}

