/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.dns.DnsClientOptionsConverter;
import io.vertx.core.json.JsonObject;

@DataObject(generateConverter=true)
public class DnsClientOptions {
    public static final int DEFAULT_PORT = -1;
    public static final String DEFAULT_HOST = null;
    public static final long DEFAULT_QUERY_TIMEOUT = 5000L;
    private int port = -1;
    private String host = DEFAULT_HOST;
    private long queryTimeout = 5000L;

    public DnsClientOptions() {
    }

    public DnsClientOptions(JsonObject json) {
        DnsClientOptionsConverter.fromJson(json, this);
    }

    public DnsClientOptions(DnsClientOptions other) {
        this.port = other.port;
        this.host = other.host;
        this.queryTimeout = other.queryTimeout;
    }

    public int getPort() {
        return this.port;
    }

    public DnsClientOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public DnsClientOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    public DnsClientOptions setQueryTimeout(long queryTimeout) {
        if (queryTimeout < 1L) {
            throw new IllegalArgumentException("queryTimeout must be > 0");
        }
        this.queryTimeout = queryTimeout;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        DnsClientOptionsConverter.toJson(this, json);
        return json;
    }
}

