/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.federated;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.callback.NamespaceListener;
import org.apache.distributedlog.exceptions.LogExistsException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.exceptions.ZKException;
import org.apache.distributedlog.impl.ZKNamespaceWatcher;
import org.apache.distributedlog.metadata.LogMetadataStore;
import org.apache.distributedlog.namespace.NamespaceWatcher;
import org.apache.distributedlog.util.Utils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Transaction;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederatedZKLogMetadataStore
extends NamespaceWatcher
implements LogMetadataStore,
Watcher,
Runnable,
FutureEventListener<Set<URI>> {
    private static final Logger logger = LoggerFactory.getLogger(FederatedZKLogMetadataStore.class);
    private static final String ZNODE_SUB_NAMESPACES = ".subnamespaces";
    private static final String SUB_NAMESPACE_PREFIX = "NS_";
    final DistributedLogConfiguration conf;
    final URI namespace;
    final ZooKeeperClient zkc;
    final OrderedScheduler scheduler;
    final String zkSubnamespacesPath;
    final AtomicBoolean duplicatedLogFound = new AtomicBoolean(false);
    final AtomicReference<String> duplicatedLogName = new AtomicReference<Object>(null);
    final AtomicReference<Integer> zkSubnamespacesVersion = new AtomicReference<Object>(null);
    final int maxLogsPerSubnamespace;
    final ConcurrentSkipListMap<URI, SubNamespace> subNamespaces;
    final ConcurrentMap<String, URI> log2Locations;
    final boolean forceCheckLogExistence;

    public static void createFederatedNamespace(URI namespace, ZooKeeperClient zkc) throws IOException, KeeperException {
        String zkSubNamespacesPath = namespace.getPath() + "/" + ZNODE_SUB_NAMESPACES;
        Utils.zkCreateFullPathOptimistic(zkc, zkSubNamespacesPath, new byte[0], zkc.getDefaultACL(), CreateMode.PERSISTENT);
    }

    public FederatedZKLogMetadataStore(DistributedLogConfiguration conf, URI namespace, ZooKeeperClient zkc, OrderedScheduler scheduler) throws IOException {
        Set uris;
        this.conf = conf;
        this.namespace = namespace;
        this.zkc = zkc;
        this.scheduler = scheduler;
        this.forceCheckLogExistence = conf.getFederatedCheckExistenceWhenCacheMiss();
        this.subNamespaces = new ConcurrentSkipListMap();
        this.log2Locations = new ConcurrentHashMap<String, URI>();
        this.zkSubnamespacesPath = namespace.getPath() + "/" + ZNODE_SUB_NAMESPACES;
        this.maxLogsPerSubnamespace = conf.getFederatedMaxLogsPerSubnamespace();
        try {
            uris = (Set)FutureUtils.result(this.fetchSubNamespaces(this));
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        for (URI uri : uris) {
            SubNamespace subNs;
            if (null != this.subNamespaces.putIfAbsent(uri, subNs = new SubNamespace(uri))) continue;
            subNs.watch();
            logger.info("Watched sub namespace {}", (Object)uri);
        }
        logger.info("Federated ZK LogMetadataStore is initialized for {}", (Object)namespace);
    }

    private void scheduleTask(Runnable r, long ms) {
        if (this.duplicatedLogFound.get()) {
            logger.error("Scheduler is halted for federated namespace {} as duplicated log found", (Object)this.namespace);
            return;
        }
        try {
            this.scheduler.schedule(r, ms, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ree) {
            logger.error("Task {} scheduled in {} ms is rejected : ", new Object[]{r, ms, ree});
        }
    }

    private <T> CompletableFuture<T> postStateCheck(CompletableFuture<T> future) {
        final CompletableFuture postCheckedPromise = new CompletableFuture();
        future.whenComplete((BiConsumer)new FutureEventListener<T>(){

            public void onSuccess(T value) {
                if (FederatedZKLogMetadataStore.this.duplicatedLogFound.get()) {
                    postCheckedPromise.completeExceptionally(new UnexpectedException("Duplicate log found under " + FederatedZKLogMetadataStore.this.namespace));
                } else {
                    postCheckedPromise.complete(value);
                }
            }

            public void onFailure(Throwable cause) {
                postCheckedPromise.completeExceptionally(cause);
            }
        });
        return postCheckedPromise;
    }

    @VisibleForTesting
    Set<URI> getSubnamespaces() {
        return this.subNamespaces.keySet();
    }

    @VisibleForTesting
    void removeLogFromCache(String logName) {
        this.log2Locations.remove(logName);
    }

    private URI getSubNamespaceURI(String ns) throws URISyntaxException {
        return new URI(this.namespace.getScheme(), this.namespace.getUserInfo(), this.namespace.getHost(), this.namespace.getPort(), this.namespace.getPath() + "/" + ZNODE_SUB_NAMESPACES + "/" + ns, this.namespace.getQuery(), this.namespace.getFragment());
    }

    CompletableFuture<Set<URI>> getCachedSubNamespaces() {
        Set nsSet = this.subNamespaces.keySet();
        return FutureUtils.value((Object)nsSet);
    }

    CompletableFuture<Set<URI>> fetchSubNamespaces(final Watcher watcher) {
        final CompletableFuture<Set<URI>> promise = new CompletableFuture<Set<URI>>();
        try {
            this.zkc.get().sync(this.zkSubnamespacesPath, new AsyncCallback.VoidCallback(){

                public void processResult(int rc, String path, Object ctx) {
                    if (KeeperException.Code.OK.intValue() == rc) {
                        FederatedZKLogMetadataStore.this.fetchSubNamespaces(watcher, promise);
                    } else {
                        promise.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
                    }
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            promise.completeExceptionally(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            promise.completeExceptionally(e);
        }
        return promise;
    }

    private void fetchSubNamespaces(Watcher watcher, final CompletableFuture<Set<URI>> promise) {
        try {
            this.zkc.get().getChildren(this.zkSubnamespacesPath, watcher, new AsyncCallback.Children2Callback(){

                public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                    if (KeeperException.Code.NONODE.intValue() == rc) {
                        promise.completeExceptionally(new UnexpectedException("The subnamespaces don't exist for the federated namespace " + FederatedZKLogMetadataStore.this.namespace));
                    } else if (KeeperException.Code.OK.intValue() == rc) {
                        HashSet subnamespaces = Sets.newHashSet();
                        subnamespaces.add(FederatedZKLogMetadataStore.this.namespace);
                        try {
                            for (String ns : children) {
                                subnamespaces.add(FederatedZKLogMetadataStore.this.getSubNamespaceURI(ns));
                            }
                        }
                        catch (URISyntaxException use) {
                            logger.error("Invalid sub namespace uri found : ", (Throwable)use);
                            promise.completeExceptionally(new UnexpectedException("Invalid sub namespace uri found in " + FederatedZKLogMetadataStore.this.namespace, (Throwable)use));
                            return;
                        }
                        FederatedZKLogMetadataStore.this.setZkSubnamespacesVersion(stat.getVersion());
                        promise.complete(subnamespaces);
                    }
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            promise.completeExceptionally(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            promise.completeExceptionally(e);
        }
    }

    @Override
    public void run() {
        this.fetchSubNamespaces(this).whenComplete((BiConsumer)((Object)this));
    }

    public void onSuccess(Set<URI> uris) {
        for (URI uri : uris) {
            SubNamespace subNs;
            if (this.subNamespaces.containsKey(uri) || null != this.subNamespaces.putIfAbsent(uri, subNs = new SubNamespace(uri))) continue;
            subNs.watch();
            logger.info("Watched new sub namespace {}.", (Object)uri);
            this.notifyOnNamespaceChanges();
        }
    }

    public void onFailure(Throwable cause) {
        this.scheduleTask(this, this.conf.getZKSessionTimeoutMilliseconds());
    }

    public void process(WatchedEvent watchedEvent) {
        if (Watcher.Event.EventType.None == watchedEvent.getType() && Watcher.Event.KeeperState.Expired == watchedEvent.getState()) {
            this.scheduleTask(this, this.conf.getZKSessionTimeoutMilliseconds());
            return;
        }
        if (Watcher.Event.EventType.NodeChildrenChanged == watchedEvent.getType()) {
            this.fetchSubNamespaces(this).whenComplete((BiConsumer)((Object)this));
        }
    }

    private <T> CompletableFuture<T> duplicatedLogException(String logName) {
        return FutureUtils.exception((Throwable)new UnexpectedException("Duplicated log " + logName + " found in namespace " + this.namespace));
    }

    @Override
    public CompletableFuture<URI> createLog(String logName) {
        if (this.duplicatedLogFound.get()) {
            return this.duplicatedLogException(this.duplicatedLogName.get());
        }
        CompletableFuture<URI> createPromise = new CompletableFuture<URI>();
        this.doCreateLog(logName, createPromise);
        return this.postStateCheck(createPromise);
    }

    void doCreateLog(final String logName, final CompletableFuture<URI> createPromise) {
        this.getLogLocation(logName).whenComplete((BiConsumer)new FutureEventListener<Optional<URI>>(){

            public void onSuccess(Optional<URI> uriOptional) {
                if (uriOptional.isPresent()) {
                    createPromise.completeExceptionally((Throwable)new LogExistsException("Log " + logName + " already exists in " + uriOptional.get()));
                } else {
                    FederatedZKLogMetadataStore.this.getCachedSubNamespacesAndCreateLog(logName, createPromise);
                }
            }

            public void onFailure(Throwable cause) {
                createPromise.completeExceptionally(cause);
            }
        });
    }

    private void getCachedSubNamespacesAndCreateLog(final String logName, final CompletableFuture<URI> createPromise) {
        this.getCachedSubNamespaces().whenComplete((BiConsumer)new FutureEventListener<Set<URI>>(){

            public void onSuccess(Set<URI> uris) {
                FederatedZKLogMetadataStore.this.findSubNamespaceToCreateLog(logName, uris, createPromise);
            }

            public void onFailure(Throwable cause) {
                createPromise.completeExceptionally(cause);
            }
        });
    }

    private void fetchSubNamespacesAndCreateLog(final String logName, final CompletableFuture<URI> createPromise) {
        this.fetchSubNamespaces(null).whenComplete((BiConsumer)new FutureEventListener<Set<URI>>(){

            public void onSuccess(Set<URI> uris) {
                FederatedZKLogMetadataStore.this.findSubNamespaceToCreateLog(logName, uris, createPromise);
            }

            public void onFailure(Throwable cause) {
                createPromise.completeExceptionally(cause);
            }
        });
    }

    private void findSubNamespaceToCreateLog(final String logName, Set<URI> uris, final CompletableFuture<URI> createPromise) {
        final ArrayList uriList = Lists.newArrayListWithExpectedSize((int)uris.size());
        ArrayList futureList = Lists.newArrayListWithExpectedSize((int)uris.size());
        for (URI uri : uris) {
            SubNamespace subNs = this.subNamespaces.get(uri);
            if (null == subNs) {
                createPromise.completeExceptionally(new UnexpectedException("No sub namespace " + uri + " found"));
                return;
            }
            futureList.add(subNs.getLogs());
            uriList.add(uri);
        }
        FutureUtils.collect((List)futureList).whenComplete((BiConsumer)new FutureEventListener<List<Set<String>>>(){

            public void onSuccess(List<Set<String>> resultList) {
                for (int i = resultList.size() - 1; i >= 0; --i) {
                    Set<String> logs = resultList.get(i);
                    if (logs.size() >= FederatedZKLogMetadataStore.this.maxLogsPerSubnamespace) continue;
                    URI uri = (URI)uriList.get(i);
                    FederatedZKLogMetadataStore.this.createLogInNamespace(uri, logName, createPromise);
                    return;
                }
                FederatedZKLogMetadataStore.this.createSubNamespace().whenComplete((BiConsumer)new FutureEventListener<URI>(){

                    public void onSuccess(URI uri) {
                        FederatedZKLogMetadataStore.this.createLogInNamespace(uri, logName, createPromise);
                    }

                    public void onFailure(Throwable cause) {
                        createPromise.completeExceptionally(cause);
                    }
                });
            }

            public void onFailure(Throwable cause) {
                createPromise.completeExceptionally(cause);
            }
        });
    }

    private String getNamespaceFromZkPath(String zkPath) throws UnexpectedException {
        String[] parts = zkPath.split(SUB_NAMESPACE_PREFIX);
        if (parts.length <= 0) {
            throw new UnexpectedException("Invalid namespace @ " + zkPath);
        }
        return SUB_NAMESPACE_PREFIX + parts[parts.length - 1];
    }

    CompletableFuture<URI> createSubNamespace() {
        final CompletableFuture<URI> promise = new CompletableFuture<URI>();
        String nsPath = this.namespace.getPath() + "/" + ZNODE_SUB_NAMESPACES + "/" + SUB_NAMESPACE_PREFIX;
        try {
            this.zkc.get().create(nsPath, new byte[0], this.zkc.getDefaultACL(), CreateMode.PERSISTENT_SEQUENTIAL, new AsyncCallback.StringCallback(){

                public void processResult(int rc, String path, Object ctx, String name) {
                    if (KeeperException.Code.OK.intValue() == rc) {
                        try {
                            URI newUri = FederatedZKLogMetadataStore.this.getSubNamespaceURI(FederatedZKLogMetadataStore.this.getNamespaceFromZkPath(name));
                            logger.info("Created sub namespace {}", (Object)newUri);
                            promise.complete(newUri);
                        }
                        catch (UnexpectedException ue) {
                            promise.completeExceptionally(ue);
                        }
                        catch (URISyntaxException e) {
                            promise.completeExceptionally(new UnexpectedException("Invalid namespace " + name + " is created."));
                        }
                    } else {
                        promise.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
                    }
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            promise.completeExceptionally(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            promise.completeExceptionally(e);
        }
        return promise;
    }

    private void createLogInNamespace(final URI uri, final String logName, final CompletableFuture<URI> createPromise) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    FederatedZKLogMetadataStore.this.createLogInNamespaceSync(uri, logName);
                    createPromise.complete(uri);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    createPromise.completeExceptionally(e);
                }
                catch (IOException e) {
                    createPromise.completeExceptionally(e);
                }
                catch (KeeperException.BadVersionException bve) {
                    FederatedZKLogMetadataStore.this.fetchSubNamespacesAndCreateLog(logName, createPromise);
                }
                catch (KeeperException e) {
                    createPromise.completeExceptionally(e);
                }
            }
        });
    }

    void createLogInNamespaceSync(URI uri, String logName) throws InterruptedException, IOException, KeeperException {
        Transaction txn = this.zkc.get().transaction();
        int zkVersion = null == this.zkSubnamespacesVersion.get() ? 0 : this.zkSubnamespacesVersion.get();
        txn.setData(this.zkSubnamespacesPath, uri.getPath().getBytes(StandardCharsets.UTF_8), zkVersion);
        String logPath = uri.getPath() + "/" + logName;
        txn.create(logPath, new byte[0], this.zkc.getDefaultACL(), CreateMode.PERSISTENT);
        try {
            txn.commit();
            this.setZkSubnamespacesVersion(zkVersion + 1);
        }
        catch (KeeperException ke) {
            OpResult setResult;
            List opResults = ke.getResults();
            OpResult createResult = (OpResult)opResults.get(1);
            if (createResult instanceof OpResult.ErrorResult) {
                OpResult.ErrorResult errorResult = (OpResult.ErrorResult)createResult;
                if (KeeperException.Code.NODEEXISTS.intValue() == errorResult.getErr()) {
                    throw new LogExistsException("Log " + logName + " already exists");
                }
            }
            if ((setResult = (OpResult)opResults.get(0)) instanceof OpResult.ErrorResult) {
                OpResult.ErrorResult errorResult = (OpResult.ErrorResult)setResult;
                if (KeeperException.Code.BADVERSION.intValue() == errorResult.getErr()) {
                    throw KeeperException.create((KeeperException.Code)KeeperException.Code.BADVERSION);
                }
            }
            throw new ZKException("ZK exception in creating log " + logName + " in " + uri, ke);
        }
    }

    void setZkSubnamespacesVersion(int zkVersion) {
        boolean done = false;
        while (!done) {
            Integer oldVersion = this.zkSubnamespacesVersion.get();
            if (null == oldVersion) {
                done = this.zkSubnamespacesVersion.compareAndSet(null, zkVersion);
                continue;
            }
            if (oldVersion < zkVersion) {
                done = this.zkSubnamespacesVersion.compareAndSet(oldVersion, zkVersion);
                continue;
            }
            done = true;
        }
    }

    @Override
    public CompletableFuture<Optional<URI>> getLogLocation(String logName) {
        if (this.duplicatedLogFound.get()) {
            return this.duplicatedLogException(this.duplicatedLogName.get());
        }
        URI location = (URI)this.log2Locations.get(logName);
        if (null != location) {
            return this.postStateCheck(FutureUtils.value(Optional.of(location)));
        }
        if (!this.forceCheckLogExistence) {
            Optional result = Optional.empty();
            return FutureUtils.value(result);
        }
        return this.postStateCheck((CompletableFuture)this.fetchLogLocation(logName).thenApply(uriOptional -> {
            if (uriOptional.isPresent()) {
                this.log2Locations.putIfAbsent(logName, (URI)uriOptional.get());
            }
            return uriOptional;
        }));
    }

    private CompletableFuture<Optional<URI>> fetchLogLocation(final String logName) {
        final CompletableFuture<Optional<URI>> fetchPromise = new CompletableFuture<Optional<URI>>();
        Set uris = this.subNamespaces.keySet();
        ArrayList fetchFutures = Lists.newArrayListWithExpectedSize((int)uris.size());
        for (URI uri : uris) {
            fetchFutures.add(this.fetchLogLocation(uri, logName));
        }
        FutureUtils.collect((List)fetchFutures).whenComplete((BiConsumer)new FutureEventListener<List<Optional<URI>>>(){

            public void onSuccess(List<Optional<URI>> fetchResults) {
                Optional<Object> result = Optional.empty();
                for (Optional<URI> fetchResult : fetchResults) {
                    if (result.isPresent()) {
                        if (!fetchResult.isPresent()) continue;
                        logger.error("Log {} is found in multiple sub namespaces : {} & {}.", new Object[]{logName, result.get(), fetchResult.get()});
                        FederatedZKLogMetadataStore.this.duplicatedLogName.compareAndSet(null, logName);
                        FederatedZKLogMetadataStore.this.duplicatedLogFound.set(true);
                        fetchPromise.completeExceptionally((Throwable)new UnexpectedException("Log " + logName + " is found in multiple sub namespaces : " + result.get() + " & " + fetchResult.get()));
                        return;
                    }
                    result = fetchResult;
                }
                fetchPromise.complete(result);
            }

            public void onFailure(Throwable cause) {
                fetchPromise.completeExceptionally(cause);
            }
        });
        return fetchPromise;
    }

    private CompletableFuture<Optional<URI>> fetchLogLocation(final URI uri, String logName) {
        final CompletableFuture<Optional<URI>> fetchPromise = new CompletableFuture<Optional<URI>>();
        String logRootPath = uri.getPath() + "/" + logName;
        try {
            this.zkc.get().exists(logRootPath, false, new AsyncCallback.StatCallback(){

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    if (KeeperException.Code.OK.intValue() == rc) {
                        fetchPromise.complete(Optional.of(uri));
                    } else if (KeeperException.Code.NONODE.intValue() == rc) {
                        fetchPromise.complete(Optional.empty());
                    } else {
                        fetchPromise.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
                    }
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            fetchPromise.completeExceptionally(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            fetchPromise.completeExceptionally(e);
        }
        return fetchPromise;
    }

    @Override
    public CompletableFuture<Iterator<String>> getLogs(String logNamePrefix) {
        if (!"".equals(logNamePrefix)) {
            return FutureUtils.exception((Throwable)new UnexpectedException("Get logs by prefix is not supported by federated metadata store"));
        }
        if (this.duplicatedLogFound.get()) {
            return this.duplicatedLogException(this.duplicatedLogName.get());
        }
        return this.postStateCheck((CompletableFuture)this.retrieveLogs().thenApply(resultList -> this.getIterator((List<Set<String>>)resultList)));
    }

    private CompletableFuture<List<Set<String>>> retrieveLogs() {
        Collection<SubNamespace> subNss = this.subNamespaces.values();
        ArrayList logsList = Lists.newArrayListWithExpectedSize((int)subNss.size());
        for (SubNamespace subNs : subNss) {
            logsList.add(subNs.getLogs());
        }
        return FutureUtils.collect((List)logsList);
    }

    private Iterator<String> getIterator(List<Set<String>> resultList) {
        ArrayList iterList = Lists.newArrayListWithExpectedSize((int)resultList.size());
        for (Set<String> result : resultList) {
            iterList.add(result.iterator());
        }
        return Iterators.concat(iterList.iterator());
    }

    @Override
    public void registerNamespaceListener(NamespaceListener listener) {
        this.registerListener(listener);
    }

    @Override
    protected void watchNamespaceChanges() {
    }

    private void notifyOnNamespaceChanges() {
        this.retrieveLogs().thenAccept(resultList -> {
            for (NamespaceListener listener : this.listeners) {
                listener.onStreamsChanged(this.getIterator((List<Set<String>>)resultList));
            }
        });
    }

    class SubNamespace
    implements NamespaceListener {
        final URI uri;
        final ZKNamespaceWatcher watcher;
        CompletableFuture<Set<String>> logsFuture = new CompletableFuture();

        SubNamespace(URI uri) {
            this.uri = uri;
            this.watcher = new ZKNamespaceWatcher(FederatedZKLogMetadataStore.this.conf, uri, FederatedZKLogMetadataStore.this.zkc, FederatedZKLogMetadataStore.this.scheduler);
            this.watcher.registerListener(this);
        }

        void watch() {
            this.watcher.watchNamespaceChanges();
        }

        synchronized CompletableFuture<Set<String>> getLogs() {
            return this.logsFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStreamsChanged(Iterator<String> newLogsIter) {
            CompletableFuture<Set<String>> newLogsPromise;
            HashSet newLogs = Sets.newHashSet(newLogsIter);
            Set oldLogs = Sets.newHashSet();
            SubNamespace subNamespace = this;
            synchronized (subNamespace) {
                if (this.logsFuture.isDone()) {
                    try {
                        oldLogs = (Set)FutureUtils.result(this.logsFuture);
                    }
                    catch (Exception e) {
                        logger.error("Unexpected exception when getting logs from a satisified future of {} : ", (Object)this.uri, (Object)e);
                    }
                    this.logsFuture = new CompletableFuture();
                }
                for (String logName : newLogs) {
                    URI oldURI = FederatedZKLogMetadataStore.this.log2Locations.putIfAbsent(logName, this.uri);
                    if (null == oldURI || Objects.equal((Object)this.uri, (Object)oldURI)) continue;
                    logger.error("Log {} is found duplicated in multiple locations : old location = {}, new location = {}", new Object[]{logName, oldURI, this.uri});
                    FederatedZKLogMetadataStore.this.duplicatedLogFound.set(true);
                }
                Sets.SetView deletedLogs = Sets.difference((Set)oldLogs, (Set)newLogs);
                for (String logName : deletedLogs) {
                    FederatedZKLogMetadataStore.this.log2Locations.remove(logName, this.uri);
                }
                newLogsPromise = this.logsFuture;
            }
            newLogsPromise.complete(newLogs);
            FederatedZKLogMetadataStore.this.notifyOnNamespaceChanges();
        }
    }
}

