/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.bookkeeper.bookie.Cookie;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryBookieService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(RecoveryBookieService.class);
    protected ServerConfiguration conf;
    protected BookKeeperAdmin bka;
    protected ExecutorService executor;

    public RecoveryBookieService(ServerConfiguration conf, BookKeeperAdmin bka, ExecutorService executor) {
        Preconditions.checkNotNull((Object)((Object)conf));
        this.conf = conf;
        this.bka = bka;
        this.executor = executor;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        RecoveryRequestJsonBody requestJsonBody;
        HttpServiceResponse response = new HttpServiceResponse();
        String requestBody = request.getBody();
        if (requestBody == null) {
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("No request body provide.");
            return response;
        }
        try {
            requestJsonBody = (RecoveryRequestJsonBody)JsonUtil.fromJson((String)requestBody, RecoveryRequestJsonBody.class);
            LOG.debug("bookie_src: [" + requestJsonBody.bookieSrc.get(0) + "],  delete_cookie: [" + requestJsonBody.deleteCookie + "]");
        }
        catch (JsonUtil.ParseJsonException e) {
            LOG.error("Meet Exception: ", (Throwable)e);
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("ERROR parameters: " + e.getMessage());
            return response;
        }
        if (HttpServer.Method.PUT == request.getMethod() && !requestJsonBody.bookieSrc.isEmpty()) {
            MetadataDrivers.runFunctionWithRegistrationManager(this.conf, rm -> {
                String[] bookieSrcString = requestJsonBody.bookieSrc.get(0).split(":");
                BookieSocketAddress bookieSrc = new BookieSocketAddress(bookieSrcString[0], Integer.parseInt(bookieSrcString[1]));
                boolean deleteCookie = requestJsonBody.deleteCookie;
                this.executor.execute(() -> {
                    try {
                        LOG.info("Start recovering bookie.");
                        this.bka.recoverBookieData(bookieSrc);
                        if (deleteCookie) {
                            Versioned<Cookie> cookie = Cookie.readFromRegistrationManager(rm, bookieSrc);
                            cookie.getValue().deleteFromRegistrationManager((RegistrationManager)rm, bookieSrc, cookie.getVersion());
                        }
                        LOG.info("Complete recovering bookie");
                    }
                    catch (Exception e) {
                        LOG.error("Exception occurred while recovering bookie", (Throwable)e);
                    }
                });
                return null;
            });
            response.setCode(HttpServer.StatusCode.OK);
            response.setBody("Success send recovery request command.");
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be PUT method");
        return response;
    }

    static class RecoveryRequestJsonBody {
        @JsonProperty(value="bookie_src")
        public List<String> bookieSrc;
        @JsonProperty(value="delete_cookie")
        public boolean deleteCookie;

        RecoveryRequestJsonBody() {
        }
    }
}

