/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.logsegment;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.Entry;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.exceptions.BKTransmitException;
import org.apache.distributedlog.exceptions.DLIllegalStateException;
import org.apache.distributedlog.exceptions.DLInterruptedException;
import org.apache.distributedlog.exceptions.EndOfLogSegmentException;
import org.apache.distributedlog.exceptions.ReadCancelledException;
import org.apache.distributedlog.impl.logsegment.BKUtils;
import org.apache.distributedlog.injector.AsyncFailureInjector;
import org.apache.distributedlog.logsegment.LogSegmentEntryReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BKLogSegmentEntryReader
implements SafeRunnable,
LogSegmentEntryReader,
AsyncCallback.OpenCallback {
    private static final Logger logger = LoggerFactory.getLogger(BKLogSegmentEntryReader.class);
    private final BookKeeper bk;
    private final DistributedLogConfiguration conf;
    private final OrderedScheduler scheduler;
    private final long lssn;
    private final long startSequenceId;
    private final boolean envelopeEntries;
    private final boolean deserializeRecordSet;
    private final int numPrefetchEntries;
    private final int maxPrefetchEntries;
    private CompletableFuture<Void> closePromise = null;
    private LogSegmentMetadata metadata;
    private LedgerHandle lh;
    private final List<LedgerHandle> openLedgerHandles;
    private CacheEntry outstandingLongPoll;
    private long nextEntryId;
    private static final AtomicReferenceFieldUpdater<BKLogSegmentEntryReader, Throwable> lastExceptionUpdater = AtomicReferenceFieldUpdater.newUpdater(BKLogSegmentEntryReader.class, Throwable.class, "lastException");
    private volatile Throwable lastException = null;
    private static final AtomicLongFieldUpdater<BKLogSegmentEntryReader> scheduleCountUpdater = AtomicLongFieldUpdater.newUpdater(BKLogSegmentEntryReader.class, "scheduleCount");
    private volatile long scheduleCount = 0L;
    private volatile boolean hasCaughtupOnInprogress = false;
    private final CopyOnWriteArraySet<LogSegmentEntryReader.StateChangeListener> stateChangeListeners = new CopyOnWriteArraySet();
    private int readAheadWaitTime;
    private final int maxReadBackoffTime;
    private static final AtomicIntegerFieldUpdater<BKLogSegmentEntryReader> numReadErrorsUpdater = AtomicIntegerFieldUpdater.newUpdater(BKLogSegmentEntryReader.class, "numReadErrors");
    private volatile int numReadErrors = 0;
    private final boolean skipBrokenEntries;
    int cachedEntries = 0;
    int numOutstandingEntries = 0;
    final LinkedBlockingQueue<CacheEntry> readAheadEntries;
    final LinkedList<PendingReadRequest> readQueue;
    private final AsyncFailureInjector failureInjector;
    private final Counter skippedBrokenEntriesCounter;

    BKLogSegmentEntryReader(LogSegmentMetadata metadata, LedgerHandle lh, long startEntryId, BookKeeper bk, OrderedScheduler scheduler, DistributedLogConfiguration conf, StatsLogger statsLogger, AsyncFailureInjector failureInjector) {
        this.metadata = metadata;
        this.lssn = metadata.getLogSegmentSequenceNumber();
        this.startSequenceId = metadata.getStartSequenceId();
        this.envelopeEntries = metadata.getEnvelopeEntries();
        this.deserializeRecordSet = conf.getDeserializeRecordSetOnReads();
        this.lh = lh;
        this.nextEntryId = Math.max(startEntryId, 0L);
        this.bk = bk;
        this.conf = conf;
        this.numPrefetchEntries = conf.getNumPrefetchEntriesPerLogSegment();
        this.maxPrefetchEntries = conf.getMaxPrefetchEntriesPerLogSegment();
        this.scheduler = scheduler;
        this.openLedgerHandles = Lists.newArrayList();
        this.openLedgerHandles.add(lh);
        this.outstandingLongPoll = null;
        this.readAheadEntries = new LinkedBlockingQueue();
        this.readQueue = new LinkedList();
        this.readAheadWaitTime = conf.getReadAheadWaitTime();
        this.maxReadBackoffTime = 4 * conf.getReadAheadWaitTime();
        this.skipBrokenEntries = conf.getReadAheadSkipBrokenEntries();
        this.failureInjector = failureInjector;
        this.skippedBrokenEntriesCounter = statsLogger.getCounter("skipped_broken_entries");
    }

    @VisibleForTesting
    public synchronized CacheEntry getOutstandingLongPoll() {
        return this.outstandingLongPoll;
    }

    @VisibleForTesting
    LinkedBlockingQueue<CacheEntry> getReadAheadEntries() {
        return this.readAheadEntries;
    }

    synchronized LedgerHandle getLh() {
        return this.lh;
    }

    @Override
    public synchronized LogSegmentMetadata getSegment() {
        return this.metadata;
    }

    @VisibleForTesting
    synchronized long getNextEntryId() {
        return this.nextEntryId;
    }

    @Override
    public void start() {
        this.prefetchIfNecessary();
    }

    @Override
    public boolean hasCaughtUpOnInprogress() {
        return this.hasCaughtupOnInprogress;
    }

    @Override
    public LogSegmentEntryReader registerListener(LogSegmentEntryReader.StateChangeListener listener) {
        this.stateChangeListeners.add(listener);
        return this;
    }

    @Override
    public LogSegmentEntryReader unregisterListener(LogSegmentEntryReader.StateChangeListener listener) {
        this.stateChangeListeners.remove(listener);
        return this;
    }

    private void notifyCaughtupOnInprogress() {
        for (LogSegmentEntryReader.StateChangeListener listener : this.stateChangeListeners) {
            listener.onCaughtupOnInprogress();
        }
    }

    @Override
    public synchronized void onLogSegmentMetadataUpdated(LogSegmentMetadata segment) {
        if (this.metadata == segment || LogSegmentMetadata.COMPARATOR.compare(this.metadata, segment) == 0 || !this.metadata.isInProgress() || segment.isInProgress()) {
            return;
        }
        this.bk.asyncOpenLedger(segment.getLogSegmentId(), BookKeeper.DigestType.CRC32, this.conf.getBKDigestPW().getBytes(StandardCharsets.UTF_8), (AsyncCallback.OpenCallback)this, (Object)segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openComplete(int rc, LedgerHandle lh, Object ctx) {
        LogSegmentMetadata segment = (LogSegmentMetadata)ctx;
        if (0 != rc) {
            this.failOrRetryOpenLedger(rc, segment);
            return;
        }
        CacheEntry longPollRead = null;
        BKLogSegmentEntryReader bKLogSegmentEntryReader = this;
        synchronized (bKLogSegmentEntryReader) {
            if (this.isClosed()) {
                lh.asyncClose(new AsyncCallback.CloseCallback(){

                    public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
                        logger.debug("Close the open ledger {} since the log segment reader is already closed", (Object)lh.getId());
                    }
                }, null);
                return;
            }
            this.metadata = segment;
            this.lh = lh;
            this.openLedgerHandles.add(lh);
            longPollRead = this.outstandingLongPoll;
        }
        if (null != longPollRead) {
            this.issueRead(longPollRead);
        }
        this.notifyReaders();
    }

    private void failOrRetryOpenLedger(int rc, LogSegmentMetadata segment) {
        if (this.isClosed()) {
            return;
        }
        if (this.isBeyondLastAddConfirmed()) {
            this.completeExceptionally(new BKTransmitException("Failed to open ledger for reading log segment " + this.getSegment(), rc), true);
            return;
        }
        this.scheduler.scheduleOrdered((Object)segment.getLogSegmentId(), () -> this.onLogSegmentMetadataUpdated(segment), (long)this.conf.getZKRetryBackoffStartMillis(), TimeUnit.MILLISECONDS);
    }

    private boolean checkClosedOrInError() {
        Throwable cause = lastExceptionUpdater.get(this);
        if (null != cause) {
            this.cancelAllPendingReads(cause);
            return true;
        }
        return false;
    }

    private void completeExceptionally(Throwable throwable, boolean isBackground) {
        lastExceptionUpdater.compareAndSet(this, null, throwable);
        if (isBackground) {
            this.notifyReaders();
        }
    }

    private void notifyReaders() {
        this.processReadRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllPendingReads(Throwable throwExc) {
        ArrayList requestsToCancel;
        LinkedList<PendingReadRequest> linkedList = this.readQueue;
        synchronized (linkedList) {
            requestsToCancel = Lists.newArrayListWithExpectedSize((int)this.readQueue.size());
            requestsToCancel.addAll(this.readQueue);
            this.readQueue.clear();
        }
        for (PendingReadRequest request : requestsToCancel) {
            request.completeExceptionally(throwExc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAllCachedEntries() {
        BKLogSegmentEntryReader bKLogSegmentEntryReader = this;
        synchronized (bKLogSegmentEntryReader) {
            CacheEntry entry = this.readAheadEntries.poll();
            while (null != entry) {
                entry.release();
                entry = this.readAheadEntries.poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReadEntryDone(boolean success) {
        BKLogSegmentEntryReader bKLogSegmentEntryReader = this;
        synchronized (bKLogSegmentEntryReader) {
            --this.numOutstandingEntries;
        }
        this.notifyReaders();
        if (success) {
            this.prefetchIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEntriesConsumed(int numEntries) {
        BKLogSegmentEntryReader bKLogSegmentEntryReader = this;
        synchronized (bKLogSegmentEntryReader) {
            this.cachedEntries -= numEntries;
        }
        this.prefetchIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefetchIfNecessary() {
        ArrayList<CacheEntry> entriesToFetch;
        BKLogSegmentEntryReader bKLogSegmentEntryReader = this;
        synchronized (bKLogSegmentEntryReader) {
            if (this.cachedEntries >= this.maxPrefetchEntries) {
                return;
            }
            int numEntriesToFetch = this.numPrefetchEntries - this.numOutstandingEntries;
            if (numEntriesToFetch <= 0) {
                return;
            }
            entriesToFetch = new ArrayList<CacheEntry>(numEntriesToFetch);
            for (int i = 0; !(i >= numEntriesToFetch || this.cachedEntries >= this.maxPrefetchEntries || this.isLedgerClosed() && this.nextEntryId > this.getLastAddConfirmed() || !this.isLedgerClosed() && this.nextEntryId > this.getLastAddConfirmed() + 1L); ++i) {
                CacheEntry entry = new CacheEntry(this.nextEntryId);
                entriesToFetch.add(entry);
                this.readAheadEntries.add(entry);
                ++this.numOutstandingEntries;
                ++this.cachedEntries;
                ++this.nextEntryId;
            }
        }
        for (CacheEntry entry : entriesToFetch) {
            this.issueRead(entry);
        }
    }

    private void issueRead(CacheEntry cacheEntry) {
        if (this.isClosed()) {
            return;
        }
        if (this.isLedgerClosed()) {
            if (this.isNotBeyondLastAddConfirmed(cacheEntry.getEntryId())) {
                this.issueSimpleRead(cacheEntry);
                return;
            }
            this.notifyReaders();
        } else if (this.isNotBeyondLastAddConfirmed(cacheEntry.getEntryId())) {
            this.issueSimpleRead(cacheEntry);
        } else {
            this.issueLongPollRead(cacheEntry);
        }
    }

    private void issueSimpleRead(CacheEntry cacheEntry) {
        this.getLh().asyncReadEntries(cacheEntry.entryId, cacheEntry.entryId, (AsyncCallback.ReadCallback)cacheEntry, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void issueLongPollRead(CacheEntry cacheEntry) {
        BKLogSegmentEntryReader bKLogSegmentEntryReader = this;
        synchronized (bKLogSegmentEntryReader) {
            this.outstandingLongPoll = cacheEntry;
        }
        if (!this.hasCaughtupOnInprogress) {
            this.hasCaughtupOnInprogress = true;
            this.notifyCaughtupOnInprogress();
        }
        this.getLh().asyncReadLastConfirmedAndEntry(cacheEntry.entryId, (long)this.conf.getReadLACLongPollTimeout(), false, (AsyncCallback.ReadLastConfirmedAndEntryCallback)cacheEntry, null);
    }

    Entry.Reader processReadEntry(LedgerEntry entry) throws IOException {
        return Entry.newBuilder().setLogSegmentInfo(this.lssn, this.startSequenceId).setEntryId(entry.getEntryId()).setEnvelopeEntry(this.envelopeEntries).deserializeRecordSet(this.deserializeRecordSet).setEntry(entry.getEntryBuffer()).buildReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<List<Entry.Reader>> readNext(int numEntries) {
        PendingReadRequest readRequest = new PendingReadRequest(numEntries);
        if (this.checkClosedOrInError()) {
            readRequest.completeExceptionally(lastExceptionUpdater.get(this));
        } else {
            boolean wasQueueEmpty;
            LinkedList<PendingReadRequest> linkedList = this.readQueue;
            synchronized (linkedList) {
                wasQueueEmpty = this.readQueue.isEmpty();
                this.readQueue.add(readRequest);
            }
            if (wasQueueEmpty) {
                this.processReadRequests();
            }
        }
        return readRequest.getPromise();
    }

    private void processReadRequests() {
        if (this.isClosed()) {
            return;
        }
        long prevCount = scheduleCountUpdater.getAndIncrement(this);
        if (0L == prevCount) {
            this.scheduler.executeOrdered(this.getSegment().getLogSegmentId(), (SafeRunnable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safeRun() {
        long scheduleCountLocal = scheduleCountUpdater.get(this);
        while (true) {
            PendingReadRequest nextRequest = null;
            LinkedList<PendingReadRequest> linkedList = this.readQueue;
            synchronized (linkedList) {
                nextRequest = this.readQueue.peek();
            }
            if (null == nextRequest) {
                scheduleCountUpdater.set(this, 0L);
                return;
            }
            if (null == lastExceptionUpdater.get(this) && nextRequest.getPromise().isCancelled()) {
                this.completeExceptionally(new DLInterruptedException("Interrupted on reading log segment " + this.getSegment() + " : " + nextRequest.getPromise().isCancelled()), false);
            }
            if (this.checkClosedOrInError()) {
                return;
            }
            this.readEntriesFromReadAheadCache(nextRequest);
            if (nextRequest.hasReadEntries()) {
                PendingReadRequest request;
                LinkedList<PendingReadRequest> linkedList2 = this.readQueue;
                synchronized (linkedList2) {
                    request = this.readQueue.poll();
                }
                if (null != request && nextRequest == request) {
                    request.complete();
                    continue;
                }
                DLIllegalStateException ise = new DLIllegalStateException("Unexpected condition at reading from " + this.getSegment());
                nextRequest.completeExceptionally((Throwable)ise);
                if (null != request) {
                    request.completeExceptionally((Throwable)ise);
                }
                this.completeExceptionally((Throwable)ise, false);
                continue;
            }
            if (0L == scheduleCountLocal) {
                return;
            }
            scheduleCountLocal = scheduleCountUpdater.decrementAndGet(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEntriesFromReadAheadCache(PendingReadRequest nextRequest) {
        while (!nextRequest.hasReadEnoughEntries()) {
            CacheEntry removedEntry;
            boolean hitEndOfLogSegment;
            CacheEntry entry;
            BKLogSegmentEntryReader bKLogSegmentEntryReader = this;
            synchronized (bKLogSegmentEntryReader) {
                entry = this.readAheadEntries.peek();
                hitEndOfLogSegment = null == entry && this.isEndOfLogSegment();
            }
            if (hitEndOfLogSegment) {
                this.completeExceptionally((Throwable)new EndOfLogSegmentException(this.getSegment().getZNodeName()), false);
                return;
            }
            if (null == entry) {
                return;
            }
            if (!entry.isDone()) {
                if (this.isEndOfLogSegment(entry.getEntryId())) {
                    this.completeExceptionally((Throwable)new EndOfLogSegmentException(this.getSegment().getZNodeName()), false);
                }
                return;
            }
            if (entry.isSuccess()) {
                removedEntry = this.readAheadEntries.poll();
                try {
                    if (entry != removedEntry) {
                        DLIllegalStateException ise = new DLIllegalStateException("Unexpected condition at reading from " + this.getSegment());
                        this.completeExceptionally((Throwable)ise, false);
                        return;
                    }
                    try {
                        nextRequest.addEntry(this.processReadEntry(entry.getEntry()));
                        continue;
                    }
                    catch (IOException e) {
                        this.completeExceptionally(e, false);
                        ReferenceCountUtil.safeRelease((Object)removedEntry);
                        return;
                    }
                }
                finally {
                    ReferenceCountUtil.safeRelease((Object)removedEntry);
                    continue;
                }
            }
            if (this.skipBrokenEntries && -5 == entry.getRc()) {
                this.skippedBrokenEntriesCounter.inc();
                removedEntry = this.readAheadEntries.poll();
                removedEntry.release();
                continue;
            }
            this.completeExceptionally(new BKTransmitException("Encountered issue on reading entry " + entry.getEntryId() + " @ log segment " + this.getSegment(), entry.getRc()), false);
            return;
        }
    }

    private synchronized boolean isEndOfLogSegment() {
        return this.isEndOfLogSegment(this.nextEntryId);
    }

    private boolean isEndOfLogSegment(long entryId) {
        return this.isLedgerClosed() && entryId > this.getLastAddConfirmed();
    }

    @Override
    public synchronized boolean isBeyondLastAddConfirmed() {
        return this.isBeyondLastAddConfirmed(this.nextEntryId);
    }

    private boolean isBeyondLastAddConfirmed(long entryId) {
        return entryId > this.getLastAddConfirmed();
    }

    private boolean isNotBeyondLastAddConfirmed(long entryId) {
        return entryId <= this.getLastAddConfirmed();
    }

    private boolean isLedgerClosed() {
        return this.getLh().isClosed();
    }

    @Override
    public long getLastAddConfirmed() {
        return this.getLh().getLastAddConfirmed();
    }

    synchronized boolean isClosed() {
        return null != this.closePromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> asyncClose() {
        ReadCancelledException exception;
        LedgerHandle[] lhsToClose;
        CompletableFuture<Void> closeFuture;
        BKLogSegmentEntryReader bKLogSegmentEntryReader = this;
        synchronized (bKLogSegmentEntryReader) {
            if (null != this.closePromise) {
                return this.closePromise;
            }
            this.closePromise = new CompletableFuture<Void>();
            closeFuture = this.closePromise;
            lhsToClose = this.openLedgerHandles.toArray(new LedgerHandle[this.openLedgerHandles.size()]);
            exception = new ReadCancelledException(this.getSegment().getZNodeName(), "Reader was closed");
            this.completeExceptionally((Throwable)exception, false);
        }
        this.releaseAllCachedEntries();
        this.cancelAllPendingReads((Throwable)exception);
        FutureUtils.proxyTo(BKUtils.closeLedgers(lhsToClose), closeFuture);
        return closeFuture;
    }

    private class PendingReadRequest {
        private final int numEntries;
        private final List<Entry.Reader> entries;
        private final CompletableFuture<List<Entry.Reader>> promise;

        PendingReadRequest(int numEntries) {
            this.numEntries = numEntries;
            this.entries = numEntries == 1 ? new ArrayList<Entry.Reader>(1) : new ArrayList<Entry.Reader>();
            this.promise = new CompletableFuture();
        }

        CompletableFuture<List<Entry.Reader>> getPromise() {
            return this.promise;
        }

        void completeExceptionally(Throwable throwable) {
            FutureUtils.completeExceptionally(this.promise, (Throwable)throwable);
        }

        void addEntry(Entry.Reader entry) {
            this.entries.add(entry);
        }

        void complete() {
            FutureUtils.complete(this.promise, this.entries);
            BKLogSegmentEntryReader.this.onEntriesConsumed(this.entries.size());
        }

        boolean hasReadEntries() {
            return this.entries.size() > 0;
        }

        boolean hasReadEnoughEntries() {
            return this.entries.size() >= this.numEntries;
        }
    }

    private class CacheEntry
    implements SafeRunnable,
    AsyncCallback.ReadCallback,
    AsyncCallback.ReadLastConfirmedAndEntryCallback {
        protected final long entryId;
        private boolean done;
        private LedgerEntry entry;
        private int rc;

        private CacheEntry(long entryId) {
            this.entryId = entryId;
            this.entry = null;
            this.rc = -999;
            this.done = false;
        }

        long getEntryId() {
            return this.entryId;
        }

        synchronized boolean isDone() {
            return this.done;
        }

        synchronized void release() {
            if (null != this.entry) {
                this.entry.getEntryBuffer().release();
                this.entry = null;
            }
        }

        void release(LedgerEntry entry) {
            if (null != entry) {
                entry.getEntryBuffer().release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete(LedgerEntry entry) {
            if (BKLogSegmentEntryReader.this.isClosed()) {
                this.release(entry);
            }
            CacheEntry cacheEntry = this;
            synchronized (cacheEntry) {
                if (this.done) {
                    return;
                }
                this.rc = 0;
                this.entry = entry;
            }
            this.setDone(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void completeExceptionally(int rc) {
            CacheEntry cacheEntry = this;
            synchronized (cacheEntry) {
                if (this.done) {
                    return;
                }
                this.rc = rc;
            }
            this.setDone(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDone(boolean success) {
            CacheEntry cacheEntry = this;
            synchronized (cacheEntry) {
                this.done = true;
            }
            BKLogSegmentEntryReader.this.onReadEntryDone(success);
        }

        synchronized boolean isSuccess() {
            return 0 == this.rc;
        }

        synchronized LedgerEntry getEntry() {
            this.entry.getEntryBuffer().retain();
            return this.entry;
        }

        synchronized int getRc() {
            return this.rc;
        }

        public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> entries, Object ctx) {
            if (BKLogSegmentEntryReader.this.failureInjector.shouldInjectCorruption(this.entryId, this.entryId)) {
                rc = -5;
            }
            this.processReadEntries(rc, lh, entries, ctx);
        }

        void processReadEntries(int rc, LedgerHandle lh, Enumeration<LedgerEntry> entries, Object ctx) {
            if (this.isDone()) {
                return;
            }
            if (!this.checkReturnCodeAndHandleFailure(rc, false)) {
                return;
            }
            LedgerEntry entry = null;
            while (entries.hasMoreElements()) {
                if (null != entry) {
                    this.completeExceptionally(-999);
                    return;
                }
                entry = entries.nextElement();
            }
            if (null == entry || entry.getEntryId() != this.entryId) {
                this.completeExceptionally(-999);
                return;
            }
            this.complete(entry);
        }

        public void readLastConfirmedAndEntryComplete(int rc, long entryId, LedgerEntry entry, Object ctx) {
            if (BKLogSegmentEntryReader.this.failureInjector.shouldInjectCorruption(this.entryId, this.entryId)) {
                rc = -5;
            }
            this.processReadEntry(rc, entryId, entry, ctx);
        }

        void processReadEntry(int rc, long entryId, LedgerEntry entry, Object ctx) {
            if (this.isDone()) {
                return;
            }
            if (!this.checkReturnCodeAndHandleFailure(rc, true)) {
                return;
            }
            if (null != entry && this.entryId == entryId) {
                this.complete(entry);
                return;
            }
            BKLogSegmentEntryReader.this.issueRead(this);
        }

        boolean checkReturnCodeAndHandleFailure(int rc, boolean isLongPoll) {
            if (0 == rc) {
                numReadErrorsUpdater.set(BKLogSegmentEntryReader.this, 0);
                return true;
            }
            if (-8 == rc || isLongPoll && -7 == rc) {
                int numErrors = Math.max(1, numReadErrorsUpdater.incrementAndGet(BKLogSegmentEntryReader.this));
                int nextReadBackoffTime = Math.min(numErrors * BKLogSegmentEntryReader.this.readAheadWaitTime, BKLogSegmentEntryReader.this.maxReadBackoffTime);
                BKLogSegmentEntryReader.this.scheduler.scheduleOrdered((Object)BKLogSegmentEntryReader.this.getSegment().getLogSegmentId(), (SafeRunnable)this, (long)nextReadBackoffTime, TimeUnit.MILLISECONDS);
            } else {
                this.completeExceptionally(rc);
            }
            return false;
        }

        public void safeRun() {
            BKLogSegmentEntryReader.this.issueRead(this);
        }
    }
}

