/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.Waiter;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.NetSocket;
import java.util.List;
import java.util.Objects;

public class HttpClientRequestImpl
extends HttpClientRequestBase
implements HttpClientRequest {
    private final VertxInternal vertx;
    private final int port;
    private Handler<HttpClientResponse> respHandler;
    private Handler<Void> endHandler;
    private boolean chunked = false;
    private String hostHeader;
    private String rawMethod;
    private Handler<Void> continueHandler;
    private HttpClientStream stream;
    private volatile Object lock;
    private Handler<Void> drainHandler;
    private Handler<HttpClientRequest> pushHandler;
    private Handler<HttpConnection> connectionHandler;
    private boolean headWritten;
    private boolean completed;
    private Handler<Void> completionHandler;
    private Long reset;
    private HttpClientResponseImpl response;
    private ByteBuf pendingChunks;
    private CompositeByteBuf cachedChunks;
    private int pendingMaxSize = -1;
    private int followRedirects;
    private boolean connecting;
    private boolean writeHead;
    private long written;
    private CaseInsensitiveHeaders headers;

    HttpClientRequestImpl(HttpClientImpl client, boolean ssl, HttpMethod method, String host, int port, String relativeURI, VertxInternal vertx) {
        super(client, ssl, method, host, port, relativeURI);
        this.vertx = vertx;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int streamId() {
        Object object = this.getLock();
        synchronized (object) {
            return this.stream != null ? this.stream.id() : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest handler(Handler<HttpClientResponse> handler) {
        Object object = this.getLock();
        synchronized (object) {
            if (handler != null) {
                this.checkComplete();
                this.respHandler = this.checkConnect(this.method, handler);
            } else {
                this.respHandler = null;
            }
            return this;
        }
    }

    @Override
    public HttpClientRequest pause() {
        return this;
    }

    @Override
    public HttpClientRequest resume() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest setFollowRedirects(boolean followRedirects) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.followRedirects = followRedirects ? this.client.getOptions().getMaxRedirects() - 1 : 0;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest endHandler(Handler<Void> endHandler) {
        Object object = this.getLock();
        synchronized (object) {
            if (endHandler != null) {
                this.checkComplete();
            }
            this.endHandler = endHandler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequestImpl setChunked(boolean chunked) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            if (this.written > 0L) {
                throw new IllegalStateException("Cannot set chunked after data has been written on request");
            }
            if (this.client.getOptions().getProtocolVersion() != HttpVersion.HTTP_1_0) {
                this.chunked = chunked;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChunked() {
        Object object = this.getLock();
        synchronized (object) {
            return this.chunked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRawMethod() {
        Object object = this.getLock();
        synchronized (object) {
            return this.rawMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest setRawMethod(String method) {
        Object object = this.getLock();
        synchronized (object) {
            this.rawMethod = method;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest setHost(String host) {
        Object object = this.getLock();
        synchronized (object) {
            this.hostHeader = host;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHost() {
        Object object = this.getLock();
        synchronized (object) {
            return this.hostHeader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap headers() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.headers == null) {
                this.headers = new CaseInsensitiveHeaders();
            }
            return this.headers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest putHeader(String name, String value) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.headers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.headers().set(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequestImpl write(Buffer chunk) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.checkResponseHandler();
            ByteBuf buf = chunk.getByteBuf();
            this.write(buf, false);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequestImpl write(String chunk) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.checkResponseHandler();
            return this.write(Buffer.buffer(chunk));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequestImpl write(String chunk, String enc) {
        Object object = this.getLock();
        synchronized (object) {
            Objects.requireNonNull(enc, "no null encoding accepted");
            this.checkComplete();
            this.checkResponseHandler();
            return this.write(Buffer.buffer(chunk, enc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            if (this.stream != null) {
                this.stream.doSetWriteQueueMaxSize(maxSize);
            } else {
                this.pendingMaxSize = maxSize;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            return this.stream != null && this.stream.isNotWritable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest drainHandler(Handler<Void> handler) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.drainHandler = handler;
            if (this.stream != null) {
                this.stream.getContext().runOnContext(v -> {
                    Object object = this.getLock();
                    synchronized (object) {
                        if (this.stream != null) {
                            this.stream.checkDrained();
                        }
                    }
                });
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest continueHandler(Handler<Void> handler) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.continueHandler = handler;
            return this;
        }
    }

    @Override
    public HttpClientRequest sendHead() {
        return this.sendHead(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest sendHead(Handler<HttpVersion> completionHandler) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.checkResponseHandler();
            if (this.stream != null) {
                if (!this.headWritten) {
                    this.writeHead();
                    if (completionHandler != null) {
                        completionHandler.handle(this.stream.version());
                    }
                }
            } else {
                this.connect(completionHandler);
                this.writeHead = true;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(String chunk) {
        Object object = this.getLock();
        synchronized (object) {
            this.end(Buffer.buffer(chunk));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(String chunk, String enc) {
        Object object = this.getLock();
        synchronized (object) {
            Objects.requireNonNull(enc, "no null encoding accepted");
            this.end(Buffer.buffer(chunk, enc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Buffer chunk) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.checkResponseHandler();
            this.write(chunk.getByteBuf(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.checkResponseHandler();
            this.write(null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.headers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.headers().set(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
        Object object = this.getLock();
        synchronized (object) {
            this.pushHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reset(long code) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.reset == null) {
                this.reset = code;
                if (!this.completed) {
                    this.completed = true;
                    if (this.stream != null) {
                        this.stream.resetRequest(code);
                    }
                    if (this.completionHandler != null) {
                        this.completionHandler.handle(null);
                    }
                } else if (this.response != null) {
                    this.stream.resetResponse(code);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpConnection connection() {
        Object object = this.getLock();
        synchronized (object) {
            return this.stream != null ? this.stream.connection() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest connectionHandler(@Nullable Handler<HttpConnection> handler) {
        Object object = this.getLock();
        synchronized (object) {
            this.connectionHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.stream == null) {
                throw new IllegalStateException("Not yet connected");
            }
            this.stream.writeFrame(type, flags, payload.getByteBuf());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDrained() {
        Object object = this.getLock();
        synchronized (object) {
            if (!this.completed && this.drainHandler != null) {
                try {
                    this.drainHandler.handle(null);
                }
                catch (Throwable t) {
                    this.handleException(t);
                }
            }
        }
    }

    private void handleNextRequest(HttpClientResponse resp, HttpClientRequestImpl next, long timeoutMs) {
        CompositeByteBuf body;
        next.handler((Handler)this.respHandler);
        next.exceptionHandler((Handler)this.exceptionHandler());
        this.exceptionHandler((Handler)null);
        next.endHandler((Handler)this.endHandler);
        next.pushHandler = this.pushHandler;
        next.followRedirects = this.followRedirects - 1;
        next.written = this.written;
        if (next.hostHeader == null) {
            next.hostHeader = this.hostHeader;
        }
        if (this.headers != null && next.headers == null) {
            next.headers().addAll(this.headers);
        }
        switch (next.method) {
            case GET: {
                body = null;
                break;
            }
            case OTHER: {
                next.rawMethod = this.rawMethod;
                body = null;
                break;
            }
            default: {
                body = this.cachedChunks != null ? this.cachedChunks : null;
            }
        }
        this.cachedChunks = null;
        Future fut = Future.future();
        fut.setHandler(arg_0 -> HttpClientRequestImpl.lambda$handleNextRequest$1(timeoutMs, next, (ByteBuf)body, arg_0));
        if (this.exceptionOccurred != null) {
            fut.fail(this.exceptionOccurred);
        } else if (this.completed) {
            fut.complete();
        } else {
            this.exceptionHandler(err -> {
                if (!fut.isComplete()) {
                    fut.fail((Throwable)err);
                }
            });
            this.completionHandler = v -> {
                if (!fut.isComplete()) {
                    fut.complete();
                }
            };
        }
    }

    @Override
    protected void doHandleResponse(HttpClientResponseImpl resp, long timeoutMs) {
        if (this.reset != null) {
            this.stream.resetResponse(this.reset);
        } else {
            Future<HttpClientRequest> next;
            this.response = resp;
            int statusCode = resp.statusCode();
            if (this.followRedirects > 0 && statusCode >= 300 && statusCode < 400 && (next = this.client.redirectHandler().apply(resp)) != null) {
                next.setHandler(ar -> {
                    if (ar.succeeded()) {
                        this.handleNextRequest(resp, (HttpClientRequestImpl)ar.result(), timeoutMs);
                    } else {
                        this.handleException(ar.cause());
                    }
                });
                return;
            }
            if (statusCode == 100) {
                if (this.continueHandler != null) {
                    this.continueHandler.handle(null);
                }
            } else {
                if (this.respHandler != null) {
                    this.respHandler.handle(resp);
                }
                if (this.endHandler != null) {
                    this.endHandler.handle(null);
                }
            }
        }
    }

    @Override
    protected String hostHeader() {
        return this.hostHeader != null ? this.hostHeader : super.hostHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getLock() {
        if (this.lock != null) {
            return this.lock;
        }
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (this.lock != null) {
                return this.lock;
            }
            return this;
        }
    }

    private Handler<HttpClientResponse> checkConnect(HttpMethod method, Handler<HttpClientResponse> handler) {
        if (method == HttpMethod.CONNECT) {
            handler = this.connectHandler(handler);
        }
        return handler;
    }

    private Handler<HttpClientResponse> connectHandler(Handler<HttpClientResponse> responseHandler) {
        Objects.requireNonNull(responseHandler, "no null responseHandler accepted");
        return resp -> {
            HttpClientResponse response;
            if (resp.statusCode() == 200) {
                NetSocket socket = resp.netSocket();
                socket.pause();
                response = new HttpClientResponse((HttpClientResponse)resp, socket){
                    private boolean resumed;
                    final /* synthetic */ HttpClientResponse val$resp;
                    final /* synthetic */ NetSocket val$socket;
                    {
                        this.val$resp = httpClientResponse;
                        this.val$socket = netSocket;
                    }

                    @Override
                    public HttpClientRequest request() {
                        return this.val$resp.request();
                    }

                    @Override
                    public int statusCode() {
                        return this.val$resp.statusCode();
                    }

                    @Override
                    public String statusMessage() {
                        return this.val$resp.statusMessage();
                    }

                    @Override
                    public MultiMap headers() {
                        return this.val$resp.headers();
                    }

                    @Override
                    public String getHeader(String headerName) {
                        return this.val$resp.getHeader(headerName);
                    }

                    @Override
                    public String getHeader(CharSequence headerName) {
                        return this.val$resp.getHeader(headerName);
                    }

                    @Override
                    public String getTrailer(String trailerName) {
                        return this.val$resp.getTrailer(trailerName);
                    }

                    @Override
                    public MultiMap trailers() {
                        return this.val$resp.trailers();
                    }

                    @Override
                    public List<String> cookies() {
                        return this.val$resp.cookies();
                    }

                    @Override
                    public HttpVersion version() {
                        return this.val$resp.version();
                    }

                    @Override
                    public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) {
                        this.val$resp.bodyHandler(bodyHandler);
                        return this;
                    }

                    @Override
                    public HttpClientResponse customFrameHandler(Handler<HttpFrame> handler) {
                        this.val$resp.customFrameHandler(handler);
                        return this;
                    }

                    @Override
                    public synchronized NetSocket netSocket() {
                        if (!this.resumed) {
                            this.resumed = true;
                            HttpClientRequestImpl.this.vertx.getContext().runOnContext(v -> this.val$socket.resume());
                        }
                        return this.val$socket;
                    }

                    @Override
                    public HttpClientResponse endHandler(Handler<Void> endHandler) {
                        this.val$resp.endHandler((Handler)endHandler);
                        return this;
                    }

                    @Override
                    public HttpClientResponse handler(Handler<Buffer> handler) {
                        this.val$resp.handler((Handler)handler);
                        return this;
                    }

                    @Override
                    public HttpClientResponse pause() {
                        this.val$resp.pause();
                        return this;
                    }

                    @Override
                    public HttpClientResponse resume() {
                        this.val$resp.resume();
                        return this;
                    }

                    @Override
                    public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
                        this.val$resp.exceptionHandler((Handler)handler);
                        return this;
                    }
                };
            } else {
                response = resp;
            }
            responseHandler.handle(response);
        };
    }

    private synchronized void connect(final Handler<HttpVersion> headersCompletionHandler) {
        if (!this.connecting) {
            if (this.method == HttpMethod.OTHER && this.rawMethod == null) {
                throw new IllegalStateException("You must provide a rawMethod when using an HttpMethod.OTHER method");
            }
            Waiter waiter = new Waiter(this, this.vertx.getContext()){

                @Override
                void handleFailure(Throwable failure) {
                    HttpClientRequestImpl.this.handleException(failure);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                void handleConnection(HttpClientConnection conn) {
                    HttpClientRequestImpl httpClientRequestImpl = HttpClientRequestImpl.this;
                    synchronized (httpClientRequestImpl) {
                        if (HttpClientRequestImpl.this.connectionHandler != null) {
                            HttpClientRequestImpl.this.connectionHandler.handle(conn);
                        }
                    }
                }

                @Override
                void handleStream(HttpClientStream stream) {
                    HttpClientRequestImpl.this.connected(stream, headersCompletionHandler);
                }

                @Override
                boolean isCancelled() {
                    return HttpClientRequestImpl.this.exceptionOccurred != null || HttpClientRequestImpl.this.reset != null;
                }
            };
            this.client.getConnectionForRequest(this.ssl, this.port, this.host, waiter);
            this.connecting = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connected(HttpClientStream stream, Handler<HttpVersion> headersCompletionHandler) {
        HttpClientConnection conn = stream.connection();
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.stream = stream;
            stream.beginRequest(this);
            if (this.pendingMaxSize != -1) {
                this.stream.doSetWriteQueueMaxSize(this.pendingMaxSize);
            }
            if (this.pendingChunks != null) {
                ByteBuf pending = this.pendingChunks;
                this.pendingChunks = null;
                if (this.completed) {
                    this.writeHeadWithContent(pending, true);
                    conn.reportBytesWritten(this.written);
                    if (this.respHandler != null) {
                        this.stream.endRequest();
                    }
                } else {
                    this.writeHeadWithContent(pending, false);
                    if (headersCompletionHandler != null) {
                        headersCompletionHandler.handle(stream.version());
                    }
                }
            } else if (this.completed) {
                this.writeHeadWithContent(null, true);
                conn.reportBytesWritten(this.written);
                if (this.respHandler != null) {
                    this.stream.endRequest();
                }
            } else if (this.writeHead) {
                this.writeHead();
                if (headersCompletionHandler != null) {
                    headersCompletionHandler.handle(stream.version());
                }
            }
            this.lock = conn;
        }
    }

    private boolean contentLengthSet() {
        return this.headers != null && this.headers().contains(HttpHeaders.CONTENT_LENGTH);
    }

    private void writeHead() {
        this.stream.writeHead(this.method, this.rawMethod, this.uri, this.headers, this.hostHeader(), this.chunked);
        this.headWritten = true;
    }

    private void writeHeadWithContent(ByteBuf buf, boolean end) {
        this.stream.writeHeadWithContent(this.method, this.rawMethod, this.uri, this.headers, this.hostHeader(), this.chunked, buf, end);
        this.headWritten = true;
    }

    private void write(ByteBuf buff, boolean end) {
        if (buff == null && !end) {
            return;
        }
        if (end) {
            if (buff != null && !this.chunked && !this.contentLengthSet()) {
                this.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(buff.writerIndex()));
            }
        } else if (!this.chunked && !this.contentLengthSet()) {
            throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
        }
        if (buff != null) {
            this.written += (long)buff.readableBytes();
            if (this.followRedirects > 0) {
                if (this.cachedChunks == null) {
                    this.cachedChunks = Unpooled.compositeBuffer();
                }
                this.cachedChunks.addComponent(buff).writerIndex(this.cachedChunks.writerIndex() + buff.writerIndex());
            }
        }
        if (this.stream == null) {
            if (buff != null) {
                if (this.pendingChunks == null) {
                    this.pendingChunks = buff;
                } else {
                    CompositeByteBuf pending;
                    if (this.pendingChunks instanceof CompositeByteBuf) {
                        pending = (CompositeByteBuf)this.pendingChunks;
                    } else {
                        pending = Unpooled.compositeBuffer();
                        pending.addComponent(this.pendingChunks).writerIndex(this.pendingChunks.writerIndex());
                        this.pendingChunks = pending;
                    }
                    pending.addComponent(buff).writerIndex(pending.writerIndex() + buff.writerIndex());
                }
            }
            this.connect(null);
        } else {
            if (!this.headWritten) {
                this.writeHeadWithContent(buff, end);
            } else {
                this.stream.writeBuffer(buff, end);
            }
            if (end) {
                this.stream.connection().reportBytesWritten(this.written);
                if (this.respHandler != null) {
                    this.stream.endRequest();
                }
            }
        }
        if (end) {
            this.completed = true;
            if (this.completionHandler != null) {
                this.completionHandler.handle(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleResponseEnd() {
        Object object = this.getLock();
        synchronized (object) {
            this.response = null;
        }
    }

    @Override
    protected void checkComplete() {
        if (this.completed) {
            throw new IllegalStateException("Request already complete");
        }
    }

    private void checkResponseHandler() {
        if (this.respHandler == null) {
            throw new IllegalStateException("You must set an handler for the HttpClientResponse before connecting");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler<HttpClientRequest> pushHandler() {
        Object object = this.getLock();
        synchronized (object) {
            return this.pushHandler;
        }
    }

    private static /* synthetic */ void lambda$handleNextRequest$1(long timeoutMs, HttpClientRequestImpl next, ByteBuf body, AsyncResult ar) {
        if (ar.succeeded()) {
            if (timeoutMs > 0L) {
                next.setTimeout(timeoutMs);
            }
            next.write(body, true);
        } else {
            next.handleException(ar.cause());
        }
    }
}

