/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import org.apache.bookkeeper.statelib.api.checkpoint.CheckpointStore;
import org.apache.bookkeeper.statelib.api.exceptions.StateStoreException;
import org.apache.bookkeeper.statelib.impl.rocksdb.RocksUtils;
import org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint.RocksdbCheckpointTask;
import org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint.RocksdbRestoreTask;
import org.apache.bookkeeper.stream.proto.kv.store.CheckpointMetadata;
import org.apache.commons.lang3.tuple.Pair;
import org.rocksdb.Checkpoint;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksCheckpointer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(RocksCheckpointer.class);
    private final String dbName;
    private final File dbPath;
    private final Checkpoint checkpoint;
    private final CheckpointStore checkpointStore;
    private final boolean removeLocalCheckpointAfterSuccessfulCheckpoint;
    private final boolean removeRemoteCheckpointsAfterSuccessfulCheckpoint;

    public static CheckpointMetadata restore(String dbName, File dbPath, CheckpointStore checkpointStore) throws StateStoreException {
        try {
            String dbPrefix = String.format("%s", dbName);
            Pair<String, CheckpointMetadata> latestCheckpoint = RocksCheckpointer.getLatestCheckpoint(dbPrefix, checkpointStore);
            File checkpointsDir = new File(dbPath, "checkpoints");
            String checkpointId = (String)latestCheckpoint.getLeft();
            CheckpointMetadata checkpointMetadata = (CheckpointMetadata)latestCheckpoint.getRight();
            if (checkpointId != null) {
                RocksdbRestoreTask task = new RocksdbRestoreTask(dbName, checkpointsDir, checkpointStore);
                task.restore(checkpointId, checkpointMetadata);
            } else {
                checkpointId = UUID.randomUUID().toString();
                Files.createDirectories(Paths.get(checkpointsDir.getAbsolutePath(), checkpointId), new FileAttribute[0]);
            }
            Path restoredCheckpointPath = Paths.get(checkpointsDir.getAbsolutePath(), checkpointId);
            log.info("Successfully restore checkpoint {} to {}", (Object)checkpointId, (Object)restoredCheckpointPath);
            File currentDir = new File(dbPath, "current");
            Files.deleteIfExists(Paths.get(currentDir.getAbsolutePath(), new String[0]));
            Files.createSymbolicLink(Paths.get(currentDir.getAbsolutePath(), new String[0]), restoredCheckpointPath, new FileAttribute[0]);
            RocksCheckpointer.cleanupLocalCheckpoints(checkpointsDir, checkpointId);
            return checkpointMetadata;
        }
        catch (IOException ioe) {
            log.error("Failed to restore rocksdb {}", (Object)dbName, (Object)ioe);
            throw new StateStoreException("Failed to restore rocksdb " + dbName, ioe);
        }
    }

    private static void cleanupLocalCheckpoints(File checkpointsDir, String checkpointToExclude) {
        String[] checkpoints;
        for (String checkpoint : checkpoints = checkpointsDir.list()) {
            if (checkpoint.equals(checkpointToExclude)) continue;
            try {
                MoreFiles.deleteRecursively((Path)Paths.get(checkpointsDir.getAbsolutePath(), checkpoint), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            }
            catch (IOException ioe) {
                log.warn("Failed to remove unused checkpoint {} from {}", new Object[]{checkpoint, checkpointsDir, ioe});
            }
        }
    }

    private static Pair<String, CheckpointMetadata> getLatestCheckpoint(String dbPrefix, CheckpointStore checkpointStore) throws IOException {
        String remoteCheckpointsPath = RocksUtils.getDestCheckpointsPath(dbPrefix);
        List<String> files = checkpointStore.listFiles(remoteCheckpointsPath);
        CheckpointMetadata latestCheckpoint = null;
        String latestCheckpointId = null;
        for (String checkpointId : files) {
            String metadataPath = RocksUtils.getDestCheckpointMetadataPath(dbPrefix, checkpointId);
            InputStream is = checkpointStore.openInputStream(metadataPath);
            Throwable throwable = null;
            try {
                CheckpointMetadata ckpt = CheckpointMetadata.parseFrom((InputStream)is);
                if (null == latestCheckpoint) {
                    latestCheckpointId = checkpointId;
                    latestCheckpoint = ckpt;
                    continue;
                }
                if (latestCheckpoint.getCreatedAt() >= ckpt.getCreatedAt()) continue;
                latestCheckpointId = checkpointId;
                latestCheckpoint = ckpt;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return Pair.of(latestCheckpointId, latestCheckpoint);
    }

    public RocksCheckpointer(String dbName, File dbPath, RocksDB rocksDB, CheckpointStore checkpointStore, boolean removeLocalCheckpointAfterSuccessfulCheckpoint, boolean removeRemoteCheckpointsAfterSuccessfulCheckpoint) {
        this.dbName = dbName;
        this.dbPath = dbPath;
        this.checkpoint = Checkpoint.create((RocksDB)rocksDB);
        this.checkpointStore = checkpointStore;
        this.removeLocalCheckpointAfterSuccessfulCheckpoint = removeLocalCheckpointAfterSuccessfulCheckpoint;
        this.removeRemoteCheckpointsAfterSuccessfulCheckpoint = removeRemoteCheckpointsAfterSuccessfulCheckpoint;
    }

    public String checkpointAtTxid(byte[] txid) throws StateStoreException {
        RocksdbCheckpointTask task = new RocksdbCheckpointTask(this.dbName, this.checkpoint, new File(this.dbPath, "checkpoints"), this.checkpointStore, this.removeLocalCheckpointAfterSuccessfulCheckpoint, this.removeRemoteCheckpointsAfterSuccessfulCheckpoint);
        return task.checkpoint(txid);
    }

    @Override
    public void close() {
    }
}

