/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.context.externalize.SafeObjectInputStream;
import org.apache.axis2.context.externalize.SafeObjectOutputStream;
import org.apache.axis2.context.externalize.SafeSerializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Parameter
implements Externalizable,
SafeSerializable {
    private static final Log log = LogFactory.getLog(Parameter.class);
    private static final String myClassName = "Parameter";
    private static final long serialVersionUID = -6601664200673063531L;
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;
    public static final int ANY_PARAMETER = 0;
    public static final int TEXT_PARAMETER = 1;
    public static final int OM_PARAMETER = 2;
    private int type = 1;
    private boolean locked;
    private String name;
    private OMElement parameterElement;
    private Object value;
    private boolean _transient;
    private boolean editable = true;

    public Parameter() {
    }

    public Parameter(String name, Object value) {
        this.name = name;
        this.value = value;
        this.parseValueForType(this.value);
    }

    public String getName() {
        return this.name;
    }

    public OMElement getParameterElement() {
        return this.parameterElement;
    }

    public int getParameterType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean value) {
        this.locked = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameterElement(OMElement element) {
        this.parameterElement = element;
    }

    public void setParameterType(int type) {
        this.type = type;
    }

    public void setValue(Object value) {
        if (!this.editable) {
            log.debug((Object)("Parameter " + this.getName() + "  can not be edit"));
            return;
        }
        this.parseValueForType(value);
        this.value = value;
    }

    private void parseValueForType(Object value) {
        if (value instanceof String) {
            this.setParameterType(1);
        } else if (value instanceof OMElement) {
            this.setParameterType(2);
        } else {
            this.setParameterType(0);
        }
    }

    public String toString() {
        return "Parameter : " + this.name + "=" + this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Parameter) {
            return ((Parameter)obj).name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void writeExternal(ObjectOutput o) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        if (this.isTransient()) {
            return;
        }
        out.writeLong(-6601664200673063531L);
        out.writeInt(2);
        out.writeInt(this.type);
        out.writeBoolean(this.locked);
        out.writeObject(this.name);
        String tmp = null;
        if (this.parameterElement != null) {
            tmp = this.parameterElement.toString();
        }
        out.writeObject(tmp);
        out.writeObject(this.value);
    }

    @Override
    public void readExternal(ObjectInput inObject) throws IOException, ClassNotFoundException {
        SafeObjectInputStream in;
        block8: {
            in = SafeObjectInputStream.install(inObject);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Parameter:readExternal():  BEGIN  bytes available in stream [" + in.available() + "]  "));
            }
            long suid = in.readLong();
            int revID = in.readInt();
            if (suid != -6601664200673063531L) {
                throw new ClassNotFoundException("Serialization version ID is not supported.");
            }
            if (revID != 2) {
                throw new ClassNotFoundException("Revision ID is not supported.");
            }
            this.type = in.readInt();
            this.locked = in.readBoolean();
            this.name = (String)in.readObject();
            String tmp = (String)in.readObject();
            if (tmp != null) {
                try {
                    OMElement docElement = AXIOMUtil.stringToOM((String)tmp);
                    if (docElement != null) {
                        this.parameterElement = docElement;
                        break block8;
                    }
                    this.parameterElement = null;
                }
                catch (Exception exc) {
                    this.parameterElement = null;
                }
            } else {
                this.parameterElement = null;
            }
        }
        this.value = in.readObject();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean _transient) {
        this._transient = _transient;
    }
}

