/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import java.io.IOException;
import java.net.URI;
import java.util.regex.Pattern;
import org.apache.avro.FormattedSchemaParser;
import org.apache.avro.ParseContext;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.idl.IdlFile;
import org.apache.avro.idl.IdlReader;

public class IdlSchemaParser
implements FormattedSchemaParser {
    private static final Pattern START_OF_IDL_PATTERN = Pattern.compile("\\A(?:\\s*+|/\\*(?:[^*]|\\*(?!/))*+\\*/|//(?:(?!\\R).)*+\\R)*+(?:@|(?:namespace|schema|protocol|record|enum|fixed|import)\\s)", 264);

    public Schema parse(ParseContext parseContext, URI baseUri, CharSequence formattedSchema) throws IOException, SchemaParseException {
        boolean inputCanBeIdl = START_OF_IDL_PATTERN.matcher(formattedSchema).find();
        if (inputCanBeIdl) {
            IdlReader idlReader = new IdlReader(parseContext);
            IdlFile idlFile = idlReader.parse(baseUri, formattedSchema);
            return idlFile.getMainSchema();
        }
        return null;
    }
}

