/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.ParseContext;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;

public class IdlFile {
    private final Object resolveLock = new Object();
    private volatile ParseContext parseContext;
    private Schema mainSchema;
    private Protocol protocol;
    private Map<String, Schema> namedSchemas;
    private final List<String> warnings;

    IdlFile(Protocol protocol, ParseContext context, List<String> warnings) {
        this(context, null, protocol, warnings);
    }

    IdlFile(Schema mainSchema, ParseContext context, List<String> warnings) {
        this(context, mainSchema, null, warnings);
    }

    private IdlFile(ParseContext context, Schema mainSchema, Protocol protocol, List<String> warnings) {
        this.parseContext = context;
        this.namedSchemas = new LinkedHashMap<String, Schema>();
        this.mainSchema = mainSchema;
        this.protocol = protocol;
        this.warnings = Collections.unmodifiableList(new ArrayList<String>(warnings));
    }

    public Schema getMainSchema() {
        if (this.mainSchema == null) {
            return null;
        }
        this.ensureSchemasAreResolved();
        return this.mainSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSchemasAreResolved() {
        if (this.parseContext != null) {
            Object object = this.resolveLock;
            synchronized (object) {
                if (this.parseContext != null) {
                    this.parseContext.commit();
                    List<Schema> schemas = this.parseContext.resolveAllSchemas();
                    schemas.forEach(schema -> this.namedSchemas.put(schema.getFullName(), (Schema)schema));
                    if (this.mainSchema != null) {
                        this.mainSchema = this.parseContext.resolve(this.mainSchema);
                    }
                    if (this.protocol != null) {
                        this.protocol.setTypes(schemas);
                        Map<String, Protocol.Message> messages = this.protocol.getMessages();
                        for (Map.Entry<String, Protocol.Message> entry : messages.entrySet()) {
                            Protocol.Message newValue;
                            Protocol.Message oldValue = entry.getValue();
                            if (oldValue.isOneWay()) {
                                newValue = this.protocol.createMessage(oldValue.getName(), oldValue.getDoc(), oldValue, this.parseContext.resolve(oldValue.getRequest()));
                            } else {
                                Schema request = this.parseContext.resolve(oldValue.getRequest());
                                Schema response = this.parseContext.resolve(oldValue.getResponse());
                                Schema errors = this.parseContext.resolve(oldValue.getErrors());
                                newValue = this.protocol.createMessage(oldValue.getName(), oldValue.getDoc(), oldValue, request, response, errors);
                            }
                            entry.setValue(newValue);
                        }
                    }
                }
            }
        }
    }

    public Protocol getProtocol() {
        if (this.protocol == null) {
            return null;
        }
        this.ensureSchemasAreResolved();
        return this.protocol;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public List<String> getWarnings(String importFile) {
        return this.warnings.stream().map(warning -> importFile + " " + Character.toLowerCase(warning.charAt(0)) + warning.substring(1)).collect(Collectors.toList());
    }

    public Map<String, Schema> getNamedSchemas() {
        this.ensureSchemasAreResolved();
        return Collections.unmodifiableMap(this.namedSchemas);
    }

    public Schema getNamedSchema(String name) {
        this.ensureSchemasAreResolved();
        return this.namedSchemas.get(name);
    }

    String outputString() {
        this.ensureSchemasAreResolved();
        if (this.protocol != null) {
            return this.protocol.toString();
        }
        if (this.mainSchema != null) {
            return this.mainSchema.toString();
        }
        if (this.namedSchemas.isEmpty()) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder();
        for (Schema schema : this.namedSchemas.values()) {
            buffer.append(',').append(schema);
        }
        buffer.append(']').setCharAt(0, '[');
        return buffer.toString();
    }
}

