/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ArgumentUtils;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class NumericATan2Descriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = NumericATan2Descriptor::new;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.NUMERIC_ATAN2;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final IPointable leftPtr = new VoidPointable();
                    private final IPointable rightPtr = new VoidPointable();
                    private final IScalarEvaluator evalLeft;
                    private final IScalarEvaluator evalRight;
                    private double operand0;
                    private double operand1;
                    private final AMutableDouble aDouble;
                    private final ISerializerDeserializer outputSerde;
                    private final ArrayBackedValueStorage resultStorage;
                    private final DataOutput out;
                    {
                        this.evalLeft = args[0].createScalarEvaluator(ctx);
                        this.evalRight = args[1].createScalarEvaluator(ctx);
                        this.aDouble = new AMutableDouble(0.0);
                        this.outputSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
                        this.resultStorage = new ArrayBackedValueStorage();
                        this.out = this.resultStorage.getDataOutput();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.evalLeft.evaluate(tuple, this.leftPtr);
                        this.evalRight.evaluate(tuple, this.rightPtr);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.leftPtr, this.rightPtr)) {
                            return;
                        }
                        if (this.checkTypeAndWarn(this.leftPtr, 0) || this.checkTypeAndWarn(this.rightPtr, 1)) {
                            PointableHelper.setNull(result);
                            return;
                        }
                        String funName = NumericATan2Descriptor.this.getIdentifier().getName();
                        this.operand0 = ATypeHierarchy.getDoubleValue((String)funName, (int)0, (byte[])this.leftPtr.getByteArray(), (int)this.leftPtr.getStartOffset());
                        this.operand1 = ATypeHierarchy.getDoubleValue((String)funName, (int)1, (byte[])this.rightPtr.getByteArray(), (int)this.rightPtr.getStartOffset());
                        this.aDouble.setValue(Math.atan2(this.operand0, this.operand1));
                        this.outputSerde.serialize((Object)this.aDouble, this.out);
                        result.set((IValueReference)this.resultStorage);
                    }

                    private boolean checkTypeAndWarn(IPointable argPtr, int argIdx) {
                        int offset;
                        byte[] data = argPtr.getByteArray();
                        byte type = data[offset = argPtr.getStartOffset()];
                        if (ATypeHierarchy.getTypeDomain((ATypeTag)ATypeTag.VALUE_TYPE_MAPPING[type]) != ATypeHierarchy.Domain.NUMERIC) {
                            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)ctx, (SourceLocation)NumericATan2Descriptor.this.sourceLoc, (FunctionIdentifier)NumericATan2Descriptor.this.getIdentifier(), (byte)type, (int)argIdx, (byte[])ArgumentUtils.NUMERIC_TYPES);
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
    }
}

