/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalMemoryRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;

public abstract class AbstractStableSortPOperator
extends AbstractPhysicalOperator {
    public static final int MIN_FRAME_LIMIT_FOR_SORT = 3;
    OrderColumn[] sortColumns;
    ILocalStructuralProperty orderProp;

    AbstractStableSortPOperator() {
    }

    public OrderColumn[] getSortColumns() {
        return this.sortColumns;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        OrderOperator sortOp = (OrderOperator)op;
        this.computeLocalProperties(sortOp);
        AbstractLogicalOperator childOp = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        StructuralPropertiesVector childProp = (StructuralPropertiesVector)childOp.getDeliveredPhysicalProperties();
        this.deliveredProperties = new StructuralPropertiesVector(childProp.getPartitioningProperty(), Collections.singletonList(this.orderProp));
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext ctx) {
        if (op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED) {
            IPartitioningProperty partitioning;
            OrderOperator sortOp = (OrderOperator)op;
            if (this.orderProp == null) {
                this.computeLocalProperties(sortOp);
            }
            IPhysicalPropertiesVector[] requiredProp = new StructuralPropertiesVector[1];
            INodeDomain targetNodeDomain = ctx.getComputationNodeDomain();
            String fullParallelAnnotation = this.getFullParallelAnnotation(sortOp, targetNodeDomain, ctx);
            if (fullParallelAnnotation != null) {
                RangeMap rangeMap = this.getRangeMap(sortOp, fullParallelAnnotation);
                partitioning = new OrderedPartitionedProperty(Arrays.asList(this.sortColumns), targetNodeDomain, rangeMap);
            } else {
                partitioning = IPartitioningProperty.UNPARTITIONED;
            }
            requiredProp[0] = new StructuralPropertiesVector(partitioning, Collections.singletonList(this.orderProp));
            return new PhysicalRequirements(requiredProp, IPartitioningRequirementsCoordinator.NO_COORDINATION);
        }
        return this.emptyUnaryRequirements();
    }

    public void computeLocalProperties(OrderOperator ord) {
        ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : ord.getOrderExpressions()) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)p.second).getValue();
            if (expr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                VariableReferenceExpression varRef = (VariableReferenceExpression)expr;
                LogicalVariable var = varRef.getVariableReference();
                orderColumns.add(new OrderColumn(var, ((OrderOperator.IOrder)p.first).getKind()));
                continue;
            }
            throw new IllegalStateException();
        }
        this.sortColumns = orderColumns.toArray(new OrderColumn[orderColumns.size()]);
        this.orderProp = new LocalOrderProperty(orderColumns);
    }

    public ILocalStructuralProperty getOrderProperty() {
        return this.orderProp;
    }

    @Override
    public String toString() {
        if (this.orderProp == null) {
            return this.getOperatorTag().toString();
        }
        return this.getOperatorTag().toString() + " " + this.orderProp;
    }

    @Override
    public Pair<int[], int[]> getInputOutputDependencyLabels(ILogicalOperator op) {
        int[] inputDependencyLabels = new int[]{0};
        int[] outputDependencyLabels = new int[]{1};
        return new Pair((Object)inputDependencyLabels, (Object)outputDependencyLabels);
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return true;
    }

    private String getFullParallelAnnotation(AbstractLogicalOperator sortOp, INodeDomain clusterDomain, IOptimizationContext ctx) {
        if (sortOp.getPhysicalOperator().getOperatorTag() == PhysicalOperatorTag.STABLE_SORT && clusterDomain.cardinality() != null && clusterDomain.cardinality() > 1 && ctx.getPhysicalOptimizationConfig().getSortParallel()) {
            if (sortOp.getAnnotations().containsKey("USE_STATIC_RANGE")) {
                return "USE_STATIC_RANGE";
            }
            if (sortOp.getAnnotations().get("USE_DYNAMIC_RANGE") != Boolean.FALSE) {
                return "USE_DYNAMIC_RANGE";
            }
        }
        return null;
    }

    private RangeMap getRangeMap(ILogicalOperator sortOp, String fullParallelAnnotation) {
        switch (fullParallelAnnotation) {
            case "USE_STATIC_RANGE": {
                return (RangeMap)sortOp.getAnnotations().get(fullParallelAnnotation);
            }
            case "USE_DYNAMIC_RANGE": {
                return null;
            }
        }
        throw new IllegalStateException(fullParallelAnnotation);
    }

    @Override
    public void createLocalMemoryRequirements(ILogicalOperator op) {
        this.localMemoryRequirements = LocalMemoryRequirements.variableMemoryBudget(3);
    }
}

