/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.ArrayList;
import rx.Observable;
import rx.annotations.Beta;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.internal.operators.NotificationLite;
import rx.internal.producers.SingleProducer;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class AsyncSubject<T>
extends Subject<T, T> {
    final SubjectSubscriptionManager<T> state;
    volatile Object lastValue;
    private final NotificationLite<T> nl = NotificationLite.instance();

    public static <T> AsyncSubject<T> create() {
        final SubjectSubscriptionManager state = new SubjectSubscriptionManager();
        state.onTerminated = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                Object v = state.getLatest();
                NotificationLite nl = state.nl;
                if (v == null || nl.isCompleted(v)) {
                    o.onCompleted();
                } else if (nl.isError(v)) {
                    o.onError(nl.getError(v));
                } else {
                    o.actual.setProducer(new SingleProducer(o.actual, nl.getValue(v)));
                }
            }
        };
        return new AsyncSubject(state, state);
    }

    protected AsyncSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    @Override
    public void onCompleted() {
        if (this.state.active) {
            Object last = this.lastValue;
            if (last == null) {
                last = this.nl.completed();
            }
            for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.terminate(last)) {
                if (last == this.nl.completed()) {
                    bo.onCompleted();
                    continue;
                }
                bo.actual.setProducer(new SingleProducer(bo.actual, this.nl.getValue(last)));
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.state.active) {
            Object n = this.nl.error(e);
            ArrayList<Throwable> errors = null;
            for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.terminate(n)) {
                try {
                    bo.onError(e);
                }
                catch (Throwable e2) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(e2);
                }
            }
            Exceptions.throwIfAny(errors);
        }
    }

    @Override
    public void onNext(T v) {
        this.lastValue = this.nl.next(v);
    }

    @Override
    public boolean hasObservers() {
        return this.state.observers().length > 0;
    }

    @Beta
    public boolean hasValue() {
        Object v = this.lastValue;
        Object o = this.state.getLatest();
        return !this.nl.isError(o) && this.nl.isNext(v);
    }

    @Beta
    public boolean hasThrowable() {
        Object o = this.state.getLatest();
        return this.nl.isError(o);
    }

    @Beta
    public boolean hasCompleted() {
        Object o = this.state.getLatest();
        return o != null && !this.nl.isError(o);
    }

    @Beta
    public T getValue() {
        Object v = this.lastValue;
        Object o = this.state.getLatest();
        if (!this.nl.isError(o) && this.nl.isNext(v)) {
            return this.nl.getValue(v);
        }
        return null;
    }

    @Beta
    public Throwable getThrowable() {
        Object o = this.state.getLatest();
        if (this.nl.isError(o)) {
            return this.nl.getError(o);
        }
        return null;
    }
}

