/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.job.profiling.om;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.IStatsCollector;
import org.apache.hyracks.api.job.profiling.NoOpOperatorStats;
import org.apache.hyracks.api.job.profiling.OperatorStats;
import org.apache.hyracks.control.common.job.profiling.om.AbstractProfile;
import org.apache.hyracks.control.common.job.profiling.om.JobletProfile;
import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;

public class JobProfile
extends AbstractProfile {
    private static final long serialVersionUID = 2L;
    private JobId jobId;
    private long createTime;
    private long startTime;
    private String startTimeZoneId;
    private long endTime;
    private Map<String, JobletProfile> jobletProfiles;

    public static JobProfile create(DataInput dis) throws IOException {
        JobProfile jobProfile = new JobProfile();
        jobProfile.readFields(dis);
        return jobProfile;
    }

    private JobProfile() {
    }

    public JobProfile(JobId jobId) {
        this.jobId = jobId;
        this.jobletProfiles = new HashMap<String, JobletProfile>();
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public Map<String, JobletProfile> getJobletProfiles() {
        return this.jobletProfiles;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setStartTimeZoneId(String startTimeZoneId) {
        this.startTimeZoneId = startTimeZoneId;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getQueueWaitTimeInNanos() {
        return TimeUnit.MILLISECONDS.toNanos(this.startTime - this.createTime);
    }

    @Override
    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("job-id", this.jobId.toString());
        json.put("create-time", this.createTime);
        json.put("start-time", this.startTime);
        json.put("queued-time", this.startTime - this.createTime);
        json.put("end-time", this.endTime);
        this.populateCounters(json);
        ArrayNode jobletsArray = om.createArrayNode();
        for (JobletProfile p : this.jobletProfiles.values()) {
            jobletsArray.add((JsonNode)p.toJSON());
        }
        json.set("joblets", (JsonNode)jobletsArray);
        return json;
    }

    public void merge(JobProfile other) {
        super.merge(this);
        for (JobletProfile jp : other.jobletProfiles.values()) {
            if (this.jobletProfiles.containsKey(jp.getNodeId())) {
                this.jobletProfiles.get(jp.getNodeId()).merge(jp);
                continue;
            }
            this.jobletProfiles.put(jp.getNodeId(), jp);
        }
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.jobId = JobId.create((DataInput)input);
        this.createTime = input.readLong();
        this.startTime = input.readLong();
        this.endTime = input.readLong();
        this.startTimeZoneId = input.readUTF();
        int size = input.readInt();
        this.jobletProfiles = new HashMap<String, JobletProfile>();
        for (int i = 0; i < size; ++i) {
            String key = input.readUTF();
            JobletProfile value = JobletProfile.create(input);
            this.jobletProfiles.put(key, value);
        }
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        this.jobId.writeFields(output);
        output.writeLong(this.createTime);
        output.writeLong(this.startTime);
        output.writeLong(this.endTime);
        output.writeUTF(this.startTimeZoneId);
        output.writeInt(this.jobletProfiles.size());
        for (Map.Entry<String, JobletProfile> entry : this.jobletProfiles.entrySet()) {
            output.writeUTF(entry.getKey());
            entry.getValue().writeFields(output);
        }
    }

    public List<IOperatorStats> getAggregatedStats(List<String> operatorNames) {
        if (this.jobletProfiles == null || operatorNames == null || operatorNames.isEmpty()) {
            return null;
        }
        HashMap<TaskId, TaskProfile> taskProfileMap = new HashMap<TaskId, TaskProfile>();
        for (JobletProfile jobletProfile : this.jobletProfiles.values()) {
            for (TaskProfile taskProfile : jobletProfile.getTaskProfiles().values()) {
                TaskAttemptId taskAttemptId = taskProfile.getTaskId();
                TaskId taskId = taskAttemptId.getTaskId();
                TaskProfile existingProfile = (TaskProfile)taskProfileMap.get(taskId);
                if (existingProfile != null && taskAttemptId.getAttempt() <= existingProfile.getTaskId().getAttempt()) continue;
                taskProfileMap.put(taskId, taskProfile);
            }
        }
        int n = operatorNames.size();
        IOperatorStats[] outStats = new IOperatorStats[n];
        for (TaskProfile taskProfile : taskProfileMap.values()) {
            IStatsCollector statsCollector = taskProfile.getStatsCollector();
            for (int i = 0; i < n; ++i) {
                String operatorName = operatorNames.get(i);
                IOperatorStats opTaskStats = statsCollector.getOperatorStats(operatorName);
                if (opTaskStats.equals(NoOpOperatorStats.INSTANCE)) continue;
                IOperatorStats opOutStats = outStats[i];
                if (opOutStats == null) {
                    outStats[i] = opOutStats = new OperatorStats(operatorName, "ODID:-1");
                }
                opOutStats.updateFrom(opTaskStats);
            }
        }
        return Arrays.asList(outStats);
    }
}

