/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.ipc;

import java.net.InetSocketAddress;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicy;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.DeployedJobSpecId;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.control.common.base.INodeController;
import org.apache.hyracks.control.common.controllers.NodeParameters;
import org.apache.hyracks.control.common.ipc.CCNCFunctions;
import org.apache.hyracks.control.common.job.TaskAttemptDescriptor;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.exceptions.IPCException;

public class NodeControllerRemoteProxy
implements INodeController {
    private final CcId ccId;
    private final IIPCHandle ipcHandle;

    public NodeControllerRemoteProxy(CcId ccId, IIPCHandle ipcHandle) {
        this.ccId = ccId;
        this.ipcHandle = ipcHandle;
    }

    @Override
    public void startTasks(DeploymentId deploymentId, JobId jobId, byte[] planBytes, List<TaskAttemptDescriptor> taskDescriptors, Map<ConnectorDescriptorId, IConnectorPolicy> connectorPolicies, Set<JobFlag> flags, Map<byte[], byte[]> jobParameters, DeployedJobSpecId deployedJobSpecId, long jobStartTime, String jobStartTimeZoneId) throws Exception {
        CCNCFunctions.StartTasksFunction stf = new CCNCFunctions.StartTasksFunction(deploymentId, jobId, planBytes, taskDescriptors, connectorPolicies, flags, jobParameters, deployedJobSpecId, jobStartTime, jobStartTimeZoneId);
        this.ipcHandle.send(-1L, (Object)stf, null);
    }

    @Override
    public void abortTasks(JobId jobId, List<TaskAttemptId> tasks) throws Exception {
        CCNCFunctions.AbortTasksFunction atf = new CCNCFunctions.AbortTasksFunction(jobId, tasks);
        this.ipcHandle.send(-1L, (Object)atf, null);
    }

    @Override
    public void cleanUpJoblet(JobId jobId, JobStatus status) throws Exception {
        CCNCFunctions.CleanupJobletFunction cjf = new CCNCFunctions.CleanupJobletFunction(jobId, status);
        this.ipcHandle.send(-1L, (Object)cjf, null);
    }

    @Override
    public void reportPartitionAvailability(PartitionId pid, NetworkAddress networkAddress) throws Exception {
        CCNCFunctions.ReportPartitionAvailabilityFunction rpaf = new CCNCFunctions.ReportPartitionAvailabilityFunction(pid, networkAddress);
        this.ipcHandle.send(-1L, (Object)rpaf, null);
    }

    @Override
    public void deployBinary(DeploymentId deploymentId, List<URL> binaryURLs) throws Exception {
        CCNCFunctions.DeployBinaryFunction rpaf = new CCNCFunctions.DeployBinaryFunction(deploymentId, binaryURLs, this.ccId);
        this.ipcHandle.send(-1L, (Object)rpaf, null);
    }

    @Override
    public void undeployBinary(DeploymentId deploymentId) throws Exception {
        CCNCFunctions.UnDeployBinaryFunction rpaf = new CCNCFunctions.UnDeployBinaryFunction(deploymentId, this.ccId);
        this.ipcHandle.send(-1L, (Object)rpaf, null);
    }

    @Override
    public void deployJobSpec(DeployedJobSpecId deployedJobSpecId, byte[] planBytes, boolean upsert) throws Exception {
        CCNCFunctions.DeployJobSpecFunction fn = new CCNCFunctions.DeployJobSpecFunction(deployedJobSpecId, planBytes, upsert, this.ccId);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void undeployJobSpec(DeployedJobSpecId deployedJobSpecId) throws Exception {
        CCNCFunctions.UndeployJobSpecFunction fn = new CCNCFunctions.UndeployJobSpecFunction(deployedJobSpecId, this.ccId);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void dumpState(String stateDumpId) throws Exception {
        CCNCFunctions.StateDumpRequestFunction dsf = new CCNCFunctions.StateDumpRequestFunction(stateDumpId, this.ccId);
        this.ipcHandle.send(-1L, (Object)dsf, null);
    }

    @Override
    public void shutdown(boolean terminateNCService) throws Exception {
        CCNCFunctions.ShutdownRequestFunction sdrf = new CCNCFunctions.ShutdownRequestFunction(terminateNCService, this.ccId);
        this.ipcHandle.send(-1L, (Object)sdrf, null);
    }

    @Override
    public void sendApplicationMessageToNC(byte[] data, DeploymentId deploymentId, String nodeId) throws Exception {
        CCNCFunctions.SendApplicationMessageFunction fn = new CCNCFunctions.SendApplicationMessageFunction(data, deploymentId, false, nodeId);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void sendRealTimeApplicationMessageToNC(byte[] data, DeploymentId deploymentId, String nodeId) throws Exception {
        CCNCFunctions.SendApplicationMessageFunction fn = new CCNCFunctions.SendApplicationMessageFunction(data, deploymentId, true, nodeId);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void takeThreadDump(String requestId) throws Exception {
        CCNCFunctions.ThreadDumpRequestFunction fn = new CCNCFunctions.ThreadDumpRequestFunction(requestId, this.ccId);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void abortJobs(CcId ccId) throws IPCException {
        this.ipcHandle.send(-1L, (Object)new CCNCFunctions.AbortCCJobsFunction(ccId), null);
    }

    @Override
    public void sendRegistrationResult(NodeParameters parameters, Exception regFailure) throws IPCException {
        this.ipcHandle.send(-1L, (Object)new CCNCFunctions.NodeRegistrationResult(parameters, regFailure), null);
    }

    @Override
    public void ping(CcId ccId) throws IPCException {
        this.ipcHandle.send(-1L, (Object)new CCNCFunctions.PingFunction(ccId), null);
    }

    @Override
    public void heartbeatAck(CcId ccId, HyracksDataException e) throws IPCException {
        this.ipcHandle.send(-1L, (Object)new CCNCFunctions.NodeHeartbeatAckFunction(ccId, e), null);
    }

    public InetSocketAddress getAddress() {
        return this.ipcHandle.getRemoteAddress();
    }
}

