/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.runningaggregates.std;

import java.io.DataOutput;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IWindowAggregateEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public final class WinMarkFirstUnknownRunningAggregateEvaluator
implements IWindowAggregateEvaluator {
    private final ISerializerDeserializer boolSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    private final IScalarEvaluator[] argEvals;
    private final byte unknownTypeTag;
    private final TaggedValuePointable argValue;
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput dataOutput = this.resultStorage.getDataOutput();
    private boolean first;
    private boolean firstAllUnknown;

    WinMarkFirstUnknownRunningAggregateEvaluator(ATypeTag unknownTypeTag, IScalarEvaluator[] argEvals) {
        this.argEvals = argEvals;
        this.unknownTypeTag = unknownTypeTag.serialize();
        this.argValue = TaggedValuePointable.FACTORY.createPointable();
    }

    public void init() {
    }

    public void initPartition(long partitionLength) {
        this.first = true;
    }

    public void step(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        boolean value = this.compute(tuple);
        this.resultStorage.reset();
        this.boolSerde.serialize((Object)ABoolean.valueOf((boolean)value), this.dataOutput);
        result.set((IValueReference)this.resultStorage);
    }

    private boolean compute(IFrameTupleReference tuple) throws HyracksDataException {
        if (this.first) {
            this.firstAllUnknown = this.everyArgIsUnknown(tuple);
            this.first = false;
            return true;
        }
        boolean thisAllMissing = this.firstAllUnknown || this.everyArgIsUnknown(tuple);
        return !thisAllMissing;
    }

    private boolean everyArgIsUnknown(IFrameTupleReference tuple) throws HyracksDataException {
        for (IScalarEvaluator argEval : this.argEvals) {
            argEval.evaluate(tuple, (IPointable)this.argValue);
            if (this.argValue.getTag() == this.unknownTypeTag) continue;
            return false;
        }
        return true;
    }
}

