/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.pointables.nonvisitor.ARecordPointable;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.records.RecordFieldsUtil;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class GetRecordFieldsEvalFactory
implements IScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private IScalarEvaluatorFactory recordEvalFactory;
    private final ARecordType recordType;
    private final SourceLocation sourceLoc;

    public GetRecordFieldsEvalFactory(IScalarEvaluatorFactory recordEvalFactory, ARecordType recordType, SourceLocation sourceLoc) {
        this.recordEvalFactory = recordEvalFactory;
        this.recordType = recordType;
        this.sourceLoc = sourceLoc;
    }

    public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
        return new IScalarEvaluator(){
            private final ARecordPointable recordPointable = ARecordPointable.FACTORY.createPointable();
            private IPointable inputArg0 = new VoidPointable();
            private IScalarEvaluator eval0;
            private ArrayBackedValueStorage resultStorage;
            private DataOutput out;
            private RecordFieldsUtil rfu;
            {
                this.eval0 = GetRecordFieldsEvalFactory.this.recordEvalFactory.createScalarEvaluator(ctx);
                this.resultStorage = new ArrayBackedValueStorage();
                this.out = this.resultStorage.getDataOutput();
                this.rfu = new RecordFieldsUtil();
            }

            public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                this.resultStorage.reset();
                this.eval0.evaluate(tuple, this.inputArg0);
                if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg0)) {
                    return;
                }
                byte[] data = this.inputArg0.getByteArray();
                int offset = this.inputArg0.getStartOffset();
                int len = this.inputArg0.getLength();
                if (data[offset] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                    throw new TypeMismatchException(GetRecordFieldsEvalFactory.this.sourceLoc, BuiltinFunctions.GET_RECORD_FIELDS, 0, data[offset], ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
                }
                this.recordPointable.set(data, offset, len);
                try {
                    this.rfu.processRecord(this.recordPointable, GetRecordFieldsEvalFactory.this.recordType, this.out, 0);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
                result.set((IValueReference)this.resultStorage);
            }
        };
    }
}

