/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.implementation.util.EnvironmentConfiguration;
import com.azure.core.util.Configuration;
import com.azure.core.util.ConfigurationSource;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ConfigurationBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationBuilder.class);
    private final MutableConfigurationSource mutableSource;
    private final EnvironmentConfiguration environmentConfiguration;
    private String rootPath;
    private Configuration sharedConfiguration;

    public ConfigurationBuilder() {
        this.mutableSource = new MutableConfigurationSource();
        this.environmentConfiguration = EnvironmentConfiguration.getGlobalConfiguration();
    }

    public ConfigurationBuilder(ConfigurationSource source) {
        this.mutableSource = new MutableConfigurationSource(Objects.requireNonNull(source, "'source' cannot be null"));
        this.environmentConfiguration = EnvironmentConfiguration.getGlobalConfiguration();
    }

    public ConfigurationBuilder(ConfigurationSource source, ConfigurationSource systemPropertiesConfigurationSource, ConfigurationSource environmentConfigurationSource) {
        Objects.requireNonNull(source, "'source' cannot be null");
        Objects.requireNonNull(systemPropertiesConfigurationSource, "'systemPropertiesConfigurationSource' cannot be null");
        Objects.requireNonNull(environmentConfigurationSource, "'environmentConfigurationSource' cannot be null");
        this.mutableSource = new MutableConfigurationSource(source);
        this.environmentConfiguration = new EnvironmentConfiguration(systemPropertiesConfigurationSource, environmentConfigurationSource);
    }

    public ConfigurationBuilder putProperty(String name, String value) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(value, "'value' cannot be null.");
        this.mutableSource.put(name, value);
        this.sharedConfiguration = null;
        return this;
    }

    public ConfigurationBuilder root(String rootPath) {
        this.rootPath = rootPath;
        this.sharedConfiguration = null;
        return this;
    }

    public Configuration build() {
        if (this.sharedConfiguration == null) {
            this.sharedConfiguration = new Configuration(this.mutableSource, this.environmentConfiguration, this.rootPath, null);
        }
        return this.sharedConfiguration;
    }

    public Configuration buildSection(String path) {
        Objects.requireNonNull(path, "'path' cannot be null");
        if (this.sharedConfiguration == null) {
            this.sharedConfiguration = new Configuration(this.mutableSource, this.environmentConfiguration, this.rootPath, null);
        }
        String absolutePath = ConfigurationBuilder.getAbsolutePath(this.rootPath, path);
        return new Configuration(this.mutableSource, this.environmentConfiguration, absolutePath, this.sharedConfiguration);
    }

    private static String getAbsolutePath(String root, String relative) {
        if (CoreUtils.isNullOrEmpty(root)) {
            return relative;
        }
        return root + "." + relative;
    }

    private static final class MutableConfigurationSource
    implements ConfigurationSource {
        private final ConfigurationSource originalSource;
        private Map<String, String> additionalConfigurations;

        private MutableConfigurationSource() {
            this((ConfigurationSource)null);
        }

        private MutableConfigurationSource(ConfigurationSource originalSource) {
            this.originalSource = originalSource;
            this.additionalConfigurations = null;
        }

        MutableConfigurationSource put(String key, String value) {
            if (this.additionalConfigurations == null) {
                this.additionalConfigurations = new HashMap<String, String>();
            }
            if (this.additionalConfigurations.containsKey(key)) {
                LOGGER.atWarning().addKeyValue("name", key).log("Property with the same name already exists, value will be overwritten.");
            }
            this.additionalConfigurations.put(key, value);
            return this;
        }

        @Override
        public Map<String, String> getProperties(String source) {
            Map<String, String> original;
            Map<String, String> map = original = this.originalSource == null ? Collections.emptyMap() : this.originalSource.getProperties(source);
            if (this.additionalConfigurations == null) {
                return original;
            }
            HashMap<String, String> allConfigurations = new HashMap<String, String>(original);
            for (Map.Entry<String, String> prop : this.additionalConfigurations.entrySet()) {
                if (allConfigurations.containsKey(prop.getKey())) {
                    LOGGER.atWarning().addKeyValue("name", prop.getKey()).log("Property with the same name already exists, value will be overwritten.");
                }
                if (!MutableConfigurationSource.hasPrefix(prop.getKey(), source)) continue;
                allConfigurations.put(prop.getKey(), prop.getValue());
            }
            return allConfigurations;
        }

        private static boolean hasPrefix(String key, String prefix) {
            return prefix == null || key.startsWith(prefix) && key.length() > prefix.length() && key.charAt(prefix.length()) == '.';
        }
    }
}

