/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.NumberUtils;
import java.util.Arrays;

public final class VertexDescription {
    private int m_attributeCount;
    int m_semanticsBitArray;
    private int m_totalComponentCount;
    private int m_hash;
    private int[] m_semanticsToIndexMap;
    private int[] m_indexToSemantics;
    private int[] m_pointAttributeOffsets;
    private double[] m_defaultPointAttributes;
    static final double[] _defaultValues = new double[]{0.0, 0.0, NumberUtils.NaN(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    static final int[] _interpolation = new int[]{1, 1, 1, 0, 2, 1, 1, 1, 0};
    static final int[] _persistence = new int[]{1, 1, 1, 2, 0, 0, 0, 0, 2};
    static final int[] _persistencesize = new int[]{4, 8, 4, 8, 1, 2};
    static final int[] _components = new int[]{2, 1, 1, 1, 3, 1, 2, 3, 2};

    public final int getAttributeCount() {
        return this.m_attributeCount;
    }

    public final int getSemantics(int attributeIndex) {
        return this.m_indexToSemantics[attributeIndex];
    }

    public final int getAttributeIndex(int semantics) {
        return this.m_semanticsToIndexMap[semantics];
    }

    static int getInterpolation(int semantics) {
        return _interpolation[semantics];
    }

    static int getPersistence(int semantics) {
        return _persistence[semantics];
    }

    static int getPersistenceSize(int persistence) {
        return _persistencesize[persistence];
    }

    static int getPersistenceSizeSemantics(int semantics) {
        return VertexDescription.getPersistenceSize(VertexDescription.getPersistence(semantics)) * VertexDescription.getComponentCount(semantics);
    }

    public static int getComponentCount(int semantics) {
        return _components[semantics];
    }

    public boolean hasAttribute(int semantics) {
        return (this.m_semanticsBitArray & 1 << semantics) != 0;
    }

    public final boolean hasAttributesFrom(VertexDescription src) {
        return (this.m_semanticsBitArray & src.m_semanticsBitArray) == src.m_semanticsBitArray;
    }

    public final boolean hasZ() {
        return this.hasAttribute(1);
    }

    public final boolean hasM() {
        return this.hasAttribute(2);
    }

    public final boolean hasID() {
        return this.hasAttribute(3);
    }

    public static double getDefaultValue(int semantics) {
        return _defaultValues[semantics];
    }

    int getPointAttributeOffset_(int attributeIndex) {
        return this.m_pointAttributeOffsets[attributeIndex];
    }

    public int getTotalComponentCount() {
        return this.m_totalComponentCount;
    }

    public static boolean isDefaultValue(int semantics, double v) {
        return NumberUtils.doubleToInt64Bits(_defaultValues[semantics]) == NumberUtils.doubleToInt64Bits(v);
    }

    static boolean isIntegerPersistence(int persistence) {
        return persistence >= 2;
    }

    static boolean isIntegerSemantics(int semantics) {
        return VertexDescription.isIntegerPersistence(VertexDescription.getPersistence(semantics));
    }

    public boolean equals(Object _other) {
        return this == _other;
    }

    double[] _getDefaultPointAttributes() {
        return this.m_defaultPointAttributes;
    }

    double _getDefaultPointAttributeValue(int attributeIndex, int ordinate) {
        return this.m_defaultPointAttributes[this._getPointAttributeOffset(attributeIndex) + ordinate];
    }

    int _getPointAttributeOffset(int attributeIndex) {
        return this.m_pointAttributeOffsets[attributeIndex];
    }

    int _getPointAttributeOffsetFromSemantics(int semantics) {
        return this.m_pointAttributeOffsets[this.getAttributeIndex(semantics)];
    }

    public int hashCode() {
        return this.m_hash;
    }

    int _getSemanticsImpl(int attributeIndex) {
        return this.m_indexToSemantics[attributeIndex];
    }

    VertexDescription(int bitMask) {
        int i;
        this.m_semanticsBitArray = bitMask;
        this.m_attributeCount = 0;
        this.m_totalComponentCount = 0;
        this.m_semanticsToIndexMap = new int[9];
        Arrays.fill(this.m_semanticsToIndexMap, -1);
        int flag = 1;
        int n = 9;
        for (i = 0; i < n; ++i) {
            if ((bitMask & flag) != 0) {
                this.m_semanticsToIndexMap[i] = this.m_attributeCount++;
                int comps = VertexDescription.getComponentCount(i);
                this.m_totalComponentCount += comps;
            }
            flag <<= 1;
        }
        this.m_indexToSemantics = new int[this.m_attributeCount];
        int n2 = 9;
        for (i = 0; i < n2; ++i) {
            int attrib = this.m_semanticsToIndexMap[i];
            if (attrib < 0) continue;
            this.m_indexToSemantics[attrib] = i;
        }
        this.m_defaultPointAttributes = new double[this.m_totalComponentCount];
        this.m_pointAttributeOffsets = new int[this.m_attributeCount];
        int offset = 0;
        n = this.m_attributeCount;
        for (int i2 = 0; i2 < n; ++i2) {
            int semantics = this.getSemantics(i2);
            int comps = VertexDescription.getComponentCount(semantics);
            double v = VertexDescription.getDefaultValue(semantics);
            this.m_pointAttributeOffsets[i2] = offset;
            for (int icomp = 0; icomp < comps; ++icomp) {
                this.m_defaultPointAttributes[offset] = v;
                ++offset;
            }
        }
        this.m_hash = NumberUtils.hash(this.m_semanticsBitArray);
    }

    static interface Persistence {
        public static final int enumFloat = 0;
        public static final int enumDouble = 1;
        public static final int enumInt32 = 2;
        public static final int enumInt64 = 3;
        public static final int enumInt8 = 4;
        public static final int enumInt16 = 5;
    }

    static interface Interpolation {
        public static final int NONE = 0;
        public static final int LINEAR = 1;
        public static final int ANGULAR = 2;
    }

    public static interface Semantics {
        public static final int POSITION = 0;
        public static final int Z = 1;
        public static final int M = 2;
        public static final int ID = 3;
        public static final int NORMAL = 4;
        public static final int TEXTURE1D = 5;
        public static final int TEXTURE2D = 6;
        public static final int TEXTURE3D = 7;
        public static final int ID2 = 8;
        public static final int MAXSEMANTICS = 8;
    }
}

