/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.util.Arrays;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.typecomputer.impl.AbstractRecordFunctionTypeComputer;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeHelper;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;

public class RecordRenameTypeComputer
extends AbstractRecordFunctionTypeComputer {
    public static final RecordRenameTypeComputer INSTANCE = new RecordRenameTypeComputer();

    private RecordRenameTypeComputer() {
    }

    @Override
    public IAType computeTypeImpl(AbstractFunctionCallExpression functionCallExpression, IVariableTypeEnvironment env, ARecordType inputRecordType, boolean isOutputMissable, boolean isOutputNullable) throws AlgebricksException {
        ARecordType outputRecordType;
        ILogicalExpression arg2 = (ILogicalExpression)((Mutable)functionCallExpression.getArguments().get(2)).getValue();
        IAType type2 = (IAType)env.getType(arg2);
        IAType actualType2 = TypeComputeUtils.getActualType(type2);
        ATypeTag tag2 = actualType2.getTypeTag();
        if (tag2 == ATypeTag.ANY) {
            return AUnionType.createUnknownableType(inputRecordType, inputRecordType.getTypeName() + "?");
        }
        if (tag2 == ATypeTag.MISSING) {
            return BuiltinType.AMISSING;
        }
        if (tag2 != ATypeTag.STRING) {
            return BuiltinType.ANULL;
        }
        isOutputMissable |= TypeHelper.canBeMissing(type2);
        isOutputNullable |= TypeHelper.canBeNull(type2);
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)functionCallExpression.getArguments().get(1)).getValue();
        if (arg1.getExpressionTag() != LogicalExpressionTag.CONSTANT || arg2.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return RecordRenameTypeComputer.wrapTypeWithUnknown(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE, isOutputMissable, isOutputNullable);
        }
        ConstantExpression arg1ConstantExpression = (ConstantExpression)arg1;
        ConstantExpression arg2ConstantExpression = (ConstantExpression)arg2;
        AsterixConstantValue arg1ConstantValue = (AsterixConstantValue)arg1ConstantExpression.getValue();
        AsterixConstantValue arg2ConstantValue = (AsterixConstantValue)arg2ConstantExpression.getValue();
        String oldFieldName = ((AString)arg1ConstantValue.getObject()).getStringValue();
        String newFieldName = ((AString)arg2ConstantValue.getObject()).getStringValue();
        MutableObject fieldFound = new MutableObject((Object)false);
        String[] newFieldNames = (String[])Arrays.stream(inputRecordType.getFieldNames()).map(arg_0 -> RecordRenameTypeComputer.lambda$computeTypeImpl$0(oldFieldName, (Mutable)fieldFound, newFieldName, arg_0)).toArray(String[]::new);
        if (!((Boolean)fieldFound.getValue()).booleanValue()) {
            outputRecordType = inputRecordType;
        } else {
            String inputTypeName = inputRecordType.getTypeName();
            String outputTypeName = inputTypeName != null ? inputTypeName + "_replaced_" + oldFieldName : null;
            outputRecordType = new ARecordType(outputTypeName, newFieldNames, inputRecordType.getFieldTypes(), inputRecordType.isOpen());
        }
        return RecordRenameTypeComputer.wrapTypeWithUnknown(outputRecordType, isOutputMissable, isOutputNullable);
    }

    private static /* synthetic */ String lambda$computeTypeImpl$0(String oldFieldName, Mutable fieldFound, String newFieldName, String f) {
        if (f.equals(oldFieldName)) {
            fieldFound.setValue((Object)true);
            return newFieldName;
        }
        return f;
    }
}

