/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.Collection;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.api.IMetadataEntityTupleTranslator;
import org.apache.asterix.metadata.api.IMetadataIndex;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public abstract class AbstractTupleTranslator<T>
implements IMetadataEntityTupleTranslator<T> {
    protected final ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
    protected final ISerializerDeserializer<AString> stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
    protected final ISerializerDeserializer<ABoolean> booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    protected final ISerializerDeserializer<AInt32> int32Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    protected final ISerializerDeserializer<AInt64> int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    protected final ISerializerDeserializer<ARecord> recordSerDes;
    protected AMutableString aString = new AMutableString("");
    protected final ARecordType payloadRecordType;
    protected final int payloadTupleFieldIndex;
    protected final IARecordBuilder recordBuilder;
    protected final ArrayBackedValueStorage fieldName;
    protected final ArrayBackedValueStorage fieldValue;
    protected final ArrayTupleBuilder tupleBuilder;
    protected final ArrayTupleReference tuple;

    protected AbstractTupleTranslator(boolean getTuple, IMetadataIndex metadataIndex, int payloadTupleFieldIndex) {
        this.payloadRecordType = metadataIndex.getPayloadRecordType();
        this.recordSerDes = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)this.payloadRecordType);
        this.payloadTupleFieldIndex = payloadTupleFieldIndex;
        if (getTuple) {
            this.recordBuilder = new RecordBuilder();
            this.fieldName = this.payloadRecordType.isOpen() ? new ArrayBackedValueStorage() : null;
            this.fieldValue = new ArrayBackedValueStorage();
            this.tupleBuilder = new ArrayTupleBuilder(metadataIndex.getFieldCount());
            this.tuple = new ArrayTupleReference();
        } else {
            this.recordBuilder = null;
            this.fieldName = null;
            this.fieldValue = null;
            this.tupleBuilder = null;
            this.tuple = null;
        }
    }

    @Override
    public final T getMetadataEntityFromTuple(ITupleReference frameTuple) throws HyracksDataException, AlgebricksException {
        byte[] serRecord = frameTuple.getFieldData(this.payloadTupleFieldIndex);
        int recordStartOffset = frameTuple.getFieldStart(this.payloadTupleFieldIndex);
        int recordLength = frameTuple.getFieldLength(this.payloadTupleFieldIndex);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord datasetRecord = (ARecord)this.recordSerDes.deserialize((DataInput)in);
        return this.createMetadataEntityFromARecord(datasetRecord);
    }

    protected abstract T createMetadataEntityFromARecord(ARecord var1) throws HyracksDataException, AlgebricksException;

    public static void getDependencySubNames(Triple<DataverseName, String, String> dependency, Collection<? super String> outSubnames) {
        outSubnames.add(((DataverseName)dependency.first).getCanonicalForm());
        if (dependency.second != null) {
            outSubnames.add((String)dependency.second);
        }
        if (dependency.third != null) {
            outSubnames.add((String)dependency.third);
        }
    }

    public static Triple<DataverseName, String, String> getDependency(AOrderedList dependencySubnames) throws AlgebricksException {
        String dataverseCanonicalName = ((AString)dependencySubnames.getItem(0)).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        String second = null;
        String third = null;
        int ln = dependencySubnames.size();
        if (ln > 1) {
            second = ((AString)dependencySubnames.getItem(1)).getStringValue();
            if (ln > 2) {
                third = ((AString)dependencySubnames.getItem(2)).getStringValue();
            }
        }
        return new Triple((Object)dataverseName, (Object)second, third);
    }

    protected static String getStringValue(IAObject obj) {
        return obj.getType().getTypeTag() == ATypeTag.STRING ? ((AString)obj).getStringValue() : null;
    }

    protected static Triple<String, String, String> getDateTimeFormats(ARecord record) {
        IACursor formatCursor;
        Triple formats = new Triple(null, null, null);
        int formatFieldPos = record.getType().getFieldIndex("DataFormat");
        if (formatFieldPos >= 0 && (formatCursor = ((AOrderedList)record.getValueByPos(formatFieldPos)).getCursor()).next()) {
            formats.first = AbstractTupleTranslator.getStringValue(formatCursor.get());
            if (formatCursor.next()) {
                formats.second = AbstractTupleTranslator.getStringValue(formatCursor.get());
                if (formatCursor.next()) {
                    formats.third = AbstractTupleTranslator.getStringValue(formatCursor.get());
                }
            }
        }
        return formats;
    }

    public static void writeDateTimeFormats(String datetimeFormat, String dateFormat, String timeFormat, IARecordBuilder recordBuilder, AMutableString aString, ISerializerDeserializer<ANull> nullSerde, ISerializerDeserializer<AString> stringSerde, ArrayBackedValueStorage nameValue, ArrayBackedValueStorage fieldValue, ArrayBackedValueStorage itemValue) throws HyracksDataException {
        if (datetimeFormat != null || dateFormat != null || timeFormat != null) {
            nameValue.reset();
            aString.setValue("DataFormat");
            stringSerde.serialize((Object)aString, nameValue.getDataOutput());
            OrderedListBuilder formatListBuilder = new OrderedListBuilder();
            formatListBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
            for (String format : new String[]{datetimeFormat, dateFormat, timeFormat}) {
                itemValue.reset();
                if (format == null) {
                    nullSerde.serialize((Object)ANull.NULL, itemValue.getDataOutput());
                } else {
                    aString.setValue(format);
                    stringSerde.serialize((Object)aString, itemValue.getDataOutput());
                }
                formatListBuilder.addItem((IValueReference)itemValue);
            }
            fieldValue.reset();
            formatListBuilder.write(fieldValue.getDataOutput(), true);
            recordBuilder.addField((IValueReference)nameValue, (IValueReference)fieldValue);
        }
    }
}

