/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.util.AsciiString;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.netty.ChannelPipelineConfigurer;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.Http2SettingsSpec;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.HttpResources;
import reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.ContextAwareHttpServerMetricsHandler;
import reactor.netty.http.server.ContextAwareHttpServerMetricsRecorder;
import reactor.netty.http.server.HAProxyMessageDetector;
import reactor.netty.http.server.HAProxyMessageReader;
import reactor.netty.http.server.Http2StreamBridgeServerHandler;
import reactor.netty.http.server.HttpRequestDecoderSpec;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerFormDecoderProvider;
import reactor.netty.http.server.HttpServerMetricsHandler;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.HttpTrafficHandler;
import reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import reactor.netty.http.server.NonSslRedirectDetector;
import reactor.netty.http.server.ProxyProtocolSupportType;
import reactor.netty.http.server.SimpleCompressionHandler;
import reactor.netty.http.server.logging.AccessLog;
import reactor.netty.http.server.logging.AccessLogArgProvider;
import reactor.netty.http.server.logging.AccessLogHandlerFactory;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.SslProvider;
import reactor.netty.transport.ServerTransportConfig;
import reactor.netty.transport.logging.AdvancedByteBufFormat;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public final class HttpServerConfig
extends ServerTransportConfig<HttpServerConfig> {
    boolean accessLogEnabled;
    Function<AccessLogArgProvider, AccessLog> accessLog;
    BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
    ServerCookieDecoder cookieDecoder;
    ServerCookieEncoder cookieEncoder;
    HttpRequestDecoderSpec decoder;
    HttpServerFormDecoderProvider formDecoderProvider;
    BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
    Http2SettingsSpec http2Settings;
    Duration idleTimeout;
    BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    int maxKeepAliveRequests;
    int minCompressionSize;
    HttpProtocol[] protocols;
    int _protocols;
    ProxyProtocolSupportType proxyProtocolSupportType;
    boolean redirectHttpToHttps;
    SslProvider sslProvider;
    Function<String, String> uriTagValue;
    static final boolean ACCESS_LOG = Boolean.parseBoolean(System.getProperty("reactor.netty.http.server.accessLogEnabled", "false"));
    static final int h2 = 2;
    static final int h2c = 1;
    static final int h11 = 4;
    static final int h11orH2 = 6;
    static final int h11orH2C = 5;
    static final Logger log = Loggers.getLogger(HttpServerConfig.class);
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler(HttpServer.class.getName(), LogLevel.DEBUG, Charset.defaultCharset());
    static final boolean SSL_DEBUG = Boolean.parseBoolean(System.getProperty("reactor.netty.tcp.ssl.server.debug", "false"));

    @Nullable
    public BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate() {
        return this.compressPredicate;
    }

    public ServerCookieDecoder cookieDecoder() {
        return this.cookieDecoder;
    }

    public ServerCookieEncoder cookieEncoder() {
        return this.cookieEncoder;
    }

    public HttpRequestDecoderSpec decoder() {
        return this.decoder;
    }

    public HttpServerFormDecoderProvider formDecoderProvider() {
        return this.formDecoderProvider;
    }

    public Http2SettingsSpec http2SettingsSpec() {
        return this.http2Settings;
    }

    @Nullable
    public Duration idleTimeout() {
        return this.idleTimeout;
    }

    public boolean isForwarded() {
        return this.forwardedHeaderHandler != null;
    }

    public boolean isSecure() {
        return this.sslProvider != null;
    }

    public int maxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public int minCompressionSize() {
        return this.minCompressionSize;
    }

    public HttpProtocol[] protocols() {
        return this.protocols;
    }

    public ProxyProtocolSupportType proxyProtocolSupportType() {
        return this.proxyProtocolSupportType;
    }

    public boolean redirectHttpToHttps() {
        return this.redirectHttpToHttps;
    }

    @Nullable
    public SslProvider sslProvider() {
        return this.sslProvider;
    }

    @Nullable
    public Function<String, String> uriTagValue() {
        return this.uriTagValue;
    }

    HttpServerConfig(Map<ChannelOption<?>, ?> options, Map<ChannelOption<?>, ?> childOptions, Supplier<? extends SocketAddress> localAddress) {
        super(options, childOptions, localAddress);
        this.cookieDecoder = ServerCookieDecoder.STRICT;
        this.cookieEncoder = ServerCookieEncoder.STRICT;
        this.decoder = new HttpRequestDecoderSpec();
        this.formDecoderProvider = HttpServerFormDecoderProvider.DEFAULT_FORM_DECODER_SPEC;
        this.maxKeepAliveRequests = -1;
        this.minCompressionSize = -1;
        this.protocols = new HttpProtocol[]{HttpProtocol.HTTP11};
        this._protocols = 4;
        this.proxyProtocolSupportType = ProxyProtocolSupportType.OFF;
        this.accessLogEnabled = ACCESS_LOG;
    }

    HttpServerConfig(HttpServerConfig parent) {
        super((ServerTransportConfig)parent);
        this.accessLogEnabled = parent.accessLogEnabled;
        this.accessLog = parent.accessLog;
        this.compressPredicate = parent.compressPredicate;
        this.cookieDecoder = parent.cookieDecoder;
        this.cookieEncoder = parent.cookieEncoder;
        this.decoder = parent.decoder;
        this.formDecoderProvider = parent.formDecoderProvider;
        this.forwardedHeaderHandler = parent.forwardedHeaderHandler;
        this.http2Settings = parent.http2Settings;
        this.idleTimeout = parent.idleTimeout;
        this.mapHandle = parent.mapHandle;
        this.maxKeepAliveRequests = parent.maxKeepAliveRequests;
        this.minCompressionSize = parent.minCompressionSize;
        this.protocols = parent.protocols;
        this._protocols = parent._protocols;
        this.proxyProtocolSupportType = parent.proxyProtocolSupportType;
        this.redirectHttpToHttps = parent.redirectHttpToHttps;
        this.sslProvider = parent.sslProvider;
        this.uriTagValue = parent.uriTagValue;
    }

    protected LoggingHandler defaultLoggingHandler() {
        return LOGGING_HANDLER;
    }

    protected LoopResources defaultLoopResources() {
        return HttpResources.get();
    }

    protected ChannelMetricsRecorder defaultMetricsRecorder() {
        return MicrometerHttpServerMetricsRecorder.INSTANCE;
    }

    protected ChannelPipelineConfigurer defaultOnChannelInit() {
        return super.defaultOnChannelInit().then((ChannelPipelineConfigurer)new HttpServerChannelInitializer(this));
    }

    protected void loggingHandler(LoggingHandler loggingHandler) {
        super.loggingHandler(loggingHandler);
    }

    protected void metricsRecorder(@Nullable Supplier<? extends ChannelMetricsRecorder> metricsRecorder) {
        super.metricsRecorder(metricsRecorder);
    }

    void protocols(HttpProtocol ... protocols) {
        this.protocols = protocols;
        int _protocols = 0;
        for (HttpProtocol p : protocols) {
            if (p == HttpProtocol.HTTP11) {
                _protocols |= 4;
                continue;
            }
            if (p == HttpProtocol.H2) {
                _protocols |= 2;
                continue;
            }
            if (p != HttpProtocol.H2C) continue;
            _protocols |= 1;
        }
        this._protocols = _protocols;
    }

    Http2Settings http2Settings() {
        Http2Settings settings = Http2Settings.defaultSettings();
        if (this.http2Settings != null) {
            Integer maxFrameSize;
            Long maxConcurrentStreams;
            Integer initialWindowSize;
            Long headerTableSize = this.http2Settings.headerTableSize();
            if (headerTableSize != null) {
                settings.headerTableSize(headerTableSize.longValue());
            }
            if ((initialWindowSize = this.http2Settings.initialWindowSize()) != null) {
                settings.initialWindowSize(initialWindowSize.intValue());
            }
            if ((maxConcurrentStreams = this.http2Settings.maxConcurrentStreams()) != null) {
                settings.maxConcurrentStreams(maxConcurrentStreams.longValue());
            }
            if ((maxFrameSize = this.http2Settings.maxFrameSize()) != null) {
                settings.maxFrameSize(maxFrameSize.intValue());
            }
            settings.maxHeaderListSize(this.http2Settings.maxHeaderListSize().longValue());
            Boolean pushEnabled = this.http2Settings.pushEnabled();
            if (pushEnabled != null) {
                settings.pushEnabled(pushEnabled.booleanValue());
            }
        }
        return settings;
    }

    static void addStreamHandlers(Channel ch, boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, AccessLog> accessLog, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, int minCompressionSize, ChannelOperations.OnSetup opsFactory) {
        boolean alwaysCompress;
        ChannelPipeline pipeline = ch.pipeline();
        if (accessLogEnabled) {
            pipeline.addLast("reactor.left.accessLogHandler", AccessLogHandlerFactory.H2.create(accessLog));
        }
        pipeline.addLast("reactor.left.h2ToHttp11Codec", (ChannelHandler)new Http2StreamFrameToHttpObjectCodec(true)).addLast("reactor.left.httpTrafficHandler", (ChannelHandler)new Http2StreamBridgeServerHandler(compressPredicate, decoder, encoder, formDecoderProvider, forwardedHeaderHandler, listener, mapHandle));
        boolean bl = alwaysCompress = compressPredicate == null && minCompressionSize == 0;
        if (alwaysCompress) {
            pipeline.addLast("reactor.left.compressionHandler", (ChannelHandler)new SimpleCompressionHandler());
        }
        ChannelOperations.addReactiveBridge((Channel)ch, (ChannelOperations.OnSetup)opsFactory, (ConnectionObserver)listener);
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format((Channel)ch, (String)"Initialized HTTP/2 stream pipeline {}"), new Object[]{pipeline});
        }
    }

    @Nullable
    static BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate(@Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate, int minResponseSize) {
        if (minResponseSize <= 0) {
            return compressionPredicate;
        }
        BiPredicate<HttpServerRequest, HttpServerResponse> lengthPredicate = (req, res) -> {
            String length = res.responseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            if (length == null) {
                return true;
            }
            try {
                return Long.parseLong(length) >= (long)minResponseSize;
            }
            catch (NumberFormatException nfe) {
                return true;
            }
        };
        if (compressionPredicate != null) {
            lengthPredicate = lengthPredicate.and(compressionPredicate);
        }
        return lengthPredicate;
    }

    static void configureH2Pipeline(ChannelPipeline p, boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, AccessLog> accessLog, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder cookieDecoder, ServerCookieEncoder cookieEncoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, Http2Settings http2Settings, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, int minCompressionSize, ChannelOperations.OnSetup opsFactory, boolean validate) {
        p.remove("reactor.right.reactiveBridge");
        Http2FrameCodecBuilder http2FrameCodecBuilder = Http2FrameCodecBuilder.forServer().validateHeaders(validate).initialSettings(http2Settings);
        if (p.get("reactor.left.loggingHandler") != null) {
            http2FrameCodecBuilder.frameLogger(new Http2FrameLogger(LogLevel.DEBUG, "reactor.netty.http.server.h2"));
        }
        p.addLast("reactor.left.httpCodec", (ChannelHandler)http2FrameCodecBuilder.build()).addLast("reactor.left.h2MultiplexHandler", (ChannelHandler)new Http2MultiplexHandler((ChannelHandler)new H2Codec(accessLogEnabled, accessLog, compressPredicate, cookieDecoder, cookieEncoder, formDecoderProvider, forwardedHeaderHandler, listener, mapHandle, minCompressionSize, opsFactory)));
    }

    static void configureHttp11OrH2CleartextPipeline(ChannelPipeline p, boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, AccessLog> accessLog, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder cookieDecoder, ServerCookieEncoder cookieEncoder, HttpRequestDecoderSpec decoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, Http2Settings http2Settings, @Nullable Duration idleTimeout, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, int maxKeepAliveRequests, @Nullable ChannelMetricsRecorder metricsRecorder, int minCompressionSize, ChannelOperations.OnSetup opsFactory, @Nullable Function<String, String> uriTagValue) {
        boolean alwaysCompress;
        HttpServerCodec httpServerCodec = new HttpServerCodec(decoder.maxInitialLineLength(), decoder.maxHeaderSize(), decoder.maxChunkSize(), decoder.validateHeaders(), decoder.initialBufferSize(), decoder.allowDuplicateContentLengths());
        Http11OrH2CleartextCodec upgrader = new Http11OrH2CleartextCodec(accessLogEnabled, accessLog, compressPredicate, cookieDecoder, cookieEncoder, p.get("reactor.left.loggingHandler") != null, formDecoderProvider, forwardedHeaderHandler, http2Settings, listener, mapHandle, minCompressionSize, opsFactory, decoder.validateHeaders());
        H2CleartextCodec http2ServerHandler = new H2CleartextCodec(upgrader);
        CleartextHttp2ServerUpgradeHandler h2cUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(httpServerCodec, new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpServerCodec, (HttpServerUpgradeHandler.UpgradeCodecFactory)upgrader, decoder.h2cMaxContentLength()), (ChannelHandler)http2ServerHandler);
        p.addBefore("reactor.right.reactiveBridge", "reactor.left.h2cUpgradeHandler", (ChannelHandler)h2cUpgradeHandler).addBefore("reactor.right.reactiveBridge", "reactor.left.httpTrafficHandler", (ChannelHandler)new HttpTrafficHandler(compressPredicate, cookieDecoder, cookieEncoder, formDecoderProvider, forwardedHeaderHandler, idleTimeout, listener, mapHandle, maxKeepAliveRequests));
        if (accessLogEnabled) {
            p.addBefore("reactor.left.httpTrafficHandler", "reactor.left.accessLogHandler", AccessLogHandlerFactory.H1.create(accessLog));
        }
        boolean bl = alwaysCompress = compressPredicate == null && minCompressionSize == 0;
        if (alwaysCompress) {
            p.addBefore("reactor.left.httpTrafficHandler", "reactor.left.compressionHandler", (ChannelHandler)new SimpleCompressionHandler());
        }
        if (metricsRecorder != null && metricsRecorder instanceof HttpServerMetricsRecorder) {
            AbstractHttpServerMetricsHandler handler = metricsRecorder instanceof ContextAwareHttpServerMetricsRecorder ? new ContextAwareHttpServerMetricsHandler((ContextAwareHttpServerMetricsRecorder)metricsRecorder, uriTagValue) : new HttpServerMetricsHandler((HttpServerMetricsRecorder)metricsRecorder, uriTagValue);
            p.addAfter("reactor.left.httpTrafficHandler", "reactor.left.httpMetricsHandler", (ChannelHandler)handler);
            if (metricsRecorder instanceof MicrometerHttpServerMetricsRecorder) {
                p.remove("reactor.left.channelMetricsHandler");
            }
        }
    }

    static void configureHttp11Pipeline(ChannelPipeline p, boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, AccessLog> accessLog, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder cookieDecoder, ServerCookieEncoder cookieEncoder, HttpRequestDecoderSpec decoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, @Nullable Duration idleTimeout, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, int maxKeepAliveRequests, @Nullable ChannelMetricsRecorder metricsRecorder, int minCompressionSize, @Nullable Function<String, String> uriTagValue) {
        boolean alwaysCompress;
        p.addBefore("reactor.right.reactiveBridge", "reactor.left.httpCodec", (ChannelHandler)new HttpServerCodec(decoder.maxInitialLineLength(), decoder.maxHeaderSize(), decoder.maxChunkSize(), decoder.validateHeaders(), decoder.initialBufferSize(), decoder.allowDuplicateContentLengths())).addBefore("reactor.right.reactiveBridge", "reactor.left.httpTrafficHandler", (ChannelHandler)new HttpTrafficHandler(compressPredicate, cookieDecoder, cookieEncoder, formDecoderProvider, forwardedHeaderHandler, idleTimeout, listener, mapHandle, maxKeepAliveRequests));
        if (accessLogEnabled) {
            p.addAfter("reactor.left.httpCodec", "reactor.left.accessLogHandler", AccessLogHandlerFactory.H1.create(accessLog));
        }
        boolean bl = alwaysCompress = compressPredicate == null && minCompressionSize == 0;
        if (alwaysCompress) {
            p.addBefore("reactor.left.httpTrafficHandler", "reactor.left.compressionHandler", (ChannelHandler)new SimpleCompressionHandler());
        }
        if (metricsRecorder != null && metricsRecorder instanceof HttpServerMetricsRecorder) {
            AbstractHttpServerMetricsHandler handler = metricsRecorder instanceof ContextAwareHttpServerMetricsRecorder ? new ContextAwareHttpServerMetricsHandler((ContextAwareHttpServerMetricsRecorder)metricsRecorder, uriTagValue) : new HttpServerMetricsHandler((HttpServerMetricsRecorder)metricsRecorder, uriTagValue);
            p.addAfter("reactor.left.httpTrafficHandler", "reactor.left.httpMetricsHandler", (ChannelHandler)handler);
            if (metricsRecorder instanceof MicrometerHttpServerMetricsRecorder) {
                p.remove("reactor.left.channelMetricsHandler");
            }
        }
    }

    static final class HttpServerChannelInitializer
    implements ChannelPipelineConfigurer {
        final boolean accessLogEnabled;
        final Function<AccessLogArgProvider, AccessLog> accessLog;
        final BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final ServerCookieDecoder cookieDecoder;
        final ServerCookieEncoder cookieEncoder;
        final HttpRequestDecoderSpec decoder;
        final HttpServerFormDecoderProvider formDecoderProvider;
        final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final Http2Settings http2Settings;
        final Duration idleTimeout;
        final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
        final int maxKeepAliveRequests;
        final ChannelMetricsRecorder metricsRecorder;
        final int minCompressionSize;
        final ChannelOperations.OnSetup opsFactory;
        final int protocols;
        final ProxyProtocolSupportType proxyProtocolSupportType;
        final boolean redirectHttpToHttps;
        final SslProvider sslProvider;
        final Function<String, String> uriTagValue;

        HttpServerChannelInitializer(HttpServerConfig config) {
            this.accessLogEnabled = config.accessLogEnabled;
            this.accessLog = config.accessLog;
            this.compressPredicate = config.compressPredicate;
            this.cookieDecoder = config.cookieDecoder;
            this.cookieEncoder = config.cookieEncoder;
            this.decoder = config.decoder;
            this.formDecoderProvider = config.formDecoderProvider;
            this.forwardedHeaderHandler = config.forwardedHeaderHandler;
            this.http2Settings = config.http2Settings();
            this.idleTimeout = config.idleTimeout;
            this.mapHandle = config.mapHandle;
            this.maxKeepAliveRequests = config.maxKeepAliveRequests;
            this.metricsRecorder = config.metricsRecorderInternal();
            this.minCompressionSize = config.minCompressionSize;
            this.opsFactory = config.channelOperationsProvider();
            this.protocols = config._protocols;
            this.proxyProtocolSupportType = config.proxyProtocolSupportType;
            this.redirectHttpToHttps = config.redirectHttpToHttps;
            this.sslProvider = config.sslProvider;
            this.uriTagValue = config.uriTagValue;
        }

        public void onChannelInit(ConnectionObserver observer, Channel channel, @Nullable SocketAddress remoteAddress) {
            boolean needRead = false;
            if (this.sslProvider != null) {
                ChannelPipeline pipeline = channel.pipeline();
                if (this.redirectHttpToHttps && (this.protocols & 2) != 2) {
                    NonSslRedirectDetector nonSslRedirectDetector = new NonSslRedirectDetector(this.sslProvider, remoteAddress, SSL_DEBUG);
                    pipeline.addFirst("reactor.left.nonSslRedirectDetector", (ChannelHandler)nonSslRedirectDetector);
                } else {
                    this.sslProvider.addSslHandler(channel, remoteAddress, SSL_DEBUG);
                }
                if ((this.protocols & 6) == 6) {
                    channel.pipeline().addBefore("reactor.right.reactiveBridge", "reactor.left.h2OrHttp11Codec", (ChannelHandler)new H2OrHttp11Codec(this, observer));
                } else if ((this.protocols & 4) == 4) {
                    HttpServerConfig.configureHttp11Pipeline(channel.pipeline(), this.accessLogEnabled, this.accessLog, HttpServerConfig.compressPredicate(this.compressPredicate, this.minCompressionSize), this.cookieDecoder, this.cookieEncoder, this.decoder, this.formDecoderProvider, this.forwardedHeaderHandler, this.idleTimeout, observer, this.mapHandle, this.maxKeepAliveRequests, this.metricsRecorder, this.minCompressionSize, this.uriTagValue);
                } else if ((this.protocols & 2) == 2) {
                    HttpServerConfig.configureH2Pipeline(channel.pipeline(), this.accessLogEnabled, this.accessLog, HttpServerConfig.compressPredicate(this.compressPredicate, this.minCompressionSize), this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.forwardedHeaderHandler, this.http2Settings, observer, this.mapHandle, this.minCompressionSize, this.opsFactory, this.decoder.validateHeaders());
                }
            } else if ((this.protocols & 5) == 5) {
                HttpServerConfig.configureHttp11OrH2CleartextPipeline(channel.pipeline(), this.accessLogEnabled, this.accessLog, HttpServerConfig.compressPredicate(this.compressPredicate, this.minCompressionSize), this.cookieDecoder, this.cookieEncoder, this.decoder, this.formDecoderProvider, this.forwardedHeaderHandler, this.http2Settings, this.idleTimeout, observer, this.mapHandle, this.maxKeepAliveRequests, this.metricsRecorder, this.minCompressionSize, this.opsFactory, this.uriTagValue);
            } else if ((this.protocols & 4) == 4) {
                HttpServerConfig.configureHttp11Pipeline(channel.pipeline(), this.accessLogEnabled, this.accessLog, HttpServerConfig.compressPredicate(this.compressPredicate, this.minCompressionSize), this.cookieDecoder, this.cookieEncoder, this.decoder, this.formDecoderProvider, this.forwardedHeaderHandler, this.idleTimeout, observer, this.mapHandle, this.maxKeepAliveRequests, this.metricsRecorder, this.minCompressionSize, this.uriTagValue);
            } else if ((this.protocols & 1) == 1) {
                HttpServerConfig.configureH2Pipeline(channel.pipeline(), this.accessLogEnabled, this.accessLog, HttpServerConfig.compressPredicate(this.compressPredicate, this.minCompressionSize), this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.forwardedHeaderHandler, this.http2Settings, observer, this.mapHandle, this.minCompressionSize, this.opsFactory, this.decoder.validateHeaders());
                needRead = true;
            }
            if (this.proxyProtocolSupportType == ProxyProtocolSupportType.ON) {
                channel.pipeline().addFirst("reactor.left.proxyProtocolDecoder", (ChannelHandler)new HAProxyMessageDecoder()).addAfter("reactor.left.proxyProtocolDecoder", "reactor.left.proxyProtocolReader", (ChannelHandler)new HAProxyMessageReader());
            } else if (this.proxyProtocolSupportType == ProxyProtocolSupportType.AUTO) {
                channel.pipeline().addFirst("reactor.left.proxyProtocolDecoder", (ChannelHandler)new HAProxyMessageDetector());
            }
            if (needRead) {
                channel.read();
            }
        }
    }

    static final class H2OrHttp11Codec
    extends ApplicationProtocolNegotiationHandler {
        final boolean accessLogEnabled;
        final Function<AccessLogArgProvider, AccessLog> accessLog;
        final BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final ServerCookieDecoder cookieDecoder;
        final ServerCookieEncoder cookieEncoder;
        final HttpRequestDecoderSpec decoder;
        final HttpServerFormDecoderProvider formDecoderProvider;
        final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final Http2Settings http2Settings;
        final Duration idleTimeout;
        final ConnectionObserver listener;
        final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
        final int maxKeepAliveRequests;
        final ChannelMetricsRecorder metricsRecorder;
        final int minCompressionSize;
        final ChannelOperations.OnSetup opsFactory;
        final Function<String, String> uriTagValue;

        H2OrHttp11Codec(HttpServerChannelInitializer initializer, ConnectionObserver listener) {
            super("http/1.1");
            this.accessLogEnabled = initializer.accessLogEnabled;
            this.accessLog = initializer.accessLog;
            this.compressPredicate = HttpServerConfig.compressPredicate(initializer.compressPredicate, initializer.minCompressionSize);
            this.cookieDecoder = initializer.cookieDecoder;
            this.cookieEncoder = initializer.cookieEncoder;
            this.decoder = initializer.decoder;
            this.formDecoderProvider = initializer.formDecoderProvider;
            this.forwardedHeaderHandler = initializer.forwardedHeaderHandler;
            this.http2Settings = initializer.http2Settings;
            this.idleTimeout = initializer.idleTimeout;
            this.listener = listener;
            this.mapHandle = initializer.mapHandle;
            this.maxKeepAliveRequests = initializer.maxKeepAliveRequests;
            this.metricsRecorder = initializer.metricsRecorder;
            this.minCompressionSize = initializer.minCompressionSize;
            this.opsFactory = initializer.opsFactory;
            this.uriTagValue = initializer.uriTagValue;
        }

        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)ctx.channel(), (String)("Negotiated application-level protocol [" + protocol + "]")));
            }
            ChannelPipeline p = ctx.pipeline();
            if ("h2".equals(protocol)) {
                HttpServerConfig.configureH2Pipeline(p, this.accessLogEnabled, this.accessLog, this.compressPredicate, this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.forwardedHeaderHandler, this.http2Settings, this.listener, this.mapHandle, this.minCompressionSize, this.opsFactory, this.decoder.validateHeaders());
                return;
            }
            if ("http/1.1".equals(protocol)) {
                HttpServerConfig.configureHttp11Pipeline(p, this.accessLogEnabled, this.accessLog, this.compressPredicate, this.cookieDecoder, this.cookieEncoder, this.decoder, this.formDecoderProvider, this.forwardedHeaderHandler, this.idleTimeout, this.listener, this.mapHandle, this.maxKeepAliveRequests, this.metricsRecorder, this.minCompressionSize, this.uriTagValue);
                return;
            }
            throw new IllegalStateException("unknown protocol: " + protocol);
        }
    }

    static final class Http11OrH2CleartextCodec
    extends ChannelInitializer<Channel>
    implements HttpServerUpgradeHandler.UpgradeCodecFactory {
        final boolean accessLogEnabled;
        final Function<AccessLogArgProvider, AccessLog> accessLog;
        final BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final ServerCookieDecoder cookieDecoder;
        final ServerCookieEncoder cookieEncoder;
        final HttpServerFormDecoderProvider formDecoderProvider;
        final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final Http2FrameCodec http2FrameCodec;
        final ConnectionObserver listener;
        final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
        final int minCompressionSize;
        final ChannelOperations.OnSetup opsFactory;

        Http11OrH2CleartextCodec(boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, AccessLog> accessLog, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder cookieDecoder, ServerCookieEncoder cookieEncoder, boolean debug, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, Http2Settings http2Settings, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, int minCompressionSize, ChannelOperations.OnSetup opsFactory, boolean validate) {
            this.accessLogEnabled = accessLogEnabled;
            this.accessLog = accessLog;
            this.compressPredicate = compressPredicate;
            this.cookieDecoder = cookieDecoder;
            this.cookieEncoder = cookieEncoder;
            this.formDecoderProvider = formDecoderProvider;
            this.forwardedHeaderHandler = forwardedHeaderHandler;
            Http2FrameCodecBuilder http2FrameCodecBuilder = Http2FrameCodecBuilder.forServer().validateHeaders(validate).initialSettings(http2Settings);
            if (debug) {
                http2FrameCodecBuilder.frameLogger(new Http2FrameLogger(LogLevel.DEBUG, "reactor.netty.http.server.h2"));
            }
            this.http2FrameCodec = http2FrameCodecBuilder.build();
            this.listener = listener;
            this.mapHandle = mapHandle;
            this.minCompressionSize = minCompressionSize;
            this.opsFactory = opsFactory;
        }

        protected void initChannel(Channel ch) {
            ch.pipeline().remove((ChannelHandler)this);
            HttpServerConfig.addStreamHandlers(ch, this.accessLogEnabled, this.accessLog, this.compressPredicate, this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.forwardedHeaderHandler, this.listener, this.mapHandle, this.minCompressionSize, this.opsFactory);
        }

        @Nullable
        public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec(this.http2FrameCodec, new ChannelHandler[]{new H2CleartextCodec(this, false)});
            }
            return null;
        }
    }

    static final class H2Codec
    extends ChannelInitializer<Channel> {
        final boolean accessLogEnabled;
        final Function<AccessLogArgProvider, AccessLog> accessLog;
        final BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final ServerCookieDecoder cookieDecoder;
        final ServerCookieEncoder cookieEncoder;
        final HttpServerFormDecoderProvider formDecoderProvider;
        final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final ConnectionObserver listener;
        final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
        final int minCompressionSize;
        final ChannelOperations.OnSetup opsFactory;

        H2Codec(boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, AccessLog> accessLog, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, int minCompressionSize, ChannelOperations.OnSetup opsFactory) {
            this.accessLogEnabled = accessLogEnabled;
            this.accessLog = accessLog;
            this.compressPredicate = compressPredicate;
            this.cookieDecoder = decoder;
            this.cookieEncoder = encoder;
            this.formDecoderProvider = formDecoderProvider;
            this.forwardedHeaderHandler = forwardedHeaderHandler;
            this.listener = listener;
            this.mapHandle = mapHandle;
            this.minCompressionSize = minCompressionSize;
            this.opsFactory = opsFactory;
        }

        protected void initChannel(Channel ch) {
            ch.pipeline().remove((ChannelHandler)this);
            HttpServerConfig.addStreamHandlers(ch, this.accessLogEnabled, this.accessLog, this.compressPredicate, this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.forwardedHeaderHandler, this.listener, this.mapHandle, this.minCompressionSize, this.opsFactory);
        }
    }

    static final class H2CleartextCodec
    extends ChannelHandlerAdapter {
        final Http11OrH2CleartextCodec upgrader;
        final boolean addHttp2FrameCodec;

        H2CleartextCodec(Http11OrH2CleartextCodec upgrader) {
            this(upgrader, true);
        }

        H2CleartextCodec(Http11OrH2CleartextCodec upgrader, boolean addHttp2FrameCodec) {
            this.upgrader = upgrader;
            this.addHttp2FrameCodec = addHttp2FrameCodec;
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            ChannelPipeline pipeline = ctx.pipeline();
            if (this.addHttp2FrameCodec) {
                pipeline.addAfter(ctx.name(), "reactor.left.httpCodec", (ChannelHandler)this.upgrader.http2FrameCodec);
            }
            pipeline.addAfter(ctx.pipeline().context((ChannelHandler)this.upgrader.http2FrameCodec).name(), "reactor.left.h2MultiplexHandler", (ChannelHandler)new Http2MultiplexHandler((ChannelHandler)this.upgrader));
            pipeline.remove((ChannelHandler)this);
            if (pipeline.get("reactor.left.accessLogHandler") != null) {
                pipeline.remove("reactor.left.accessLogHandler");
            }
            if (pipeline.get("reactor.left.compressionHandler") != null) {
                pipeline.remove("reactor.left.compressionHandler");
            }
            pipeline.remove("reactor.left.httpTrafficHandler");
            pipeline.remove("reactor.right.reactiveBridge");
        }
    }
}

