/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.result;

import org.apache.hyracks.api.result.ResultDirectoryRecord;
import org.apache.hyracks.api.result.ResultJobRecord;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.control.cc.result.Waiter;
import org.apache.hyracks.control.cc.result.Waiters;
import org.apache.hyracks.control.common.work.IResultCallback;

class JobResultInfo {
    private ResultJobRecord record;
    private Waiters waiters;
    private Exception exception;

    JobResultInfo(ResultJobRecord record, Waiters waiters) {
        this.record = record;
        this.waiters = waiters;
    }

    ResultJobRecord getRecord() {
        return this.record;
    }

    void addWaiter(ResultSetId rsId, ResultDirectoryRecord[] knownRecords, IResultCallback<ResultDirectoryRecord[]> callback) {
        if (this.waiters == null) {
            this.waiters = new Waiters();
        }
        this.waiters.put(rsId, new Waiter(knownRecords, callback));
        if (this.exception != null) {
            this.setException(this.exception);
        }
    }

    Waiter removeWaiter(ResultSetId rsId) {
        return (Waiter)this.waiters.remove(rsId);
    }

    Waiter getWaiter(ResultSetId rsId) {
        return this.waiters != null ? (Waiter)this.waiters.get(rsId) : null;
    }

    void setException(Exception exception) {
        if (this.waiters != null) {
            for (ResultSetId rsId : this.waiters.keySet()) {
                ((Waiter)this.waiters.remove((Object)rsId)).callback.setException(exception);
            }
        }
        this.exception = exception;
    }

    public String toString() {
        return this.record.toString();
    }
}

