/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.google.common.base.Preconditions;
import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Scaling;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.SlowlyChangingDimensionUtils;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.distribution.CallCenterDistributions;
import com.teradata.tpcds.distribution.EnglishDistributions;
import com.teradata.tpcds.distribution.NamesDistributions;
import com.teradata.tpcds.generator.CallCenterGeneratorColumn;
import com.teradata.tpcds.random.RandomValueGenerator;
import com.teradata.tpcds.row.CallCenterRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;
import com.teradata.tpcds.type.Address;
import com.teradata.tpcds.type.Date;
import com.teradata.tpcds.type.Decimal;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CallCenterRowGenerator
extends AbstractRowGenerator {
    private static final Decimal MIN_TAX_PERCENTAGE = new Decimal(0L, 2);
    private static final Decimal MAX_TAX_PERCENTAGE = new Decimal(12L, 2);
    private static final int WIDTH_CC_DIVISION_NAME = 50;
    private static final int WIDTH_CC_MARKET_CLASS = 50;
    private static final int WIDTH_CC_MARKET_DESC = 100;
    private static final int MAX_NUMBER_OF_EMPLOYEES_UNSCALED = 7;
    private static final long JULIAN_DATE_START = Date.JULIAN_DATA_START_DATE - 23;
    private Optional<CallCenterRow> previousRow = Optional.empty();

    public CallCenterRowGenerator() {
        super(Table.CALL_CENTER);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        CallCenterRow.Builder builder = new CallCenterRow.Builder();
        builder.setNullBitMap(Nulls.createNullBitMap(Table.CALL_CENTER, this.getRandomNumberStream(CallCenterGeneratorColumn.CC_NULLS)));
        builder.setCcCallCenterSk(rowNumber);
        SlowlyChangingDimensionUtils.SlowlyChangingDimensionKey slowlyChangingDimensionKey = SlowlyChangingDimensionUtils.computeScdKey(Table.CALL_CENTER, rowNumber);
        builder.setCcCallCenterId(slowlyChangingDimensionKey.getBusinessKey());
        builder.setCcRecStartDateId(slowlyChangingDimensionKey.getStartDate());
        builder.setCcRecEndDateId(slowlyChangingDimensionKey.getEndDate());
        builder.setCcClosedDateId(-1L);
        Scaling scaling = session.getScaling();
        boolean isNewBusinessKey = slowlyChangingDimensionKey.isNewBusinessKey();
        if (isNewBusinessKey) {
            builder.setCcOpenDateId(JULIAN_DATE_START - (long)RandomValueGenerator.generateUniformRandomInt(-365, 0, this.getRandomNumberStream(CallCenterGeneratorColumn.CC_OPEN_DATE_ID)));
            int numberOfCallCenters = CallCenterDistributions.getNumberOfCallCenters();
            int suffix = (int)rowNumber / numberOfCallCenters;
            String ccName = CallCenterDistributions.getCallCenterAtIndex((int)(rowNumber % (long)numberOfCallCenters));
            if (suffix > 0) {
                ccName = String.format("%s_%d", ccName, suffix);
            }
            builder.setCcName(ccName);
            builder.setCcAddress(Address.makeAddressForColumn(Table.CALL_CENTER, this.getRandomNumberStream(CallCenterGeneratorColumn.CC_ADDRESS), scaling));
        } else {
            Preconditions.checkState((boolean)this.previousRow.isPresent(), (Object)"previousRow has not yet been initialized");
            builder.setCcOpenDateId(this.previousRow.get().getCcOpenDateId());
            builder.setCcName(this.previousRow.get().getCcName());
            builder.setCcAddress(this.previousRow.get().getCcAddress());
        }
        int fieldChangeFlag = (int)this.getRandomNumberStream(CallCenterGeneratorColumn.CC_SCD).nextRandom();
        String ccClass = CallCenterDistributions.pickRandomCallCenterClass(this.getRandomNumberStream(CallCenterGeneratorColumn.CC_CLASS));
        builder.setCcClass(ccClass);
        fieldChangeFlag >>= 1;
        int ccEmployees = RandomValueGenerator.generateUniformRandomInt(1, 7 * (int)Math.ceil(scaling.getScale()) * (int)Math.ceil(scaling.getScale()), this.getRandomNumberStream(CallCenterGeneratorColumn.CC_EMPLOYEES));
        if (this.previousRow.isPresent()) {
            ccEmployees = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlag, isNewBusinessKey, this.previousRow.get().getCcEmployees(), ccEmployees);
        }
        builder.setCcEmployees(ccEmployees);
        fieldChangeFlag >>= 1;
        int ccSqFt = RandomValueGenerator.generateUniformRandomInt(100, 700, this.getRandomNumberStream(CallCenterGeneratorColumn.CC_SQ_FT));
        ccSqFt *= ccEmployees;
        if (this.previousRow.isPresent()) {
            ccSqFt = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlag, isNewBusinessKey, this.previousRow.get().getCcSqFt(), ccSqFt);
        }
        builder.setCcSqFt(ccSqFt);
        fieldChangeFlag >>= 1;
        String ccHours = CallCenterDistributions.pickRandomCallCenterHours(this.getRandomNumberStream(CallCenterGeneratorColumn.CC_HOURS));
        builder.setCcHours(ccHours);
        fieldChangeFlag >>= 1;
        String managerFirstName = NamesDistributions.pickRandomFirstName(session.isSexist() ? NamesDistributions.FirstNamesWeights.MALE_FREQUENCY : NamesDistributions.FirstNamesWeights.GENERAL_FREQUENCY, this.getRandomNumberStream(CallCenterGeneratorColumn.CC_MANAGER));
        String managerLastName = NamesDistributions.pickRandomLastName(this.getRandomNumberStream(CallCenterGeneratorColumn.CC_MANAGER));
        String ccManager = String.format("%s %s", managerFirstName, managerLastName);
        if (this.previousRow.isPresent()) {
            ccManager = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlag, isNewBusinessKey, this.previousRow.get().getCcManager(), ccManager);
        }
        builder.setCcManager(ccManager);
        fieldChangeFlag >>= 1;
        int ccMarketId = RandomValueGenerator.generateUniformRandomInt(1, 6, this.getRandomNumberStream(CallCenterGeneratorColumn.CC_MARKET_ID));
        if (this.previousRow.isPresent()) {
            ccMarketId = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlag, isNewBusinessKey, this.previousRow.get().getCcMarketId(), ccMarketId);
        }
        builder.setCcMarketId(ccMarketId);
        fieldChangeFlag >>= 1;
        String ccMarketClass = RandomValueGenerator.generateRandomText(20, 50, this.getRandomNumberStream(CallCenterGeneratorColumn.CC_MARKET_CLASS));
        if (this.previousRow.isPresent()) {
            ccMarketClass = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlag, isNewBusinessKey, this.previousRow.get().getCcMarketClass(), ccMarketClass);
        }
        builder.setCcMarketClass(ccMarketClass);
        fieldChangeFlag >>= 1;
        String ccMarketDesc = RandomValueGenerator.generateRandomText(20, 100, this.getRandomNumberStream(CallCenterGeneratorColumn.CC_MARKET_DESC));
        if (this.previousRow.isPresent()) {
            ccMarketDesc = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlag, isNewBusinessKey, this.previousRow.get().getCcMarketDesc(), ccMarketDesc);
        }
        builder.setCcMarketDesc(ccMarketDesc);
        fieldChangeFlag >>= 1;
        String marketManagerFirstName = NamesDistributions.pickRandomFirstName(session.isSexist() ? NamesDistributions.FirstNamesWeights.MALE_FREQUENCY : NamesDistributions.FirstNamesWeights.GENERAL_FREQUENCY, this.getRandomNumberStream(CallCenterGeneratorColumn.CC_MARKET_MANAGER));
        String marketManagerLastName = NamesDistributions.pickRandomLastName(this.getRandomNumberStream(CallCenterGeneratorColumn.CC_MARKET_MANAGER));
        String ccMarketManager = String.format("%s %s", marketManagerFirstName, marketManagerLastName);
        if (this.previousRow.isPresent()) {
            ccMarketManager = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlag, isNewBusinessKey, this.previousRow.get().getCcMarketManager(), ccMarketManager);
        }
        builder.setCcMarketManager(ccMarketManager);
        fieldChangeFlag >>= 1;
        int ccCompany = RandomValueGenerator.generateUniformRandomInt(1, 6, this.getRandomNumberStream(CallCenterGeneratorColumn.CC_COMPANY));
        if (this.previousRow.isPresent()) {
            ccCompany = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlag, isNewBusinessKey, this.previousRow.get().getCcCompany(), ccCompany);
        }
        builder.setCcCompany(ccCompany);
        fieldChangeFlag >>= 1;
        int ccDivisionId = RandomValueGenerator.generateUniformRandomInt(1, 6, this.getRandomNumberStream(CallCenterGeneratorColumn.CC_COMPANY));
        if (this.previousRow.isPresent()) {
            ccDivisionId = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlag, isNewBusinessKey, this.previousRow.get().getCcDivisionId(), ccDivisionId);
        }
        builder.setCcDivisionId(ccDivisionId);
        fieldChangeFlag >>= 1;
        String ccDivisionName = RandomValueGenerator.generateWord(ccDivisionId, 50, EnglishDistributions.SYLLABLES_DISTRIBUTION);
        if (this.previousRow.isPresent()) {
            ccDivisionName = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlag, isNewBusinessKey, this.previousRow.get().getCcDivisionName(), ccDivisionName);
        }
        builder.setCcDivisionName(ccDivisionName);
        fieldChangeFlag >>= 1;
        String ccCompanyName = RandomValueGenerator.generateWord(ccCompany, 10, EnglishDistributions.SYLLABLES_DISTRIBUTION);
        if (this.previousRow.isPresent()) {
            ccCompanyName = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlag, isNewBusinessKey, this.previousRow.get().getCcCompanyName(), ccCompanyName);
        }
        builder.setCcCompanyName(ccCompanyName);
        fieldChangeFlag >>= 1;
        Decimal ccTaxPercentage = RandomValueGenerator.generateUniformRandomDecimal(MIN_TAX_PERCENTAGE, MAX_TAX_PERCENTAGE, this.getRandomNumberStream(CallCenterGeneratorColumn.CC_TAX_PERCENTAGE));
        if (this.previousRow.isPresent()) {
            ccTaxPercentage = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlag, isNewBusinessKey, this.previousRow.get().getCcTaxPercentage(), ccTaxPercentage);
        }
        builder.setCcTaxPercentage(ccTaxPercentage);
        CallCenterRow newRow = builder.build();
        this.previousRow = Optional.of(newRow);
        return new RowGeneratorResult(newRow);
    }
}

