/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.api.io.FileSplit;

public class FileSplitDomain
implements INodeDomain {
    private FileSplit[] splits;

    public FileSplitDomain(FileSplit[] splits) {
        this.splits = splits;
    }

    @Override
    public Integer cardinality() {
        return this.splits.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileSplitDomain[");
        boolean fst = true;
        for (FileSplit fs : this.splits) {
            if (fst) {
                fst = false;
            } else {
                sb.append(", ");
            }
            sb.append(fs.getNodeName() + ":" + fs.getPath());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public boolean sameAs(INodeDomain domain) {
        if (!(domain instanceof FileSplitDomain)) {
            return false;
        }
        FileSplitDomain fsd = (FileSplitDomain)domain;
        if (fsd.splits.length != this.splits.length) {
            return false;
        }
        for (int i = 0; i < this.splits.length; ++i) {
            if (this.ncEq(this.splits[i], fsd.splits[i])) continue;
            return false;
        }
        return true;
    }

    private boolean ncEq(FileSplit fs1, FileSplit fs2) {
        return fs1.getNodeName().equals(fs2.getNodeName());
    }
}

