/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.AsyncEmitter;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.exceptions.MissingBackpressureException;
import rx.functions.Action1;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.atomic.SpscUnboundedAtomicArrayQueue;
import rx.internal.util.unsafe.SpscUnboundedArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;
import rx.plugins.RxJavaHooks;
import rx.subscriptions.SerialSubscription;

public final class OnSubscribeFromAsync<T>
implements Observable.OnSubscribe<T> {
    final Action1<AsyncEmitter<T>> asyncEmitter;
    final AsyncEmitter.BackpressureMode backpressure;

    public OnSubscribeFromAsync(Action1<AsyncEmitter<T>> asyncEmitter, AsyncEmitter.BackpressureMode backpressure) {
        this.asyncEmitter = asyncEmitter;
        this.backpressure = backpressure;
    }

    @Override
    public void call(Subscriber<? super T> t) {
        BaseAsyncEmitter emitter;
        switch (this.backpressure) {
            case NONE: {
                emitter = new NoneAsyncEmitter<T>(t);
                break;
            }
            case ERROR: {
                emitter = new ErrorAsyncEmitter<T>(t);
                break;
            }
            case DROP: {
                emitter = new DropAsyncEmitter<T>(t);
                break;
            }
            case LATEST: {
                emitter = new LatestAsyncEmitter<T>(t);
                break;
            }
            default: {
                emitter = new BufferAsyncEmitter<T>(t, RxRingBuffer.SIZE);
            }
        }
        t.add(emitter);
        t.setProducer(emitter);
        this.asyncEmitter.call(emitter);
    }

    static final class LatestAsyncEmitter<T>
    extends BaseAsyncEmitter<T> {
        private static final long serialVersionUID = 4023437720691792495L;
        final AtomicReference<Object> queue = new AtomicReference();
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip = new AtomicInteger();
        final NotificationLite<T> nl = NotificationLite.instance();

        public LatestAsyncEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public void onNext(T t) {
            this.queue.set(this.nl.next(t));
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequested() {
            this.drain();
        }

        @Override
        void onUnsubscribed() {
            if (this.wip.getAndIncrement() == 0) {
                this.queue.lazySet(null);
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = this.actual;
            AtomicReference<Object> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (a.isUnsubscribed()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    Object o = q.getAndSet(null);
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.onError(ex);
                        } else {
                            super.onCompleted();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(this.nl.getValue(o));
                }
                if (e == r) {
                    boolean empty;
                    if (a.isUnsubscribed()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    boolean bl = empty = q.get() == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.onError(ex);
                        } else {
                            super.onCompleted();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                BackpressureUtils.produced(this, e);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static final class BufferAsyncEmitter<T>
    extends BaseAsyncEmitter<T> {
        private static final long serialVersionUID = 2427151001689639875L;
        final Queue<Object> queue;
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip;
        final NotificationLite<T> nl;

        public BufferAsyncEmitter(Subscriber<? super T> actual, int capacityHint) {
            super(actual);
            this.queue = UnsafeAccess.isUnsafeAvailable() ? new SpscUnboundedArrayQueue(capacityHint) : new SpscUnboundedAtomicArrayQueue(capacityHint);
            this.wip = new AtomicInteger();
            this.nl = NotificationLite.instance();
        }

        @Override
        public void onNext(T t) {
            this.queue.offer(this.nl.next(t));
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequested() {
            this.drain();
        }

        @Override
        void onUnsubscribed() {
            if (this.wip.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = this.actual;
            Queue<Object> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (a.isUnsubscribed()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    Object o = q.poll();
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.onError(ex);
                        } else {
                            super.onCompleted();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(this.nl.getValue(o));
                }
                if (e == r) {
                    if (a.isUnsubscribed()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    boolean empty = q.isEmpty();
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.onError(ex);
                        } else {
                            super.onCompleted();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                BackpressureUtils.produced(this, e);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static final class ErrorAsyncEmitter<T>
    extends NoOverflowBaseAsyncEmitter<T> {
        private static final long serialVersionUID = 338953216916120960L;

        public ErrorAsyncEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        void onOverflow() {
            this.onError(new MissingBackpressureException("fromAsync: could not emit value due to lack of requests"));
        }
    }

    static final class DropAsyncEmitter<T>
    extends NoOverflowBaseAsyncEmitter<T> {
        private static final long serialVersionUID = 8360058422307496563L;

        public DropAsyncEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        void onOverflow() {
        }
    }

    static abstract class NoOverflowBaseAsyncEmitter<T>
    extends BaseAsyncEmitter<T> {
        private static final long serialVersionUID = 4127754106204442833L;

        public NoOverflowBaseAsyncEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public final void onNext(T t) {
            if (this.actual.isUnsubscribed()) {
                return;
            }
            if (this.get() != 0L) {
                this.actual.onNext(t);
                BackpressureUtils.produced(this, 1L);
            } else {
                this.onOverflow();
            }
        }

        abstract void onOverflow();
    }

    static final class NoneAsyncEmitter<T>
    extends BaseAsyncEmitter<T> {
        private static final long serialVersionUID = 3776720187248809713L;

        public NoneAsyncEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public void onNext(T t) {
            long r;
            if (this.actual.isUnsubscribed()) {
                return;
            }
            this.actual.onNext(t);
            while ((r = this.get()) != 0L && !this.compareAndSet(r, r - 1L)) {
            }
        }
    }

    static abstract class BaseAsyncEmitter<T>
    extends AtomicLong
    implements AsyncEmitter<T>,
    Producer,
    Subscription {
        private static final long serialVersionUID = 7326289992464377023L;
        final Subscriber<? super T> actual;
        final SerialSubscription serial;

        public BaseAsyncEmitter(Subscriber<? super T> actual) {
            this.actual = actual;
            this.serial = new SerialSubscription();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            if (this.actual.isUnsubscribed()) {
                return;
            }
            try {
                this.actual.onCompleted();
            }
            finally {
                this.serial.unsubscribe();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            if (this.actual.isUnsubscribed()) {
                return;
            }
            try {
                this.actual.onError(e);
            }
            finally {
                this.serial.unsubscribe();
            }
        }

        @Override
        public final void unsubscribe() {
            this.serial.unsubscribe();
            this.onUnsubscribed();
        }

        void onUnsubscribed() {
        }

        @Override
        public final boolean isUnsubscribed() {
            return this.serial.isUnsubscribed();
        }

        @Override
        public final void request(long n) {
            if (BackpressureUtils.validate(n)) {
                BackpressureUtils.getAndAddRequest(this, n);
                this.onRequested();
            }
        }

        void onRequested() {
        }

        @Override
        public final void setSubscription(Subscription s) {
            this.serial.set(s);
        }

        @Override
        public final void setCancellation(AsyncEmitter.Cancellable c) {
            this.setSubscription(new CancellableSubscription(c));
        }

        @Override
        public final long requested() {
            return this.get();
        }
    }

    static final class CancellableSubscription
    extends AtomicReference<AsyncEmitter.Cancellable>
    implements Subscription {
        private static final long serialVersionUID = 5718521705281392066L;

        public CancellableSubscription(AsyncEmitter.Cancellable cancellable) {
            super(cancellable);
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get() == null;
        }

        @Override
        public void unsubscribe() {
            AsyncEmitter.Cancellable c;
            if (this.get() != null && (c = (AsyncEmitter.Cancellable)this.getAndSet(null)) != null) {
                try {
                    c.cancel();
                }
                catch (Exception ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaHooks.onError(ex);
                }
            }
        }
    }
}

