/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.annotations.IRecordFieldDataGen;
import org.apache.asterix.common.annotations.RecordDataGenAnnotation;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.expression.OrderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.RecordTypeDefinition;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.expression.UnorderedListTypeDefinition;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.asterix.metadata.utils.TypeUtil;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.AbstractComplexType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class TypeTranslator {
    private TypeTranslator() {
    }

    public static Map<TypeSignature, IAType> computeTypes(DataverseName typeDataverse, String typeName, TypeExpression typeExpr, DataverseName defaultDataverse, MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        HashMap<TypeSignature, IAType> typeMap = new HashMap<TypeSignature, IAType>();
        TypeTranslator.computeTypes(typeDataverse, typeName, typeExpr, defaultDataverse, mdTxnCtx, typeMap);
        return typeMap;
    }

    public static void computeTypes(DataverseName typeDataverse, String typeName, TypeExpression typeExpr, DataverseName defaultDataverse, MetadataTransactionContext mdTxnCtx, Map<TypeSignature, IAType> outTypeMap) throws AlgebricksException {
        HashMap<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes = new HashMap<String, Map<ARecordType, List<Integer>>>();
        HashMap<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes = new HashMap<TypeSignature, List<AbstractCollectionType>>();
        HashMap<TypeSignature, List<TypeSignature>> incompleteTopLevelTypeReferences = new HashMap<TypeSignature, List<TypeSignature>>();
        TypeTranslator.firstPass(typeDataverse, typeName, typeExpr, outTypeMap, incompleteFieldTypes, incompleteItemTypes, incompleteTopLevelTypeReferences, typeDataverse);
        TypeTranslator.secondPass(mdTxnCtx, outTypeMap, incompleteFieldTypes, incompleteItemTypes, incompleteTopLevelTypeReferences, typeDataverse, typeExpr.getSourceLocation());
        for (IAType type : outTypeMap.values()) {
            if (!type.getTypeTag().isDerivedType()) continue;
            ((AbstractComplexType)type).generateNestedDerivedTypeNames();
        }
    }

    private static void firstPass(DataverseName typeDataverse, String typeName, TypeExpression typeExpr, Map<TypeSignature, IAType> outTypeMap, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, Map<TypeSignature, List<TypeSignature>> incompleteTopLevelTypeReferences, DataverseName defaultDataverse) throws AlgebricksException {
        if (BuiltinTypeMap.getBuiltinType((String)typeName) != null) {
            throw new CompilationException(1079, typeExpr.getSourceLocation(), new Serializable[]{"Cannot redefine builtin type " + typeName});
        }
        TypeSignature typeSignature = new TypeSignature(typeDataverse, typeName);
        switch (typeExpr.getTypeKind()) {
            case TYPEREFERENCE: {
                TypeReferenceExpression tre = (TypeReferenceExpression)typeExpr;
                TypeSignature treSignature = TypeTranslator.createTypeSignature(tre, defaultDataverse);
                IAType t = TypeTranslator.solveTypeReference(treSignature, outTypeMap);
                if (t != null) {
                    outTypeMap.put(typeSignature, t);
                    break;
                }
                TypeTranslator.addIncompleteTopLevelTypeReference(typeSignature, treSignature, incompleteTopLevelTypeReferences);
                break;
            }
            case RECORD: {
                RecordTypeDefinition rtd = (RecordTypeDefinition)typeExpr;
                ARecordType recType = TypeTranslator.computeRecordType(typeSignature, rtd, outTypeMap, incompleteFieldTypes, incompleteItemTypes, typeDataverse);
                outTypeMap.put(typeSignature, (IAType)recType);
                break;
            }
            case ORDEREDLIST: {
                OrderedListTypeDefinition oltd = (OrderedListTypeDefinition)typeExpr;
                AOrderedListType olType = TypeTranslator.computeOrderedListType(typeSignature, oltd, outTypeMap, incompleteItemTypes, incompleteFieldTypes, typeDataverse);
                outTypeMap.put(typeSignature, (IAType)olType);
                break;
            }
            case UNORDEREDLIST: {
                UnorderedListTypeDefinition ultd = (UnorderedListTypeDefinition)typeExpr;
                AUnorderedListType ulType = TypeTranslator.computeUnorderedListType(typeSignature, ultd, outTypeMap, incompleteItemTypes, incompleteFieldTypes, typeDataverse);
                outTypeMap.put(typeSignature, (IAType)ulType);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static void secondPass(MetadataTransactionContext mdTxnCtx, Map<TypeSignature, IAType> typeMap, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, Map<TypeSignature, List<TypeSignature>> incompleteTopLevelTypeReferences, DataverseName typeDataverse, SourceLocation sourceLoc) throws AlgebricksException {
        IAType t;
        Datatype dt;
        for (TypeSignature typeSignature : incompleteTopLevelTypeReferences.keySet()) {
            dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, typeSignature.getDataverseName(), typeSignature.getName());
            if (dt == null) {
                throw new CompilationException(1082, sourceLoc, new Serializable[]{typeSignature.getName()});
            }
            t = dt.getDatatype();
            for (TypeSignature typeSignature2 : incompleteTopLevelTypeReferences.get(typeSignature)) {
                typeMap.put(typeSignature2, t);
            }
        }
        for (String trefName : incompleteFieldTypes.keySet()) {
            dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, typeDataverse, trefName);
            if (dt == null) {
                dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, MetadataConstants.METADATA_DATAVERSE_NAME, trefName);
            }
            if (dt == null) {
                throw new CompilationException(1082, sourceLoc, new Serializable[]{trefName});
            }
            t = dt.getDatatype();
            Map<ARecordType, List<Integer>> fieldsToFix = incompleteFieldTypes.get(trefName);
            for (ARecordType recType : fieldsToFix.keySet()) {
                List<Integer> positions = fieldsToFix.get(recType);
                IAType[] fldTypes = recType.getFieldTypes();
                for (Integer pos : positions) {
                    if (fldTypes[pos] == null) {
                        fldTypes[pos.intValue()] = t;
                        continue;
                    }
                    AUnionType nullableUnion = (AUnionType)fldTypes[pos];
                    nullableUnion.setActualType(t);
                }
            }
        }
        for (TypeSignature typeSignature : incompleteItemTypes.keySet()) {
            if (MetadataManager.INSTANCE != null) {
                dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, typeSignature.getDataverseName(), typeSignature.getName());
                if (dt == null) {
                    throw new CompilationException(1082, sourceLoc, new Serializable[]{typeSignature.getName()});
                }
                t = dt.getDatatype();
            } else {
                t = typeMap.get(typeSignature);
            }
            for (AbstractCollectionType abstractCollectionType : incompleteItemTypes.get(typeSignature)) {
                abstractCollectionType.setItemType(t);
            }
        }
    }

    private static AOrderedListType computeOrderedListType(TypeSignature typeSignature, OrderedListTypeDefinition oltd, Map<TypeSignature, IAType> typeMap, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes, DataverseName defaultDataverse) throws AlgebricksException {
        TypeExpression tExpr = oltd.getItemTypeExpression();
        String typeName = typeSignature != null ? typeSignature.getName() : null;
        AOrderedListType aolt = new AOrderedListType((IAType)BuiltinType.ANY, typeName);
        TypeTranslator.setCollectionItemType(tExpr, typeMap, incompleteItemTypes, incompleteFieldTypes, (AbstractCollectionType)aolt, defaultDataverse);
        return aolt;
    }

    private static AUnorderedListType computeUnorderedListType(TypeSignature typeSignature, UnorderedListTypeDefinition ultd, Map<TypeSignature, IAType> typeMap, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes, DataverseName defaulDataverse) throws AlgebricksException {
        TypeExpression tExpr = ultd.getItemTypeExpression();
        String typeName = typeSignature != null ? typeSignature.getName() : null;
        AUnorderedListType ault = new AUnorderedListType((IAType)BuiltinType.ANY, typeName);
        TypeTranslator.setCollectionItemType(tExpr, typeMap, incompleteItemTypes, incompleteFieldTypes, (AbstractCollectionType)ault, defaulDataverse);
        return ault;
    }

    private static void setCollectionItemType(TypeExpression tExpr, Map<TypeSignature, IAType> typeMap, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes, AbstractCollectionType act, DataverseName defaultDataverse) throws AlgebricksException {
        switch (tExpr.getTypeKind()) {
            case ORDEREDLIST: {
                OrderedListTypeDefinition oltd = (OrderedListTypeDefinition)tExpr;
                AOrderedListType t = TypeTranslator.computeOrderedListType(null, oltd, typeMap, incompleteItemTypes, incompleteFieldTypes, defaultDataverse);
                act.setItemType((IAType)t);
                break;
            }
            case UNORDEREDLIST: {
                UnorderedListTypeDefinition ultd = (UnorderedListTypeDefinition)tExpr;
                AUnorderedListType t = TypeTranslator.computeUnorderedListType(null, ultd, typeMap, incompleteItemTypes, incompleteFieldTypes, defaultDataverse);
                act.setItemType((IAType)t);
                break;
            }
            case RECORD: {
                RecordTypeDefinition rtd = (RecordTypeDefinition)tExpr;
                ARecordType t = TypeTranslator.computeRecordType(null, rtd, typeMap, incompleteFieldTypes, incompleteItemTypes, defaultDataverse);
                act.setItemType((IAType)t);
                break;
            }
            case TYPEREFERENCE: {
                TypeReferenceExpression tre = (TypeReferenceExpression)tExpr;
                TypeSignature treSignature = TypeTranslator.createTypeSignature(tre, defaultDataverse);
                IAType tref = TypeTranslator.solveTypeReference(treSignature, typeMap);
                if (tref != null) {
                    act.setItemType(tref);
                    break;
                }
                TypeTranslator.addIncompleteCollectionTypeReference(act, tre, incompleteItemTypes, defaultDataverse);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static void addIncompleteCollectionTypeReference(AbstractCollectionType collType, TypeReferenceExpression tre, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, DataverseName defaultDataverse) {
        TypeSignature typeSignature = TypeTranslator.createTypeSignature(tre, defaultDataverse);
        List typeList = incompleteItemTypes.computeIfAbsent(typeSignature, k -> new ArrayList());
        typeList.add(collType);
    }

    private static void addIncompleteFieldTypeReference(ARecordType recType, int fldPosition, TypeReferenceExpression tre, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes) {
        String typeName = ((Identifier)tre.getIdent().second).getValue();
        Map refMap = incompleteFieldTypes.computeIfAbsent(typeName, k -> new HashMap());
        List typeList = refMap.computeIfAbsent(recType, k -> new ArrayList());
        typeList.add(fldPosition);
    }

    private static void addIncompleteTopLevelTypeReference(TypeSignature typeSignature, TypeSignature treSignature, Map<TypeSignature, List<TypeSignature>> incompleteTopLevelTypeReferences) {
        List refList = incompleteTopLevelTypeReferences.computeIfAbsent(treSignature, k -> new ArrayList());
        refList.add(typeSignature);
    }

    private static IAType solveTypeReference(TypeSignature typeSignature, Map<TypeSignature, IAType> typeMap) {
        BuiltinType builtin = BuiltinTypeMap.getBuiltinType((String)typeSignature.getName());
        if (builtin != null) {
            return builtin;
        }
        return typeMap.get(typeSignature);
    }

    private static ARecordType computeRecordType(TypeSignature typeSignature, RecordTypeDefinition rtd, Map<TypeSignature, IAType> typeMap, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, DataverseName defaultDataverse) throws AlgebricksException {
        List names = rtd.getFieldNames();
        int n = names.size();
        String[] fldNames = new String[n];
        IAType[] fldTypes = new IAType[n];
        int i = 0;
        for (String s : names) {
            fldNames[i++] = s;
        }
        boolean isOpen = rtd.getRecordKind() == RecordTypeDefinition.RecordKind.OPEN;
        ARecordType recType = new ARecordType(typeSignature == null ? null : typeSignature.getName(), fldNames, fldTypes, isOpen);
        List fieldDataGen = rtd.getFieldDataGen();
        if (fieldDataGen.size() == n) {
            IRecordFieldDataGen[] rfdg = new IRecordFieldDataGen[n];
            rfdg = fieldDataGen.toArray(rfdg);
            recType.getAnnotations().add(new RecordDataGenAnnotation(rfdg, rtd.getUndeclaredFieldsDataGen()));
        }
        for (int j = 0; j < n; ++j) {
            IAType type;
            TypeExpression texpr = (TypeExpression)rtd.getFieldTypes().get(j);
            switch (texpr.getTypeKind()) {
                case TYPEREFERENCE: {
                    TypeReferenceExpression tre = (TypeReferenceExpression)texpr;
                    TypeSignature signature = TypeTranslator.createTypeSignature(tre, defaultDataverse);
                    type = TypeTranslator.solveTypeReference(signature, typeMap);
                    if (type != null) break;
                    TypeTranslator.addIncompleteFieldTypeReference(recType, j, tre, incompleteFieldTypes);
                    break;
                }
                case RECORD: {
                    RecordTypeDefinition recTypeDef2 = (RecordTypeDefinition)texpr;
                    type = TypeTranslator.computeRecordType(null, recTypeDef2, typeMap, incompleteFieldTypes, incompleteItemTypes, defaultDataverse);
                    break;
                }
                case ORDEREDLIST: {
                    OrderedListTypeDefinition oltd = (OrderedListTypeDefinition)texpr;
                    type = TypeTranslator.computeOrderedListType(null, oltd, typeMap, incompleteItemTypes, incompleteFieldTypes, defaultDataverse);
                    break;
                }
                case UNORDEREDLIST: {
                    UnorderedListTypeDefinition ultd = (UnorderedListTypeDefinition)texpr;
                    type = TypeTranslator.computeUnorderedListType(null, ultd, typeMap, incompleteItemTypes, incompleteFieldTypes, defaultDataverse);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Boolean nullable = (Boolean)rtd.getNullableFields().get(j);
            Boolean missable = (Boolean)rtd.getMissableFields().get(j);
            fldTypes[j] = TypeUtil.createQuantifiedType((IAType)type, (boolean)nullable, (boolean)missable);
        }
        return recType;
    }

    private static TypeSignature createTypeSignature(TypeReferenceExpression tre, DataverseName defaultDataverse) {
        Pair treTypeName = tre.getIdent();
        DataverseName activeDataverse = treTypeName.first == null ? defaultDataverse : (DataverseName)treTypeName.first;
        return new TypeSignature(activeDataverse, ((Identifier)treTypeName.second).getValue());
    }
}

