/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.util.Arrays;
import java.util.Objects;
import org.apache.asterix.common.metadata.DataverseName;

public final class DataSourceId {
    private final DataverseName dataverseName;
    private final String datasourceName;
    private final String[] parameters;

    public DataSourceId(DataverseName dataverseName, String datasourceName) {
        this(dataverseName, datasourceName, null);
    }

    public DataSourceId(DataverseName dataverseName, String datasourceName, String[] parameters) {
        this.dataverseName = dataverseName;
        this.datasourceName = datasourceName;
        this.parameters = parameters;
    }

    public String toString() {
        return this.dataverseName + "." + this.datasourceName + (this.parameters != null ? "." + String.join((CharSequence)".", this.parameters) : "");
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceId that = (DataSourceId)o;
        return this.dataverseName.equals((Object)that.dataverseName) && this.datasourceName.equals(that.datasourceName) && Arrays.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = Objects.hash(this.dataverseName, this.datasourceName);
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }
}

