/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.AbstractBinaryStringBoolEval;
import org.apache.asterix.runtime.evaluators.functions.StringEvaluatorUtils;
import org.apache.asterix.runtime.evaluators.functions.utils.RegExpMatcher;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

@MissingNullInOutFunction
public class StringLikeDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = StringLikeDescriptor::new;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.STRING_LIKE;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new StringLikeEval(ctx, args[0], args[1], StringLikeDescriptor.this.getIdentifier(), StringLikeDescriptor.this.sourceLoc);
            }
        };
    }

    private static class StringLikeEval
    extends AbstractBinaryStringBoolEval
    implements RegExpMatcher.IRegExpPatternGenerator {
        private static final UTF8StringPointable DOT_ALL_FLAG = UTF8StringPointable.generateUTF8Pointable((String)"s");
        private static final char likeEscapeChar = '\\';
        private final RegExpMatcher matcher = new RegExpMatcher();
        private final StringBuilder tempStringBuilder = new StringBuilder();

        StringLikeEval(IEvaluatorContext context, IScalarEvaluatorFactory evalLeftFactory, IScalarEvaluatorFactory evalRightFactory, FunctionIdentifier funcID, SourceLocation sourceLoc) throws HyracksDataException {
            super(context, evalLeftFactory, evalRightFactory, funcID, sourceLoc);
        }

        @Override
        protected boolean compute(UTF8StringPointable srcPtr, UTF8StringPointable patternPtr) throws HyracksDataException {
            this.matcher.build(srcPtr, patternPtr, DOT_ALL_FLAG, this);
            return this.matcher.matches();
        }

        @Override
        public String toRegExpPatternString(String pattern) throws HyracksDataException {
            this.tempStringBuilder.setLength(0);
            int length = pattern.length();
            for (int i = 0; i < length; ++i) {
                char c = pattern.charAt(i);
                if (c == '\\') {
                    char nextChar;
                    if (i >= length - 1 || (nextChar = pattern.charAt(i + 1)) != '%' && nextChar != '_' && nextChar != '\\') {
                        throw new RuntimeDataException(46, this.sourceLoc, new Serializable[]{pattern});
                    }
                    if (Arrays.binarySearch(StringEvaluatorUtils.RESERVED_REGEX_CHARS, nextChar) >= 0) {
                        this.tempStringBuilder.append('\\');
                    }
                    this.tempStringBuilder.append(nextChar);
                    ++i;
                    continue;
                }
                if (c == '%') {
                    this.tempStringBuilder.append(".*");
                    continue;
                }
                if (c == '_') {
                    this.tempStringBuilder.append('.');
                    continue;
                }
                if (Arrays.binarySearch(StringEvaluatorUtils.RESERVED_REGEX_CHARS, c) >= 0) {
                    this.tempStringBuilder.append('\\');
                }
                this.tempStringBuilder.append(c);
            }
            return this.tempStringBuilder.toString();
        }
    }
}

