/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.cache;

import java.util.Date;

public class CachedObject
implements Comparable {
    Object value;
    String key;
    Date timestamp = new Date();

    public CachedObject() {
    }

    public CachedObject(String key, Object value) {
        this.key = key;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getTime() {
        return this.getTimestamp().getTime();
    }

    public int compareTo(Object o) {
        if (!(o instanceof CachedObject)) {
            throw new ClassCastException("The given object is of type " + o.getClass().getName() + " and cannot be compared to a CachedObject");
        }
        CachedObject co = (CachedObject)o;
        return Long.signum(this.getTime() - co.getTime());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CachedObject)) {
            return false;
        }
        return this.getKey().equals(((CachedObject)obj).getKey());
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }
}

