/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.core.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.authentication.SSHKeyAuthentication;
import org.apache.airavata.gfac.core.cluster.RemoteCluster;
import org.apache.airavata.gfac.core.cluster.ServerInfo;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription;
import org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription;
import org.apache.airavata.model.appcatalog.computeresource.BatchQueue;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.MonitorMode;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager;
import org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission;
import org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference;
import org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile;
import org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference;
import org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference;
import org.apache.airavata.model.data.movement.DataMovementProtocol;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.process.ProcessModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.status.ProcessState;
import org.apache.airavata.model.status.ProcessStatus;
import org.apache.airavata.model.task.TaskModel;
import org.apache.airavata.registry.cpi.AppCatalog;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.ExperimentCatalog;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessContext {
    private static final Logger log = LoggerFactory.getLogger(ProcessContext.class);
    private ExperimentCatalog experimentCatalog;
    private AppCatalog appCatalog;
    private CuratorFramework curatorClient;
    private Publisher statusPublisher;
    private final String processId;
    private final String gatewayId;
    private final String tokenId;
    private ProcessModel processModel;
    private String workingDir;
    private String scratchLocation;
    private String inputDir;
    private String outputDir;
    private String localWorkingDir;
    private GatewayResourceProfile gatewayResourceProfile;
    private ComputeResourcePreference gatewayComputeResourcePreference;
    private StoragePreference gatewayStorageResourcePreference;
    private UserResourceProfile userResourceProfile;
    private UserComputeResourcePreference userComputeResourcePreference;
    private UserStoragePreference userStoragePreference;
    private ComputeResourceDescription computeResourceDescription;
    private ApplicationDeploymentDescription applicationDeploymentDescription;
    private ApplicationInterfaceDescription applicationInterfaceDescription;
    private RemoteCluster jobSubmissionRemoteCluster;
    private RemoteCluster dataMovementRemoteCluster;
    private Map<String, String> sshProperties;
    private String stdoutLocation;
    private String stderrLocation;
    private JobSubmissionProtocol jobSubmissionProtocol;
    private DataMovementProtocol dataMovementProtocol;
    private JobModel jobModel;
    private StorageResourceDescription storageResource;
    private MonitorMode monitorMode;
    private ResourceJobManager resourceJobManager;
    private boolean handOver;
    private boolean cancel;
    private ServerInfo serverInfo;
    private List<String> taskExecutionOrder;
    private List<TaskModel> taskList;
    private Map<String, TaskModel> taskMap;
    private boolean pauseTaskExecution = false;
    private boolean complete = false;
    private boolean recovery = false;
    private TaskModel currentExecutingTaskModel;
    private boolean acknowledge;
    private SSHKeyAuthentication sshKeyAuthentication;
    private boolean recoveryWithCancel = false;
    private String usageReportingGatewayId;
    private List<String> queueSpecificMacros;

    private ProcessContext(String processId, String gatewayId, String tokenId) {
        this.processId = processId;
        this.gatewayId = gatewayId;
        this.tokenId = tokenId;
    }

    public ExperimentCatalog getExperimentCatalog() {
        return this.experimentCatalog;
    }

    public void setExperimentCatalog(ExperimentCatalog experimentCatalog) {
        this.experimentCatalog = experimentCatalog;
    }

    public AppCatalog getAppCatalog() {
        return this.appCatalog;
    }

    public void setAppCatalog(AppCatalog appCatalog) {
        this.appCatalog = appCatalog;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public CuratorFramework getCuratorClient() {
        return this.curatorClient;
    }

    public void setCuratorClient(CuratorFramework curatorClient) {
        this.curatorClient = curatorClient;
    }

    public Publisher getStatusPublisher() {
        return this.statusPublisher;
    }

    public void setStatusPublisher(Publisher statusPublisher) {
        this.statusPublisher = statusPublisher;
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    public void setProcessModel(ProcessModel processModel) {
        this.processModel = processModel;
    }

    public String getWorkingDir() {
        if (this.workingDir == null) {
            String scratchLocation;
            this.workingDir = this.processModel.getProcessResourceSchedule().getStaticWorkingDir() != null ? this.processModel.getProcessResourceSchedule().getStaticWorkingDir() : ((scratchLocation = this.getScratchLocation()).endsWith("/") ? scratchLocation + this.processId : scratchLocation + "/" + this.processId);
        }
        return this.workingDir;
    }

    public String getScratchLocation() {
        if (this.scratchLocation == null) {
            this.scratchLocation = this.isUseUserCRPref() && this.userComputeResourcePreference != null && this.isValid(this.userComputeResourcePreference.getScratchLocation()) ? this.userComputeResourcePreference.getScratchLocation() : (this.isValid(this.processModel.getProcessResourceSchedule().getOverrideScratchLocation()) ? this.processModel.getProcessResourceSchedule().getOverrideScratchLocation() : this.gatewayComputeResourcePreference.getScratchLocation());
        }
        return this.scratchLocation;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public GatewayResourceProfile getGatewayResourceProfile() {
        return this.gatewayResourceProfile;
    }

    public void setGatewayResourceProfile(GatewayResourceProfile gatewayResourceProfile) {
        this.gatewayResourceProfile = gatewayResourceProfile;
    }

    public UserResourceProfile getUserResourceProfile() {
        return this.userResourceProfile;
    }

    public void setUserResourceProfile(UserResourceProfile userResourceProfile) {
        this.userResourceProfile = userResourceProfile;
    }

    private UserComputeResourcePreference getUserComputeResourcePreference() {
        return this.userComputeResourcePreference;
    }

    public void setUserComputeResourcePreference(UserComputeResourcePreference userComputeResourcePreference) {
        this.userComputeResourcePreference = userComputeResourcePreference;
    }

    public UserStoragePreference getUserStoragePreference() {
        return this.userStoragePreference;
    }

    public void setUserStoragePreference(UserStoragePreference userStoragePreference) {
        this.userStoragePreference = userStoragePreference;
    }

    public StoragePreference getGatewayStorageResourcePreference() {
        return this.gatewayStorageResourcePreference;
    }

    public void setGatewayStorageResourcePreference(StoragePreference gatewayStorageResourcePreference) {
        this.gatewayStorageResourcePreference = gatewayStorageResourcePreference;
    }

    public RemoteCluster getJobSubmissionRemoteCluster() {
        return this.jobSubmissionRemoteCluster;
    }

    public void setJobSubmissionRemoteCluster(RemoteCluster jobSubmissoinRemoteCluster) {
        this.jobSubmissionRemoteCluster = jobSubmissoinRemoteCluster;
    }

    public RemoteCluster getDataMovementRemoteCluster() {
        return this.dataMovementRemoteCluster;
    }

    public void setDataMovementRemoteCluster(RemoteCluster dataMovementRemoteCluster) {
        this.dataMovementRemoteCluster = dataMovementRemoteCluster;
    }

    public Map<String, String> getSshProperties() {
        return this.sshProperties;
    }

    public void setSshProperties(Map<String, String> sshProperties) {
        this.sshProperties = sshProperties;
    }

    public ComputeResourceDescription getComputeResourceDescription() {
        return this.computeResourceDescription;
    }

    public void setComputeResourceDescription(ComputeResourceDescription computeResourceDescription) {
        this.computeResourceDescription = computeResourceDescription;
    }

    public ApplicationDeploymentDescription getApplicationDeploymentDescription() {
        return this.applicationDeploymentDescription;
    }

    public void setApplicationDeploymentDescription(ApplicationDeploymentDescription applicationDeploymentDescription) {
        this.applicationDeploymentDescription = applicationDeploymentDescription;
    }

    public ApplicationInterfaceDescription getApplicationInterfaceDescription() {
        return this.applicationInterfaceDescription;
    }

    public void setApplicationInterfaceDescription(ApplicationInterfaceDescription applicationInterfaceDescription) {
        this.applicationInterfaceDescription = applicationInterfaceDescription;
    }

    public String getStdoutLocation() {
        return this.stdoutLocation;
    }

    public void setStdoutLocation(String stdoutLocation) {
        this.stdoutLocation = stdoutLocation;
    }

    public String getStderrLocation() {
        return this.stderrLocation;
    }

    public void setStderrLocation(String stderrLocation) {
        this.stderrLocation = stderrLocation;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public String getOutputDir() {
        if (this.outputDir == null) {
            this.outputDir = this.getWorkingDir();
        }
        return this.outputDir;
    }

    public String getInputDir() {
        if (this.inputDir == null) {
            this.inputDir = this.getWorkingDir();
        }
        return this.inputDir;
    }

    public void setInputDir(String inputDir) {
        this.inputDir = inputDir;
    }

    public JobSubmissionProtocol getJobSubmissionProtocol() {
        if (this.jobSubmissionProtocol == null) {
            this.jobSubmissionProtocol = this.gatewayComputeResourcePreference.getPreferredJobSubmissionProtocol();
        }
        return this.jobSubmissionProtocol;
    }

    public void setJobSubmissionProtocol(JobSubmissionProtocol jobSubmissionProtocol) {
        this.jobSubmissionProtocol = jobSubmissionProtocol;
    }

    public DataMovementProtocol getDataMovementProtocol() {
        if (this.dataMovementProtocol == null) {
            this.dataMovementProtocol = this.gatewayComputeResourcePreference.getPreferredDataMovementProtocol();
        }
        return this.dataMovementProtocol;
    }

    public void setDataMovementProtocol(DataMovementProtocol dataMovementProtocol) {
        this.dataMovementProtocol = dataMovementProtocol;
    }

    public String getTaskDag() {
        return this.getProcessModel().getTaskDag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<TaskModel> getTaskList() {
        if (this.taskList != null) return this.taskList;
        Class<TaskModel> clazz = TaskModel.class;
        synchronized (TaskModel.class) {
            if (this.taskList != null) return this.taskList;
            this.taskList = this.getProcessModel().getTasks();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.taskList;
        }
    }

    public List<String> getTaskExecutionOrder() {
        return this.taskExecutionOrder;
    }

    public void setTaskExecutionOrder(List<String> taskExecutionOrder) {
        this.taskExecutionOrder = taskExecutionOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, TaskModel> getTaskMap() {
        if (this.taskMap != null) return this.taskMap;
        Class<TaskModel> clazz = TaskModel.class;
        synchronized (TaskModel.class) {
            if (this.taskMap != null) return this.taskMap;
            this.taskMap = new HashMap<String, TaskModel>();
            for (TaskModel taskModel : this.getTaskList()) {
                this.taskMap.put(taskModel.getTaskId(), taskModel);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.taskMap;
        }
    }

    public JobModel getJobModel() {
        if (this.jobModel == null) {
            this.jobModel = new JobModel();
            this.jobModel.setProcessId(this.processId);
            this.jobModel.setWorkingDir(this.getWorkingDir());
            this.jobModel.setCreationTime(AiravataUtils.getCurrentTimestamp().getTime());
        }
        return this.jobModel;
    }

    public void setJobModel(JobModel jobModel) {
        this.jobModel = jobModel;
    }

    private ComputeResourcePreference getGatewayComputeResourcePreference() {
        return this.gatewayComputeResourcePreference;
    }

    public void setGatewayComputeResourcePreference(ComputeResourcePreference gatewayComputeResourcePreference) {
        this.gatewayComputeResourcePreference = gatewayComputeResourcePreference;
    }

    public ProcessState getProcessState() {
        if (this.processModel.getProcessStatuses() != null && this.processModel.getProcessStatuses().size() > 0) {
            return ((ProcessStatus)this.processModel.getProcessStatuses().get(0)).getState();
        }
        return null;
    }

    public void setProcessStatus(ProcessStatus status) {
        if (status != null) {
            log.info("expId: {}, processId: {} :- Process status changed {} -> {}", new Object[]{this.getExperimentId(), this.processId, this.getProcessState().name(), status.getState().name()});
            ArrayList<ProcessStatus> processStatuses = new ArrayList<ProcessStatus>();
            processStatuses.add(status);
            this.processModel.setProcessStatuses(processStatuses);
        }
    }

    public ProcessStatus getProcessStatus() {
        if (this.processModel.getProcessStatuses() != null) {
            return (ProcessStatus)this.processModel.getProcessStatuses().get(0);
        }
        return null;
    }

    public String getComputeResourceId() {
        if (this.isUseUserCRPref() && this.userComputeResourcePreference != null && this.isValid(this.userComputeResourcePreference.getComputeResourceId())) {
            return this.userComputeResourcePreference.getComputeResourceId();
        }
        return this.gatewayComputeResourcePreference.getComputeResourceId();
    }

    public String getComputeResourceCredentialToken() {
        if (this.isUseUserCRPref()) {
            if (this.userComputeResourcePreference != null && this.isValid(this.userComputeResourcePreference.getResourceSpecificCredentialStoreToken())) {
                return this.userComputeResourcePreference.getResourceSpecificCredentialStoreToken();
            }
            return this.userResourceProfile.getCredentialStoreToken();
        }
        if (this.isValid(this.gatewayComputeResourcePreference.getResourceSpecificCredentialStoreToken())) {
            return this.gatewayComputeResourcePreference.getResourceSpecificCredentialStoreToken();
        }
        return this.gatewayResourceProfile.getCredentialStoreToken();
    }

    public String getStorageResourceCredentialToken() {
        if (this.isValid(this.gatewayStorageResourcePreference.getResourceSpecificCredentialStoreToken())) {
            return this.gatewayStorageResourcePreference.getResourceSpecificCredentialStoreToken();
        }
        return this.gatewayResourceProfile.getCredentialStoreToken();
    }

    public JobSubmissionProtocol getPreferredJobSubmissionProtocol() {
        return this.gatewayComputeResourcePreference.getPreferredJobSubmissionProtocol();
    }

    public DataMovementProtocol getPreferredDataMovementProtocol() {
        return this.gatewayComputeResourcePreference.getPreferredDataMovementProtocol();
    }

    public void setMonitorMode(MonitorMode monitorMode) {
        this.monitorMode = monitorMode;
    }

    public MonitorMode getMonitorMode() {
        return this.monitorMode;
    }

    public void setResourceJobManager(ResourceJobManager resourceJobManager) {
        this.resourceJobManager = resourceJobManager;
    }

    public ResourceJobManager getResourceJobManager() {
        return this.resourceJobManager;
    }

    public String getLocalWorkingDir() {
        return this.localWorkingDir;
    }

    public void setLocalWorkingDir(String localWorkingDir) {
        this.localWorkingDir = localWorkingDir;
    }

    public String getExperimentId() {
        return this.processModel.getExperimentId();
    }

    public boolean isHandOver() {
        return this.handOver;
    }

    public void setHandOver(boolean handOver) {
        this.handOver = handOver;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public boolean isInterrupted() {
        return this.cancel || this.handOver;
    }

    public String getCurrentExecutingTaskId() {
        if (this.currentExecutingTaskModel != null) {
            return this.currentExecutingTaskModel.getTaskId();
        }
        return null;
    }

    public boolean isPauseTaskExecution() {
        return this.pauseTaskExecution;
    }

    public void setPauseTaskExecution(boolean pauseTaskExecution) {
        this.pauseTaskExecution = pauseTaskExecution;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isRecovery() {
        return this.recovery;
    }

    public void setRecovery(boolean recovery) {
        this.recovery = recovery;
    }

    public TaskModel getCurrentExecutingTaskModel() {
        return this.currentExecutingTaskModel;
    }

    public void setCurrentExecutingTaskModel(TaskModel currentExecutingTaskModel) {
        this.currentExecutingTaskModel = currentExecutingTaskModel;
    }

    public StorageResourceDescription getStorageResource() {
        return this.storageResource;
    }

    public void setStorageResource(StorageResourceDescription storageResource) {
        this.storageResource = storageResource;
    }

    public void setAcknowledge(boolean acknowledge) {
        this.acknowledge = acknowledge;
    }

    public boolean isAcknowledge() {
        return this.acknowledge;
    }

    public boolean isRecoveryWithCancel() {
        return this.recoveryWithCancel;
    }

    public void setRecoveryWithCancel(boolean recoveryWithCancel) {
        this.recoveryWithCancel = recoveryWithCancel;
    }

    public boolean isUseUserCRPref() {
        return this.getProcessModel().isUseUserCRPref();
    }

    public String getComputeResourceLoginUserName() {
        if (this.isUseUserCRPref() && this.userComputeResourcePreference != null && this.isValid(this.userComputeResourcePreference.getLoginUserName())) {
            return this.userComputeResourcePreference.getLoginUserName();
        }
        if (this.isValid(this.processModel.getProcessResourceSchedule().getOverrideLoginUserName())) {
            return this.processModel.getProcessResourceSchedule().getOverrideLoginUserName();
        }
        return this.gatewayComputeResourcePreference.getLoginUserName();
    }

    public String getStorageResourceLoginUserName() {
        return this.gatewayStorageResourcePreference.getLoginUserName();
    }

    public String getStorageFileSystemRootLocation() {
        return this.gatewayStorageResourcePreference.getFileSystemRootLocation();
    }

    public String getStorageResourceId() {
        return this.gatewayStorageResourcePreference.getStorageResourceId();
    }

    private ComputationalResourceSchedulingModel getProcessCRSchedule() {
        if (this.getProcessModel() != null) {
            return this.getProcessModel().getProcessResourceSchedule();
        }
        return null;
    }

    public ServerInfo getComputeResourceServerInfo() throws GFacException {
        Optional<JobSubmissionInterface> firstJobSubmissionIface;
        if (this.jobSubmissionProtocol == JobSubmissionProtocol.SSH && (firstJobSubmissionIface = this.getComputeResourceDescription().getJobSubmissionInterfaces().stream().filter(iface -> iface.getJobSubmissionProtocol() == JobSubmissionProtocol.SSH).findFirst()).isPresent()) {
            try {
                String hostName;
                SSHJobSubmission sshJobSubmission = this.appCatalog.getComputeResource().getSSHJobSubmission(firstJobSubmissionIface.get().getJobSubmissionInterfaceId());
                String alternateHostName = sshJobSubmission.getAlternativeSSHHostName();
                String string = hostName = alternateHostName != null && alternateHostName.length() != 0 ? alternateHostName : this.getComputeResourceDescription().getHostName();
                if (sshJobSubmission.getSshPort() > 0) {
                    return new ServerInfo(this.getComputeResourceLoginUserName(), hostName, this.getComputeResourceCredentialToken(), sshJobSubmission.getSshPort());
                }
                return new ServerInfo(this.getComputeResourceLoginUserName(), hostName, this.getComputeResourceCredentialToken());
            }
            catch (AppCatalogException e) {
                throw new GFacException("Failed to fetch ssh job submission for interface " + firstJobSubmissionIface.get().getJobSubmissionInterfaceId(), e);
            }
        }
        return new ServerInfo(this.getComputeResourceLoginUserName(), this.getComputeResourceDescription().getHostName(), this.getComputeResourceCredentialToken());
    }

    public ServerInfo getStorageResourceServerInfo() {
        return new ServerInfo(this.getStorageResourceLoginUserName(), this.getStorageResource().getHostName(), this.getStorageResourceCredentialToken());
    }

    private boolean isValid(String str) {
        return str != null && !str.trim().isEmpty();
    }

    public String getUsageReportingGatewayId() {
        return this.gatewayComputeResourcePreference.getUsageReportingGatewayId();
    }

    public String getAllocationProjectNumber() {
        if (this.isUseUserCRPref() && this.userComputeResourcePreference != null && this.userComputeResourcePreference.getAllocationProjectNumber() != null) {
            return this.userComputeResourcePreference.getAllocationProjectNumber();
        }
        return this.gatewayComputeResourcePreference.getAllocationProjectNumber();
    }

    public String getReservation() {
        long now;
        long start = 0L;
        long end = 0L;
        String reservation = null;
        if (this.isUseUserCRPref() && this.userComputeResourcePreference != null && this.userComputeResourcePreference.getReservation() != null) {
            reservation = this.userComputeResourcePreference.getReservation();
            start = this.userComputeResourcePreference.getReservationStartTime();
            end = this.userComputeResourcePreference.getReservationEndTime();
        } else {
            reservation = this.gatewayComputeResourcePreference.getReservation();
            start = this.gatewayComputeResourcePreference.getReservationStartTime();
            end = this.gatewayComputeResourcePreference.getReservationEndTime();
        }
        if (reservation != null && start > 0L && start < end && (now = Calendar.getInstance().getTimeInMillis()) > start && now < end) {
            return reservation;
        }
        return null;
    }

    public String getQualityOfService() {
        if (this.isUseUserCRPref() && this.userComputeResourcePreference != null && this.userComputeResourcePreference.getQualityOfService() != null) {
            return this.userComputeResourcePreference.getQualityOfService();
        }
        return this.gatewayComputeResourcePreference.getQualityOfService();
    }

    public String getQueueName() {
        if (this.isValid(this.processModel.getProcessResourceSchedule().getQueueName())) {
            return this.processModel.getProcessResourceSchedule().getQueueName();
        }
        if (this.isUseUserCRPref() && this.userComputeResourcePreference != null && this.userComputeResourcePreference.getPreferredBatchQueue() != null) {
            return this.userComputeResourcePreference.getPreferredBatchQueue();
        }
        return this.gatewayComputeResourcePreference.getPreferredBatchQueue();
    }

    public List<String> getQueueSpecificMacros() {
        String queueName = this.getProcessCRSchedule().getQueueName();
        Optional<BatchQueue> queue = this.getComputeResourceDescription().getBatchQueues().stream().filter(x -> x.getQueueName().equals(queueName)).findFirst();
        if (queue.isPresent() && queue.get().getQueueSpecificMacros() != null && !queue.get().getQueueSpecificMacros().equals("")) {
            return Arrays.asList(queue.get().getQueueSpecificMacros().split(","));
        }
        return null;
    }

    public static class ProcessContextBuilder {
        private final String processId;
        private final String gatewayId;
        private final String tokenId;
        private ExperimentCatalog experimentCatalog;
        private AppCatalog appCatalog;
        private CuratorFramework curatorClient;
        private Publisher statusPublisher;
        private GatewayResourceProfile gatewayResourceProfile;
        private ComputeResourcePreference gatewayComputeResourcePreference;
        private StoragePreference gatewayStorageResourcePreference;
        private ProcessModel processModel;

        public ProcessContextBuilder(String processId, String gatewayId, String tokenId) throws GFacException {
            if (this.notValid(processId) || this.notValid(gatewayId) || this.notValid(tokenId)) {
                this.throwError("Process Id, Gateway Id and tokenId must be not null");
            }
            this.processId = processId;
            this.gatewayId = gatewayId;
            this.tokenId = tokenId;
        }

        public ProcessContextBuilder setGatewayResourceProfile(GatewayResourceProfile gatewayResourceProfile) {
            this.gatewayResourceProfile = gatewayResourceProfile;
            return this;
        }

        public ProcessContextBuilder setGatewayComputeResourcePreference(ComputeResourcePreference gatewayComputeResourcePreference) {
            this.gatewayComputeResourcePreference = gatewayComputeResourcePreference;
            return this;
        }

        public ProcessContextBuilder setGatewayStorageResourcePreference(StoragePreference gatewayStorageResourcePreference) {
            this.gatewayStorageResourcePreference = gatewayStorageResourcePreference;
            return this;
        }

        public ProcessContextBuilder setProcessModel(ProcessModel processModel) {
            this.processModel = processModel;
            return this;
        }

        public ProcessContextBuilder setExperimentCatalog(ExperimentCatalog experimentCatalog) {
            this.experimentCatalog = experimentCatalog;
            return this;
        }

        public ProcessContextBuilder setAppCatalog(AppCatalog appCatalog) {
            this.appCatalog = appCatalog;
            return this;
        }

        public ProcessContextBuilder setCuratorClient(CuratorFramework curatorClient) {
            this.curatorClient = curatorClient;
            return this;
        }

        public ProcessContextBuilder setStatusPublisher(Publisher statusPublisher) {
            this.statusPublisher = statusPublisher;
            return this;
        }

        public ProcessContext build() throws GFacException {
            if (this.notValid(this.gatewayResourceProfile)) {
                this.throwError("Invalid GatewayResourceProfile");
            }
            if (this.notValid(this.gatewayComputeResourcePreference)) {
                this.throwError("Invalid Gateway ComputeResourcePreference");
            }
            if (this.notValid(this.gatewayStorageResourcePreference)) {
                this.throwError("Invalid Gateway StoragePreference");
            }
            if (this.notValid(this.processModel)) {
                this.throwError("Invalid Process Model");
            }
            if (this.notValid(this.appCatalog)) {
                this.throwError("Invalid AppCatalog");
            }
            if (this.notValid(this.experimentCatalog)) {
                this.throwError("Invalid Experiment catalog");
            }
            if (this.notValid(this.curatorClient)) {
                this.throwError("Invalid Curator Client");
            }
            if (this.notValid(this.statusPublisher)) {
                this.throwError("Invalid Status Publisher");
            }
            ProcessContext pc = new ProcessContext(this.processId, this.gatewayId, this.tokenId);
            pc.setAppCatalog(this.appCatalog);
            pc.setExperimentCatalog(this.experimentCatalog);
            pc.setCuratorClient(this.curatorClient);
            pc.setStatusPublisher(this.statusPublisher);
            pc.setProcessModel(this.processModel);
            pc.setGatewayResourceProfile(this.gatewayResourceProfile);
            pc.setGatewayComputeResourcePreference(this.gatewayComputeResourcePreference);
            pc.setGatewayStorageResourcePreference(this.gatewayStorageResourcePreference);
            return pc;
        }

        private boolean notValid(Object value) {
            return value == null;
        }

        private void throwError(String msg) throws GFacException {
            throw new GFacException(msg);
        }
    }
}

