/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.dpc;

import eu.unicore.uftp.dpc.DPCServer;
import eu.unicore.uftp.dpc.ProtocolViolationException;
import eu.unicore.uftp.server.FileAccess;
import eu.unicore.uftp.server.UFTPCommands;
import eu.unicore.uftp.server.UFTPTransferRequest;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Session {
    private long offset = 0L;
    private long bytesToSend = Long.MAX_VALUE;
    private long bytesToRead = 0L;
    volatile boolean isAlive = true;
    private final DPCServer.Connection connection;
    private final UFTPTransferRequest job;
    private final FileAccess fileAccess;
    private RandomAccessFile localRandomAccessFile;
    private File localFile;
    public static final int ACTION_END = 99;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_RETRIEVE = 1;
    public static final int ACTION_STORE = 2;
    public static final int ACTION_SYNC_MASTER = 3;
    public static final int ACTION_SYNC_SLAVE = 4;
    private File baseDirectory;
    private File currentDirectory;

    public Session(DPCServer.Connection connection, UFTPTransferRequest job, FileAccess fileAccess) {
        this.connection = connection;
        this.job = job;
        this.fileAccess = fileAccess;
        this.baseDirectory = job.getFile().getParentFile() != null ? job.getFile().getParentFile() : new File("/");
        this.currentDirectory = this.baseDirectory;
    }

    public int getNextAction() throws IOException, ProtocolViolationException {
        String cmd = this.connection.readControl();
        if (cmd == null || cmd.startsWith("BYE")) {
            this.isAlive = false;
            return 99;
        }
        if (cmd.startsWith("RANG ")) {
            this.handleRange(cmd);
        }
        if (cmd.startsWith("RETR ")) {
            this.handleRetrieve(cmd);
            return 1;
        }
        if (cmd.startsWith("STAT ")) {
            this.handleStat(cmd);
        }
        if (cmd.startsWith("CDUP")) {
            this.handleCDUP();
        }
        if (cmd.startsWith("CWD ")) {
            this.handleCWD(cmd);
        }
        if (cmd.startsWith("MKD ")) {
            this.handleMKD(cmd);
        }
        if (cmd.startsWith("DELE ") || cmd.startsWith("RMD ")) {
            this.handleRM(cmd);
        }
        if (cmd.startsWith("SIZE ")) {
            this.handleSize(cmd);
        }
        if (cmd.startsWith("PWD")) {
            this.handlePWD();
        }
        if (cmd.startsWith("ALLO ")) {
            this.handleAllocate(cmd);
        }
        if (cmd.startsWith("STOR ")) {
            this.handleStore(cmd);
            return 2;
        }
        if (cmd.startsWith("SYNC-MASTER ")) {
            this.setupSyncFile(cmd);
            return 3;
        }
        if (cmd.startsWith("SYNC-SLAVE ")) {
            this.setupSyncFile(cmd);
            return 4;
        }
        return 0;
    }

    private File getFile(String pathname) {
        File f = new File(pathname);
        if (!f.isAbsolute()) {
            f = new File(this.currentDirectory, pathname);
        }
        return f;
    }

    private void handleRetrieve(String cmd) throws IOException {
        String[] tok = cmd.trim().split(" ", 2);
        String localFileName = tok[1];
        this.localFile = this.getFile(localFileName);
        this.localRandomAccessFile = this.createRandomAccessFile(this.localFile, "r");
        long size = this.localFile.length();
        this.connection.sendControl("200 OK " + size + " bytes available for reading.");
    }

    private void handleSize(String cmd) throws IOException {
        String[] tok = cmd.trim().split(" ", 2);
        String localFileName = tok[1];
        File file = this.getFile(localFileName);
        if (!file.exists()) {
            this.connection.sendError("File does not exist");
        } else {
            long size = file.length();
            this.connection.sendControl(UFTPCommands.SIZE_REPLY + " " + size);
        }
    }

    private void handleRange(String cmd) throws IOException {
        String response;
        long lastByte;
        long offset;
        String[] tok = cmd.trim().split(" ");
        try {
            offset = Long.parseLong(tok[1]);
            lastByte = Long.parseLong(tok[2]);
        }
        catch (Exception ex) {
            this.connection.sendError("RANG argument syntax error.");
            return;
        }
        if (offset == 1L && lastByte == 0L) {
            response = "350 Resetting range";
            this.resetRange();
        } else {
            response = "350 Restarting at " + offset + ". End byte range at " + lastByte + "";
            this.setRange(offset, lastByte - offset);
        }
        this.connection.sendControl(response);
    }

    private void handleStat(String cmd) throws IOException {
        String[] tok = cmd.split(" ", 3);
        String path = tok[2];
        File file = new File(this.currentDirectory, path);
        this.connection.sendControl("211-Sending file list");
        for (File f : file.listFiles()) {
            String mode = f.isDirectory() ? "D" : "-";
            String size = String.valueOf(f.length());
            String lastModified = String.valueOf(f.lastModified());
            this.connection.sendControl(mode + " " + size + " " + lastModified + " " + f.getName());
        }
        this.connection.sendControl("211 End of file list.");
    }

    private void handleCDUP() throws IOException {
        if (!this.currentDirectory.getAbsolutePath().equals(this.baseDirectory.getAbsolutePath())) {
            this.currentDirectory = this.currentDirectory.getParentFile();
            this.connection.sendControl("200 OK");
        } else {
            this.connection.sendError("Can't cd up, already at base directory");
        }
    }

    private void handleCWD(String cmd) throws IOException {
        String dir = cmd.split(" ", 2)[1];
        File newWD = new File(this.currentDirectory, dir);
        if (!newWD.exists() || !newWD.isDirectory()) {
            this.connection.sendError("Can't cd to " + newWD.getAbsolutePath());
        } else {
            this.currentDirectory = newWD;
            this.connection.sendControl("200 OK");
        }
    }

    private void handlePWD() throws IOException {
        this.connection.sendControl("257 " + this.currentDirectory.getAbsolutePath());
    }

    private void handleMKD(String cmd) throws IOException {
        String dir = cmd.split(" ", 2)[1];
        File newDir = new File(dir);
        if (!newDir.isAbsolute()) {
            newDir = new File(this.currentDirectory, dir);
        }
        try {
            this.fileAccess.mkdir(newDir.getAbsolutePath(), this.job.getUser(), this.job.getGroup());
        }
        catch (Exception ex) {
            this.connection.sendError("Can't create directory " + newDir.getAbsolutePath());
            return;
        }
        this.connection.sendControl("200 OK");
    }

    private void handleRM(String cmd) throws IOException {
        String dir = cmd.split(" ", 2)[1];
        File newDir = new File(dir);
        if (!newDir.isAbsolute()) {
            newDir = new File(this.currentDirectory, dir);
        }
        try {
            this.fileAccess.rm(newDir.getAbsolutePath(), this.job.getUser(), this.job.getGroup());
        }
        catch (Exception ex) {
            this.connection.sendError("Can't delete " + newDir.getAbsolutePath());
            return;
        }
        this.connection.sendControl("200 OK");
    }

    private void handleAllocate(String cmd) throws IOException {
        long size;
        String[] tok = cmd.trim().split(" ", 2);
        String sizeS = tok[1];
        this.bytesToRead = size = Long.parseLong(sizeS);
        this.connection.sendControl("200 OK Will read " + this.bytesToRead + " bytes from data connection.");
    }

    private void handleStore(String cmd) throws IOException {
        String[] tok = cmd.trim().split(" ", 2);
        String localFileName = tok[1];
        this.localFile = this.getFile(localFileName);
        try {
            this.localRandomAccessFile = this.createRandomAccessFile(this.localFile, "rw");
        }
        catch (Exception ex) {
            this.connection.sendError("Can't open file for writing: " + ex.getMessage());
            return;
        }
        this.connection.sendControl("200 OK");
    }

    private void setupSyncFile(String cmd) throws IOException {
        String[] tok = cmd.trim().split(" ", 2);
        String localFileName = tok[1];
        this.localFile = this.getFile(localFileName);
        try {
            this.localRandomAccessFile = this.createRandomAccessFile(this.localFile, "r");
        }
        catch (Exception ex) {
            this.connection.sendError("Can't open file for reading: " + ex.getMessage());
            return;
        }
        this.connection.sendControl("200 OK");
    }

    private void setRange(long offset, long bytesToSend) {
        this.offset = offset;
        this.bytesToSend = bytesToSend;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getBytesToSend() {
        return this.bytesToSend;
    }

    public long getBytesToRead() {
        return this.bytesToRead;
    }

    private void resetRange() {
        this.setRange(0L, Long.MAX_VALUE);
    }

    public void reset() {
        this.resetRange();
        this.bytesToRead = 0L;
        if (this.localRandomAccessFile != null) {
            try {
                this.localRandomAccessFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public RandomAccessFile getLocalRandomAccessFile() {
        return this.localRandomAccessFile;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public RandomAccessFile createRandomAccessFile(File file, String mode) throws IOException {
        return this.fileAccess.getRandomAccessFile(file, this.job.getUser(), this.job.getGroup(), mode);
    }
}

