/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.samlclient;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.unicore.samly2.SAMLBindings;
import eu.unicore.samly2.assertion.AssertionParser;
import eu.unicore.samly2.assertion.AttributeAssertionParser;
import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.exceptions.SAMLResponderException;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.proto.AuthnRequest;
import eu.unicore.samly2.trust.PKISamlTrustChecker;
import eu.unicore.samly2.validators.SSOAuthnResponseValidator;
import eu.unicore.samly2.webservice.SAMLAuthnInterface;
import eu.unicore.security.wsutil.samlclient.AbstractSAMLClient;
import eu.unicore.security.wsutil.samlclient.AuthnResponseAssertions;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.soap.SOAPFaultException;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.protocol.AuthnRequestDocument;
import xmlbeans.org.oasis.saml2.protocol.AuthnRequestType;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;

public class SAMLAuthnClient
extends AbstractSAMLClient {
    private SAMLAuthnInterface authnProxy;

    public SAMLAuthnClient(String address, IClientConfiguration clientConfiguration) throws MalformedURLException {
        super(address, clientConfiguration, new PKISamlTrustChecker((X509CertChainValidator)clientConfiguration.getValidator(), true));
        this.authnProxy = this.factory.createPlainWSProxy(SAMLAuthnInterface.class, address);
    }

    public AuthnResponseAssertions authenticate(String requestedNameFormat, NameID requesterSamlName, String consumerURL) throws SAMLValidationException {
        return this.getAssertionsGeneric(requestedNameFormat, consumerURL, requesterSamlName);
    }

    public AuthnResponseAssertions authenticate(NameID requesterSamlName, String consumerURL) throws SAMLValidationException {
        return this.getAssertionsGeneric(null, consumerURL, requesterSamlName);
    }

    public AuthnResponseAssertions authenticate(AuthnRequestDocument request) throws SAMLValidationException {
        return this.performSAMLQuery(request);
    }

    protected AuthnResponseAssertions getAssertionsGeneric(String format, String consumerURL, NameID requesterSamlName) throws SAMLValidationException {
        if (requesterSamlName == null) {
            requesterSamlName = this.getLocalIssuer();
        }
        if (requesterSamlName == null) {
            throw new SAMLValidationException("No SAML issuer was given and it is not possible to generate one as local credential is missing.");
        }
        AuthnRequest request = new AuthnRequest(requesterSamlName.getXBean());
        if (format != null) {
            request.setFormat(format);
        }
        if (consumerURL != null) {
            ((AuthnRequestType)request.getXMLBean()).setAssertionConsumerServiceURL(consumerURL);
        }
        return this.performSAMLQuery((AuthnRequestDocument)request.getXMLBeanDoc());
    }

    protected AuthnResponseAssertions performSAMLQuery(AuthnRequestDocument request) throws SAMLValidationException {
        ResponseDocument xmlRespDoc;
        try {
            xmlRespDoc = this.authnProxy.authnRequest(request);
        }
        catch (SOAPFaultException e) {
            throw new SAMLResponderException("SAML service invocation failed: " + e.getMessage(), (Throwable)e);
        }
        SSOAuthnResponseValidator validator = new SSOAuthnResponseValidator(null, null, request.getAuthnRequest().getID(), 180000L, this.trustChecker, null, SAMLBindings.SOAP);
        validator.validate(xmlRespDoc);
        List<AssertionDocument> authnAssertionsXml = validator.getAuthNAssertions();
        ArrayList<AssertionParser> authAssertions = new ArrayList<AssertionParser>(authnAssertionsXml.size());
        for (int i = 0; i < authnAssertionsXml.size(); ++i) {
            authAssertions.add(new AssertionParser(authnAssertionsXml.get(i)));
        }
        List<AssertionDocument> otherAssertionsXml = validator.getOtherAssertions();
        ArrayList<AttributeAssertionParser> attributeAssertions = new ArrayList<AttributeAssertionParser>(otherAssertionsXml.size());
        for (int i = 0; i < otherAssertionsXml.size(); ++i) {
            AssertionDocument aD = otherAssertionsXml.get(i);
            if (aD.getAssertion().sizeOfAttributeStatementArray() <= 0) continue;
            attributeAssertions.add(new AttributeAssertionParser(otherAssertionsXml.get(i)));
            otherAssertionsXml.remove(i);
            --i;
        }
        return new AuthnResponseAssertions(authAssertions, attributeAssertions, otherAssertionsXml);
    }
}

