/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client.authn;

import com.sun.xml.txw2.IllegalSignatureException;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.helpers.BinaryCertChainValidator;
import eu.unicore.security.canl.DefaultAuthnAndTrustConfiguration;
import eu.unicore.security.canl.LoggingStoreUpdateListener;
import eu.unicore.security.canl.PasswordCallback;
import eu.unicore.security.canl.TruststoreProperties;
import eu.unicore.security.wsutil.client.authn.AuthenticationProvider;
import eu.unicore.security.wsutil.client.authn.DelegationSpecification;
import eu.unicore.util.configuration.PropertyMD;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.ETDClientSettings;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;

public abstract class PropertiesBasedAuthenticationProvider
implements AuthenticationProvider {
    protected Properties properties;
    protected PasswordCallback truststorePasswordCallback;

    public PropertiesBasedAuthenticationProvider(Properties properties, PasswordCallback truststorePasswordCallback) {
        this.properties = properties;
        this.truststorePasswordCallback = truststorePasswordCallback;
    }

    protected PropertiesBasedAuthenticationProvider() {
    }

    @Override
    public DefaultClientConfiguration getAnonymousClientConfiguration() {
        String sslEnabled = this.properties.getProperty("client.sslEnabled");
        X509CertChainValidatorExt validator = null;
        if (sslEnabled == null || "true".equalsIgnoreCase(sslEnabled)) {
            TruststoreProperties trustProperties = new TruststoreProperties(this.properties, Collections.singleton(new LoggingStoreUpdateListener()), this.truststorePasswordCallback);
            validator = trustProperties.getValidator();
        }
        DefaultAuthnAndTrustConfiguration authAndTrust = new DefaultAuthnAndTrustConfiguration(validator, null);
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.properties);
        copy.setProperty("client.sslAuthnEnabled", "false");
        copy.setProperty("client.digitalSigningEnabled", "false");
        return new ClientProperties(copy, authAndTrust);
    }

    @Override
    public DefaultClientConfiguration getBaseClientConfiguration() {
        BinaryCertChainValidator validator = new BinaryCertChainValidator(true);
        DefaultAuthnAndTrustConfiguration authAndTrust = new DefaultAuthnAndTrustConfiguration((X509CertChainValidatorExt)validator, null);
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.properties);
        copy.setProperty("client.sslAuthnEnabled", "false");
        copy.setProperty("client.digitalSigningEnabled", "false");
        return new ClientProperties(copy, authAndTrust);
    }

    protected Map<String, PropertyMD> getMeta(Class<?> props) {
        try {
            Field f = props.getDeclaredField("META");
            f.setAccessible(true);
            return (Map)f.get(null);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected String getMeta(Class<?> clazz, String prefix) {
        StringBuilder ret = new StringBuilder();
        String nl = System.getProperty("line.separator");
        for (Map.Entry<String, PropertyMD> entry : this.getMeta(clazz).entrySet()) {
            PropertyMD prop = entry.getValue();
            if (prop.isHidden()) continue;
            ret.append(prefix).append(entry.getKey()).append(" : ").append(prop.getDescription());
            ret.append(nl);
        }
        return ret.toString();
    }

    protected void applyLocalDelegation(DefaultClientConfiguration sp, String targetDn, DelegationSpecification delegate) {
        if (delegate.isDelegate()) {
            if (targetDn == null) {
                throw new IllegalSignatureException("When delegation is used the target service DN must be given.");
            }
            ETDClientSettings etdSettings = sp.getETDSettings();
            etdSettings.setExtendTrustDelegation(true);
            etdSettings.setReceiver(new X500Principal(targetDn));
            etdSettings.setDelegationRestrictions(delegate.getRestrictions());
        }
    }
}

