/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil;

import eu.unicore.util.Log;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecHeader {
    private static final Logger log = Log.getLogger("unicore.security", WSSecHeader.class);
    public static final String SOAP11_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String WSSE_NS_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String WSSE_LN = "Security";
    public static final String WSSE_PREFIX = "wsse";
    public static final String ATTR_ACTOR = "actor";
    public static final String ATTR_UNDERSTAND = "mustUnderstand";
    private final String actor;
    private final boolean mustUnderstand;
    private static final QName wsse = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");

    public WSSecHeader(boolean mustUnderstand) {
        this.actor = null;
        this.mustUnderstand = mustUnderstand;
    }

    public WSSecHeader(String actor, boolean mustUnderstand) {
        this.actor = actor;
        this.mustUnderstand = mustUnderstand;
    }

    public Element getOrInsertWSSecElement(List<Header> headers) {
        Element ret = this.findWSSecElement(headers);
        if (ret != null) {
            log.debug("Found existing WSSec header element");
            return ret;
        }
        ret = this.createWSSecElement(headers);
        return ret;
    }

    private Element createWSSecElement(List<Header> headers) {
        Document doc = DOMUtils.createDocument();
        Element newWsSec = doc.createElementNS(WSSE_NS_URI, "wsse:Security");
        newWsSec.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", WSSE_NS_URI);
        SoapHeader sh = new SoapHeader(new QName(WSSE_NS_URI, WSSE_LN), (Object)newWsSec);
        sh.setMustUnderstand(this.mustUnderstand);
        headers.add(0, (Header)sh);
        return newWsSec;
    }

    public Element findWSSecElement(List<Header> headers) {
        for (Header h : headers) {
            if (!h.getName().equals(wsse)) continue;
            Element e = (Element)h.getObject();
            boolean isActorSet = e.hasAttributeNS(SOAP11_URI, ATTR_ACTOR);
            if (!isActorSet && this.actor == null) {
                return e;
            }
            String a = e.getAttributeNS(SOAP11_URI, ATTR_ACTOR);
            if (this.actor == null || !this.actor.equals(a)) continue;
            return e;
        }
        return null;
    }
}

