/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.client;

import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import de.fzj.unicore.wsrflite.xmlbeans.client.MultiWSRFClient;
import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.client.Resources;
import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.oasisOpen.docs.wsrf.sg2.AddDocument;
import org.oasisOpen.docs.wsrf.sg2.AddResponseDocument;
import org.oasisOpen.docs.wsrf.sg2.EntryType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class ExternalRegistryClient
extends MultiWSRFClient<RegistryClient>
implements IRegistryQuery {
    protected static final long readd_offset = 60000L;
    private boolean filterDuplicates = true;
    private String connectionStatus = null;

    public Calendar addRegistryEntry(AddDocument in) {
        long current = System.currentTimeMillis();
        Calendar responseTT = Calendar.getInstance();
        responseTT.add(13, 300);
        long selected = responseTT.getTimeInMillis();
        boolean haveExternalTT = false;
        for (RegistryClient reg : this.clients) {
            try {
                long tt;
                if (logger.isDebugEnabled()) {
                    logger.debug("Calling external registry: " + reg.getEPR().getAddress().getStringValue());
                }
                Calendar c = reg.getCurrentTime();
                long timeDifference = current - c.getTimeInMillis();
                AddResponseDocument res = reg.addRegistryEntry(in);
                Calendar extTT = res.getAddResponse().getTerminationTime();
                if (logger.isDebugEnabled()) {
                    logger.debug("External registry requests lifetime: " + extTT.getTime());
                }
                if ((tt = extTT.getTimeInMillis() + timeDifference - 60000L) >= selected && haveExternalTT) continue;
                selected = tt;
                haveExternalTT = true;
            }
            catch (Exception e) {
                Log.logException("Can't talk to registry " + reg.getEPR().getAddress().getStringValue(), e, logger);
            }
        }
        responseTT.setTimeInMillis(selected);
        return responseTT;
    }

    @Override
    public List<EndpointReferenceType> listAccessibleServices(QName porttype) throws Exception {
        ArrayList<EndpointReferenceType> result = new ArrayList<EndpointReferenceType>();
        for (RegistryClient c : this.clients) {
            if (!c.checkConnection()) continue;
            List<EndpointReferenceType> res = c.listAccessibleServices(porttype);
            if (this.filterDuplicates) {
                this.addIfNotExist(result, res);
                continue;
            }
            result.addAll(res);
        }
        return result;
    }

    @Override
    public List<EntryType> listEntries() {
        ArrayList<EntryType> result = new ArrayList<EntryType>();
        for (RegistryClient c : this.clients) {
            try {
                result.addAll(c.listEntries());
            }
            catch (Exception ex) {
                Log.logException("Registry at " + c.getEPR().getAddress().getStringValue() + " is not available.", ex, logger);
            }
        }
        return result;
    }

    @Override
    public List<EndpointReferenceType> listServices(QName porttype, IRegistryQuery.ServiceListFilter acceptFilter) throws Exception {
        ArrayList<EndpointReferenceType> result = new ArrayList<EndpointReferenceType>();
        for (RegistryClient c : this.clients) {
            if (!c.checkConnection()) continue;
            List<EndpointReferenceType> res = c.listServices(porttype, acceptFilter);
            if (this.filterDuplicates) {
                this.addIfNotExist(result, res);
                continue;
            }
            result.addAll(res);
        }
        return result;
    }

    @Override
    public List<EndpointReferenceType> listServices(QName porttype) throws Exception {
        ArrayList<EndpointReferenceType> result = new ArrayList<EndpointReferenceType>();
        for (RegistryClient c : this.clients) {
            if (!c.checkConnection()) continue;
            List<EndpointReferenceType> res = c.listServices(porttype);
            if (this.filterDuplicates) {
                this.addIfNotExist(result, res);
                continue;
            }
            result.addAll(res);
        }
        return result;
    }

    @Override
    public boolean checkConnection() {
        return this.checkConnection(2000);
    }

    @Override
    public boolean checkConnection(int timeout) {
        StringBuffer status = new StringBuffer();
        boolean result = false;
        for (final RegistryClient c : this.clients) {
            boolean currentOK;
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    c.getCurrentTime();
                    return Boolean.TRUE;
                }
            };
            Boolean res = this.compute(task, timeout);
            boolean bl = currentOK = res != null ? res : false;
            if (!currentOK) {
                status.append("[NOT AVAILABLE: ").append(c.getEPR().getAddress().getStringValue());
                status.append("] ");
            }
            result = result || currentOK;
        }
        this.connectionStatus = result ? "OK" : status.toString();
        return result;
    }

    @Override
    public String getConnectionStatus() {
        this.checkConnection();
        return this.connectionStatus;
    }

    private void addIfNotExist(List<EndpointReferenceType> target, List<EndpointReferenceType> source) {
        HashSet<String> addresses = new HashSet<String>();
        for (EndpointReferenceType epr : target) {
            addresses.add(epr.getAddress().getStringValue());
        }
        for (EndpointReferenceType e : source) {
            String address = e.getAddress().getStringValue();
            if (addresses.contains(address)) continue;
            addresses.add(address);
            target.add(e);
        }
    }

    public boolean isFilterDuplicates() {
        return this.filterDuplicates;
    }

    public void setFilterDuplicates(boolean filterDuplicates) {
        this.filterDuplicates = filterDuplicates;
    }

    private Boolean compute(Callable<Boolean> task, int timeout) {
        try {
            Future<Boolean> f = Resources.getExecutorService().submit(task);
            return f.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            return Boolean.FALSE;
        }
    }
}

