/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.init;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.core.init.CarbonServerManager;

public class PreAxis2RequiredServiceListener
implements ServiceListener {
    private static Log log = LogFactory.getLog(PreAxis2RequiredServiceListener.class);
    private Map<String, Bundle> requiredOSGiServiceMap = new HashMap<String, Bundle>();
    private BundleContext bundleContext;
    private CarbonServerManager carbonServerManager;
    private String orFilter;
    private boolean listenerRegistered;

    public PreAxis2RequiredServiceListener(BundleContext bundleContext, CarbonServerManager carbonServerManager) {
        this.bundleContext = bundleContext;
        this.carbonServerManager = carbonServerManager;
    }

    boolean registerServiceListener() {
        if (this.requiredOSGiServiceMap.isEmpty()) {
            this.listenerRegistered = false;
        } else {
            try {
                this.setORFilter();
                this.bundleContext.addServiceListener((ServiceListener)this, this.orFilter);
                this.listenerRegistered = true;
            }
            catch (InvalidSyntaxException e) {
                log.error((Object)e.getCause(), (Throwable)e);
            }
        }
        return this.listenerRegistered;
    }

    void unregisterServiceListener() {
        if (this.listenerRegistered) {
            this.bundleContext.removeServiceListener((ServiceListener)this);
        }
    }

    synchronized void start() {
        try {
            ServiceReference[] references = this.bundleContext.getServiceReferences((String)null, this.orFilter);
            if (references != null && references.length > 0) {
                for (ServiceReference reference : references) {
                    String serviceClazz = ((String[])reference.getProperty("objectClass"))[0];
                    if (!this.requiredOSGiServiceMap.containsKey(serviceClazz)) continue;
                    this.requiredOSGiServiceMap.remove(serviceClazz);
                }
            }
            for (String service : this.requiredOSGiServiceMap.keySet()) {
                this.carbonServerManager.addPendingItem(service, "OSGi Service");
            }
        }
        catch (InvalidSyntaxException e) {
            log.error((Object)e.getCause(), (Throwable)e);
        }
    }

    void addRequiredServiceBundle(Bundle bundle, String servicesList) {
        String[] services;
        for (String service : services = servicesList.split(",")) {
            this.requiredOSGiServiceMap.put(service, bundle);
        }
    }

    public synchronized void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            String serviceClazz = ((String[])event.getServiceReference().getProperty("objectClass"))[0];
            this.carbonServerManager.removePendingItem(serviceClazz);
        }
    }

    private void setORFilter() {
        this.orFilter = "(|";
        for (String service : this.requiredOSGiServiceMap.keySet()) {
            this.orFilter = this.orFilter + "(objectClass=" + service + ")";
        }
        this.orFilter = this.orFilter + ")";
    }
}

