/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.storage.impl;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.delegation.storage.TransactionStore;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import edu.uiuc.ncsa.security.storage.MemoryStore;
import java.util.HashMap;

public class TransactionMemoryStore<V extends BasicTransaction>
extends MemoryStore<V>
implements TransactionStore<V> {
    TokenIndex agIndex;
    TokenIndex atIndex;
    TokenIndex vIndex;

    public TransactionMemoryStore(IdentifiableProvider<V> vIdentifiableProvider) {
        super(vIdentifiableProvider);
    }

    public TokenIndex getAgIndex() {
        if (this.agIndex == null) {
            this.agIndex = new TokenIndex();
        }
        return this.agIndex;
    }

    public TokenIndex getAtIndex() {
        if (this.atIndex == null) {
            this.atIndex = new TokenIndex();
        }
        return this.atIndex;
    }

    public TokenIndex getvIndex() {
        if (this.vIndex == null) {
            this.vIndex = new TokenIndex();
        }
        return this.vIndex;
    }

    @Override
    public V get(AuthorizationGrant authorizationGrant) {
        return (V)((Object)((BasicTransaction)((Object)this.getAgIndex().get(authorizationGrant.getToken()))));
    }

    @Override
    public V get(AccessToken accessToken) {
        return (V)((Object)((BasicTransaction)((Object)this.getAtIndex().get(accessToken.getToken()))));
    }

    @Override
    public V get(Verifier verifier) {
        return (V)((Object)((BasicTransaction)((Object)this.getvIndex().get(verifier.getToken()))));
    }

    protected void updateIndices(V v) {
        if (((BasicTransaction)((Object)v)).getAccessToken() != null) {
            this.getAtIndex().put(((BasicTransaction)((Object)v)).getAccessToken().getToken(), v);
        }
        if (((BasicTransaction)((Object)v)).getAuthorizationGrant() != null) {
            this.getAgIndex().put(((BasicTransaction)((Object)v)).getAuthorizationGrant().getToken(), v);
        }
        if (((BasicTransaction)((Object)v)).getVerifier() != null) {
            this.getvIndex().put(((BasicTransaction)((Object)v)).getVerifier().getToken(), v);
        }
    }

    public void register(V value) {
        super.register(value);
        this.updateIndices(value);
    }

    public void save(V value) {
        super.save(value);
        this.updateIndices(value);
    }

    public void update(V value) {
        super.update(value);
        this.updateIndices(value);
    }

    public void clear() {
        super.clear();
        this.clearIndices();
    }

    protected void clearIndices() {
        this.agIndex = null;
        this.atIndex = null;
        this.vIndex = null;
    }

    protected void removeItem(V value) {
        this.getAgIndex().remove(((BasicTransaction)((Object)value)).getAuthorizationGrant());
        this.getAtIndex().remove(((BasicTransaction)((Object)value)).getAccessToken());
        this.getvIndex().remove(((BasicTransaction)((Object)value)).getVerifier());
    }

    public V remove(Object key) {
        BasicTransaction item = (BasicTransaction)((Object)super.remove(key));
        if (item != null) {
            this.removeItem(item);
        }
        return (V)((Object)item);
    }

    protected class TokenIndex
    extends HashMap<String, V> {
    }
}

