/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.airavata.cloud.aurora.client.AuroraThriftClient;
import org.apache.airavata.cloud.aurora.client.bean.IdentityBean;
import org.apache.airavata.cloud.aurora.client.bean.JobConfigBean;
import org.apache.airavata.cloud.aurora.client.bean.JobKeyBean;
import org.apache.airavata.cloud.aurora.client.bean.ProcessBean;
import org.apache.airavata.cloud.aurora.client.bean.ResourceBean;
import org.apache.airavata.cloud.aurora.client.bean.ResponseBean;
import org.apache.airavata.cloud.aurora.client.bean.TaskConfigBean;
import org.apache.airavata.cloud.aurora.util.AuroraThriftClientUtil;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.core.GroovyMap;
import org.apache.airavata.gfac.core.Script;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.core.context.TaskContext;
import org.apache.airavata.gfac.core.task.JobSubmissionTask;
import org.apache.airavata.gfac.core.task.TaskException;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManagerType;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.TaskTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuroraJobSubmissionTask
implements JobSubmissionTask {
    private static final Logger log = LoggerFactory.getLogger(AuroraJobSubmissionTask.class);

    public JobStatus cancel(TaskContext taskcontext) throws TaskException {
        JobStatus jobStatus = new JobStatus();
        jobStatus.setJobState(JobState.ACTIVE);
        return jobStatus;
    }

    public void init(Map<String, String> propertyMap) throws TaskException {
    }

    public TaskStatus execute(TaskContext taskContext) {
        TaskStatus taskStatus = new TaskStatus(TaskState.COMPLETED);
        ProcessContext processContext = taskContext.getParentProcessContext();
        JobModel jobModel = processContext.getJobModel();
        jobModel.setTaskId(taskContext.getTaskId());
        String jobIdAndName = "A" + GFacUtils.generateJobName();
        jobModel.setJobName(jobIdAndName);
        JobStatus jobStatus = new JobStatus();
        jobStatus.setJobState(JobState.SUBMITTED);
        try {
            JobKeyBean jobKey = new JobKeyBean("devel", "centos", jobIdAndName);
            IdentityBean owner = new IdentityBean("centos");
            GroovyMap groovyMap = GFacUtils.createGroovyMap((ProcessContext)processContext, (TaskContext)taskContext);
            groovyMap.add(Script.JOB_SUBMITTER_COMMAND, (Object)"sh");
            String templateFileName = GFacUtils.getTemplateFileName((ResourceJobManagerType)ResourceJobManagerType.CLOUD);
            String script = GFacUtils.generateScript((GroovyMap)groovyMap, (String)templateFileName);
            LinkedHashSet<ProcessBean> processes = new LinkedHashSet<ProcessBean>();
            ProcessBean process_1 = new ProcessBean("main_process", script, false);
            processes.add(process_1);
            groovyMap.getStringValue(Script.STANDARD_OUT_FILE).ifPresent(stdout -> {
                ProcessBean stdOutProcess = new ProcessBean("stdout_copy_process", "cp .logs/main_process/0/stdout " + stdout, false);
                processes.add(stdOutProcess);
            });
            groovyMap.getStringValue(Script.STANDARD_ERROR_FILE).ifPresent(stderr -> {
                ProcessBean stdErrProcess = new ProcessBean("stderr_copy_process", "cp .logs/main_process/0/stderr " + stderr, false);
                processes.add(stdErrProcess);
            });
            ResourceBean resources = new ResourceBean(1.5, 512L, 512L);
            TaskConfigBean taskConfig = new TaskConfigBean("Airavata-Aurora-" + jobIdAndName, processes, resources);
            JobConfigBean jobConfig = new JobConfigBean(jobKey, owner, taskConfig, "example");
            String executorConfigJson = AuroraThriftClientUtil.getExecutorConfigJson((JobConfigBean)jobConfig);
            log.info("Executor Config for Job {} , {}", (Object)jobIdAndName, (Object)executorConfigJson);
            AuroraThriftClient client = AuroraThriftClient.getAuroraThriftClient();
            ResponseBean response = client.createJob(jobConfig);
            log.info("Response for job {}, {}", (Object)jobIdAndName, (Object)response);
            jobModel.setJobDescription(resources.toString());
            jobModel.setJobId(jobIdAndName);
            jobStatus.setReason("Successfully Submitted");
            jobModel.setJobStatuses(Arrays.asList(jobStatus));
            jobStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            taskContext.getParentProcessContext().setJobModel(jobModel);
            GFacUtils.saveJobModel((ProcessContext)processContext, (JobModel)jobModel);
            GFacUtils.saveJobStatus((ProcessContext)processContext, (JobModel)jobModel);
            taskStatus.setReason("Successfully submitted job to Aurora");
        }
        catch (Throwable e) {
            String msg = "Error occurred while submitting Aurora job";
            log.error(msg, e);
            taskStatus.setState(TaskState.FAILED);
            taskStatus.setReason(msg);
            taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            ErrorModel errorModel = new ErrorModel();
            errorModel.setActualErrorMessage(e.getMessage());
            errorModel.setUserFriendlyMessage(msg);
            taskContext.getTaskModel().setTaskErrors(Arrays.asList(errorModel));
        }
        taskContext.setTaskStatus(taskStatus);
        try {
            GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
        }
        catch (GFacException e) {
            log.error("Error while saving task status", (Throwable)e);
        }
        return taskStatus;
    }

    public TaskStatus recover(TaskContext taskContext) {
        return this.execute(taskContext);
    }

    public TaskTypes getType() {
        return TaskTypes.JOB_SUBMISSION;
    }
}

