/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.job;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.cluster.OutputParser;
import org.apache.airavata.gfac.impl.job.JobUtil;
import org.apache.airavata.model.status.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PBSOutputParser
implements OutputParser {
    private static final Logger log = LoggerFactory.getLogger(PBSOutputParser.class);

    public String parseJobSubmission(String rawOutput) {
        String[] split;
        log.debug(rawOutput);
        String jobId = rawOutput;
        if (!rawOutput.isEmpty() && rawOutput.contains("\n") && (split = rawOutput.split("\n")).length != 0) {
            jobId = split[0];
        }
        return jobId;
    }

    public boolean isJobSubmissionFailed(String rawOutput) {
        return false;
    }

    public JobStatus parseJobStatus(String jobID, String rawOutput) {
        boolean jobFount = false;
        log.debug(rawOutput);
        String[] info = rawOutput.split("\n");
        String[] line = null;
        int index = 0;
        for (String anInfo : info) {
            ++index;
            if (!anInfo.contains("Job Id:") || !anInfo.contains(jobID)) continue;
            jobFount = true;
            break;
        }
        if (jobFount) {
            for (int i = index; i < info.length; ++i) {
                String anInfo = info[i];
                if (!anInfo.contains("=") || (line = anInfo.split("=", 2)).length == 0 || !line[0].contains("job_state")) continue;
                return new JobStatus(JobUtil.getJobState(line[1].replaceAll(" ", "")));
            }
        }
        return null;
    }

    public void parseJobStatuses(String userName, Map<String, JobStatus> statusMap, String rawOutput) {
        log.debug(rawOutput);
        String[] info = rawOutput.split("\n");
        for (String jobID : statusMap.keySet()) {
            String jobName = jobID.split(",")[1];
            boolean found = false;
            for (int i = 0; i < info.length; ++i) {
                if (!info[i].contains(jobName.substring(0, 8))) continue;
                log.info(info[i]);
                String correctLine = info[i];
                String[] columns = correctLine.split(" ");
                ArrayList<String> columnList = new ArrayList<String>();
                for (String s : columns) {
                    if ("".equals(s)) continue;
                    columnList.add(s);
                }
                try {
                    statusMap.put(jobID, new JobStatus(JobUtil.getJobState((String)columnList.get(9))));
                }
                catch (IndexOutOfBoundsException e) {
                    statusMap.put(jobID, new JobStatus(JobUtil.getJobState("U")));
                }
                found = true;
                break;
            }
            if (found) continue;
            log.error("Couldn't find the status of the Job with JobName: " + jobName + "Job Id: " + jobID.split(",")[0]);
        }
    }

    public String parseJobId(String jobName, String rawOutput) throws GFacException {
        String regJobId = "jobId";
        Pattern pattern = Pattern.compile("(?<" + regJobId + ">[^\\s]*)\\s*.* " + jobName);
        if (rawOutput != null) {
            Matcher matcher = pattern.matcher(rawOutput);
            if (matcher.find()) {
                return matcher.group(regJobId);
            }
            log.error("No match is found for JobName");
            return null;
        }
        log.error("Error: RawOutput shouldn't be null");
        return null;
    }
}

