/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.sharing.registry.db.repositories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.sharing.registry.db.entities.EntityEntity;
import org.apache.airavata.sharing.registry.db.entities.EntityPK;
import org.apache.airavata.sharing.registry.db.repositories.AbstractRepository;
import org.apache.airavata.sharing.registry.db.repositories.PermissionTypeRepository;
import org.apache.airavata.sharing.registry.db.utils.DBConstants;
import org.apache.airavata.sharing.registry.models.Entity;
import org.apache.airavata.sharing.registry.models.EntitySearchField;
import org.apache.airavata.sharing.registry.models.SearchCondition;
import org.apache.airavata.sharing.registry.models.SearchCriteria;
import org.apache.airavata.sharing.registry.models.SharingRegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRepository
extends AbstractRepository<Entity, EntityEntity, EntityPK> {
    private static final Logger logger = LoggerFactory.getLogger(EntityRepository.class);

    public EntityRepository() {
        super(Entity.class, EntityEntity.class);
    }

    public List<Entity> getChildEntities(String domainId, String parentId) throws SharingRegistryException {
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("domainId", domainId);
        filters.put("parentEntityId", parentId);
        return this.select(filters, 0, -1);
    }

    public List<Entity> searchEntities(String domainId, List<String> groupIds, List<SearchCriteria> filters, int offset, int limit) throws SharingRegistryException {
        String groupIdString = "'";
        for (String string : groupIds) {
            groupIdString = groupIdString + string + "','";
        }
        groupIdString = groupIdString.substring(0, groupIdString.length() - 2);
        String query = "SELECT ENTITY.* FROM ENTITY WHERE ENTITY.ENTITY_ID IN (SELECT DISTINCT E.ENTITY_ID FROM ENTITY AS E INNER JOIN SHARING AS S ON (E.ENTITY_ID=S.ENTITY_ID AND E.DOMAIN_ID=S.DOMAIN_ID) WHERE E.DOMAIN_ID = '" + domainId + "' AND S.GROUP_ID IN(" + groupIdString + ") AND ";
        for (SearchCriteria searchCriteria : filters) {
            if (searchCriteria.getSearchField().equals((Object)EntitySearchField.NAME)) {
                if (searchCriteria.getSearchCondition() != null && searchCriteria.getSearchCondition().equals((Object)SearchCondition.NOT)) {
                    query = query + "E.NAME != '" + searchCriteria.getValue() + "' AND ";
                    continue;
                }
                query = query + "E.NAME LIKE '%" + searchCriteria.getValue() + "%' AND ";
                continue;
            }
            if (searchCriteria.getSearchField().equals((Object)EntitySearchField.DESCRIPTION)) {
                query = query + "E.DESCRIPTION LIKE '%" + searchCriteria.getValue() + "%' AND ";
                continue;
            }
            if (searchCriteria.getSearchField().equals((Object)EntitySearchField.PERMISSION_TYPE_ID)) {
                if (searchCriteria.getSearchCondition() != null && searchCriteria.getSearchCondition().equals((Object)SearchCondition.NOT)) {
                    query = query + "S.PERMISSION_TYPE_ID != '" + searchCriteria.getValue() + "' AND ";
                    continue;
                }
                query = query + "S.PERMISSION_TYPE_ID IN ('" + searchCriteria.getValue() + "', '" + new PermissionTypeRepository().getOwnerPermissionTypeIdForDomain(domainId) + "') AND ";
                continue;
            }
            if (searchCriteria.getSearchField().equals((Object)EntitySearchField.FULL_TEXT)) {
                try {
                    if (ServerSettings.getSetting((String)"sharingcatalog.jdbc.driver").contains("derby")) {
                        query = query + "E.FULL_TEXT LIKE '%" + searchCriteria.getValue() + "%' AND ";
                        continue;
                    }
                    String queryTerms = "";
                    for (String word : searchCriteria.getValue().trim().replaceAll(" +", " ").split(" ")) {
                        queryTerms = queryTerms + queryTerms + " +" + word;
                    }
                    queryTerms = queryTerms.trim();
                    query = query + "MATCH(E.FULL_TEXT) AGAINST ('" + queryTerms + "' IN BOOLEAN MODE) AND ";
                    continue;
                }
                catch (ApplicationSettingsException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new SharingRegistryException(e.getMessage());
                }
            }
            if (searchCriteria.getSearchField().equals((Object)EntitySearchField.PARRENT_ENTITY_ID)) {
                if (searchCriteria.getSearchCondition() != null && searchCriteria.getSearchCondition().equals((Object)SearchCondition.NOT)) {
                    query = query + "E.PARENT_ENTITY_ID != '" + searchCriteria.getValue() + "' AND ";
                    continue;
                }
                query = query + "E.PARENT_ENTITY_ID = '" + searchCriteria.getValue() + "' AND ";
                continue;
            }
            if (searchCriteria.getSearchField().equals((Object)EntitySearchField.OWNER_ID)) {
                if (searchCriteria.getSearchCondition() != null && searchCriteria.getSearchCondition().equals((Object)SearchCondition.NOT)) {
                    query = query + "E.OWNER_ID != '" + searchCriteria.getValue() + "' AND ";
                    continue;
                }
                query = query + "E.OWNER_ID = '" + searchCriteria.getValue() + "' AND ";
                continue;
            }
            if (searchCriteria.getSearchField().equals((Object)EntitySearchField.ENTITY_TYPE_ID)) {
                if (searchCriteria.getSearchCondition() != null && searchCriteria.getSearchCondition().equals((Object)SearchCondition.NOT)) {
                    query = query + "E.ENTITY_TYPE_ID != '" + searchCriteria.getValue() + "' AND ";
                    continue;
                }
                query = query + "E.ENTITY_TYPE_ID = '" + searchCriteria.getValue() + "' AND ";
                continue;
            }
            if (searchCriteria.getSearchField().equals((Object)EntitySearchField.CREATED_TIME)) {
                if (searchCriteria.getSearchCondition().equals((Object)SearchCondition.GTE)) {
                    query = query + "E.CREATED_TIME >= " + Integer.parseInt(searchCriteria.getValue().trim()) + " AND ";
                    continue;
                }
                query = query + "E.CREATED_TIME <= " + Integer.parseInt(searchCriteria.getValue().trim()) + " AND ";
                continue;
            }
            if (searchCriteria.getSearchField().equals((Object)EntitySearchField.UPDATED_TIME)) {
                if (searchCriteria.getSearchCondition().equals((Object)SearchCondition.GTE)) {
                    query = query + "E.UPDATED_TIME >= " + Integer.parseInt(searchCriteria.getValue().trim()) + " AND ";
                    continue;
                }
                query = query + "E.UPDATED_TIME <= " + Integer.parseInt(searchCriteria.getValue().trim()) + " AND ";
                continue;
            }
            if (!searchCriteria.getSearchField().equals((Object)EntitySearchField.SHARED_COUNT)) continue;
            if (searchCriteria.getSearchCondition().equals((Object)SearchCondition.GTE)) {
                query = query + "E.SHARED_COUNT >= " + Integer.parseInt(searchCriteria.getValue().trim()) + " AND ";
                continue;
            }
            query = query + "E.SHARED_COUNT <= " + Integer.parseInt(searchCriteria.getValue().trim()) + " AND ";
        }
        query = query.substring(0, query.length() - 5);
        String string = query = query + ") ORDER BY ENTITY.CREATED_TIME DESC";
        int newLimit = limit < 0 ? DBConstants.SELECT_MAX_ROWS : limit;
        List temp = this.execute(entityManager -> entityManager.createNativeQuery(nativeQuery).setFirstResult(offset).setMaxResults(newLimit).getResultList());
        ArrayList<Entity> resultSet = new ArrayList<Entity>();
        HashMap keys = new HashMap();
        temp.stream().forEach(rs -> {
            Entity entity = new Entity();
            entity.setEntityId((String)rs[0]);
            entity.setDomainId((String)rs[1]);
            entity.setEntityTypeId((String)rs[2]);
            entity.setOwnerId((String)rs[3]);
            entity.setParentEntityId((String)rs[4]);
            entity.setName((String)rs[5]);
            entity.setDescription((String)rs[6]);
            entity.setBinaryData((byte[])rs[7]);
            entity.setFullText((String)rs[8]);
            entity.setSharedCount(((Long)rs[9]).longValue());
            entity.setOriginalEntityCreationTime(((Long)rs[10]).longValue());
            entity.setCreatedTime(((Long)rs[11]).longValue());
            entity.setUpdatedTime(((Long)rs[12]).longValue());
            if (!keys.containsKey(entity + domainId + "," + entity.entityId)) {
                resultSet.add(entity);
                keys.put(entity + domainId + "," + entity.entityId, null);
            }
        });
        return resultSet;
    }

    public String getSelectQuery(Map<String, String> filters) {
        String query = "SELECT p from " + EntityEntity.class.getSimpleName() + " as p";
        if (filters != null && filters.size() != 0) {
            query = query + " WHERE ";
            for (String k : filters.keySet()) {
                query = query + "p." + k + " = '" + filters.get(k) + "' AND ";
            }
            query = query.substring(0, query.length() - 5);
        }
        query = query + " ORDER BY p.originalEntityCreationTime DESC";
        return query;
    }
}

