/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.query;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;

public class LuceneSearchEngineBooleanQueryBuilder
implements SearchEngineQueryBuilder.SearchEngineBooleanQueryBuilder {
    private LuceneSearchEngine searchEngine;
    private BooleanQuery boolQuery;

    public LuceneSearchEngineBooleanQueryBuilder(LuceneSearchEngine searchEngine, boolean disableCoord) {
        this.searchEngine = searchEngine;
        this.boolQuery = new BooleanQuery(disableCoord);
    }

    public SearchEngineQueryBuilder.SearchEngineBooleanQueryBuilder addMust(SearchEngineQuery query) {
        this.boolQuery.add(((LuceneSearchEngineQuery)query).getQuery(), BooleanClause.Occur.MUST);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineBooleanQueryBuilder addMustNot(SearchEngineQuery query) {
        this.boolQuery.add(((LuceneSearchEngineQuery)query).getQuery(), BooleanClause.Occur.MUST_NOT);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineBooleanQueryBuilder addShould(SearchEngineQuery query) {
        this.boolQuery.add(((LuceneSearchEngineQuery)query).getQuery(), BooleanClause.Occur.SHOULD);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineBooleanQueryBuilder setMinimumNumberShouldMatch(int min) {
        this.boolQuery.setMinimumNumberShouldMatch(min);
        return this;
    }

    public SearchEngineQuery toQuery() {
        return new LuceneSearchEngineQuery(this.searchEngine, this.boolQuery);
    }
}

