/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.builder;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.builder.AbstractInputStreamConfigurationBuilder;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractXmlConfigurationBuilder
extends AbstractInputStreamConfigurationBuilder {
    protected void doConfigure(InputStream is, String resourceName, CompassConfiguration config) throws ConfigurationException {
        InputSource inputSource = new InputSource(is);
        try {
            DocumentBuilderFactory factory = this.createDocumentBuilderFactory();
            DocumentBuilder builder = this.createDocumentBuilder(factory);
            Document doc = builder.parse(inputSource);
            this.doProcess(doc, config);
        }
        catch (ParserConfigurationException ex) {
            throw new ConfigurationException("Parser configuration exception parsing XML from [" + resourceName + "]", ex);
        }
        catch (SAXParseException ex) {
            throw new ConfigurationException("Line [" + ex.getLineNumber() + "] in XML document from [" + resourceName + "] is invalid", ex);
        }
        catch (SAXException ex) {
            throw new ConfigurationException("XML document from [" + resourceName + "] is invalid", ex);
        }
        catch (IOException ex) {
            throw new ConfigurationException("IOException parsing XML document from [" + resourceName + "]", ex);
        }
    }

    protected abstract void doProcess(Document var1, CompassConfiguration var2) throws ConfigurationException;

    protected DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        return factory;
    }

    protected DocumentBuilder createDocumentBuilder(DocumentBuilderFactory factory) throws ParserConfigurationException {
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        docBuilder.setErrorHandler(this.doGetErrorHandler());
        docBuilder.setEntityResolver(this.doGetEntityResolver());
        return docBuilder;
    }

    protected ErrorHandler doGetErrorHandler() {
        return new SimpleSaxErrorHandler(this.log);
    }

    protected abstract EntityResolver doGetEntityResolver();

    private class SimpleSaxErrorHandler
    implements ErrorHandler {
        private final Log log;

        public SimpleSaxErrorHandler(Log log) {
            this.log = log;
        }

        public void warning(SAXParseException ex) throws SAXException {
            this.log.warn((Object)("Ignored XML validation warning [" + ex.getMessage() + "]"), (Throwable)ex);
        }

        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }
    }
}

