/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.dialect;

import java.util.Map;
import org.apache.lucene.store.jdbc.JdbcDirectorySettings;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.dialect.OracleDialect;
import org.apache.lucene.store.jdbc.index.FileJdbcIndexOutput;
import org.apache.lucene.store.jdbc.index.RAMAndFileJdbcIndexOutput;
import org.apache.lucene.store.jdbc.index.RAMJdbcIndexOutput;
import org.apache.lucene.store.jdbc.index.oracle.OracleFileJdbcIndexOutput;
import org.apache.lucene.store.jdbc.index.oracle.OracleRAMAndFileJdbcIndexOutput;
import org.apache.lucene.store.jdbc.index.oracle.OracleRAMJdbcIndexOutput;

public class Oracle9Dialect
extends OracleDialect {
    public void processSettings(JdbcDirectorySettings settings) {
        Map filesEntrySettings = settings.getFileEntrySettings();
        for (JdbcFileEntrySettings fileEntrySettings : filesEntrySettings.values()) {
            try {
                Class indexOutputClass = fileEntrySettings.getSettingAsClass("indexOutput.type", RAMAndFileJdbcIndexOutput.class);
                if (indexOutputClass.equals(RAMAndFileJdbcIndexOutput.class)) {
                    indexOutputClass = OracleRAMAndFileJdbcIndexOutput.class;
                } else if (indexOutputClass.equals(RAMJdbcIndexOutput.class)) {
                    indexOutputClass = OracleRAMJdbcIndexOutput.class;
                } else if (indexOutputClass.equals(FileJdbcIndexOutput.class)) {
                    indexOutputClass = OracleFileJdbcIndexOutput.class;
                }
                fileEntrySettings.setClassSetting("indexOutput.type", indexOutputClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to find class", e);
            }
        }
    }
}

