/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.Notification;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.Utils;
import org.apache.airavata.registry.core.experiment.catalog.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(NotificationResource.class);
    private String notificationId;
    private String gatewayId;
    private String title;
    private String notificationMessage;
    private String priority;
    private Timestamp creationTime;
    private Timestamp publishedTime;
    private Timestamp expirationTime;

    public String getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(String notificationId) {
        this.notificationId = notificationId;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getNotificationMessage() {
        return this.notificationMessage;
    }

    public void setNotificationMessage(String notificationMessage) {
        this.notificationMessage = notificationMessage;
    }

    public Timestamp getPublishedTime() {
        return this.publishedTime;
    }

    public void setPublishedTime(Timestamp publishedTime) {
        this.publishedTime = publishedTime;
    }

    public Timestamp getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Timestamp expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for user resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Notification", new Object[0][]);
            generator.setParameter("notificationId", name);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object notificationId) throws RegistryException {
        EntityManager em = null;
        try {
            if (!type.equals((Object)ResourceType.NOTIFICATION)) {
                logger.error("Unsupported resource type for Notification resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for Notification resource.");
            }
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Notification", new Object[0][]);
            generator.setParameter("notificationId", notificationId);
            Query q = generator.selectQuery(em);
            Notification notification = (Notification)q.getSingleResult();
            em.getTransaction().commit();
            em.close();
            if (notification != null) {
                ExperimentCatResource experimentCatResource = Utils.getResource(ResourceType.NOTIFICATION, notification);
                return experimentCatResource;
            }
            ExperimentCatResource experimentCatResource = null;
            return experimentCatResource;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for user resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            Notification existingNotification = (Notification)em.find(Notification.class, (Object)this.notificationId);
            em.close();
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingNotification != null) {
                existingNotification.setNotificationId(this.notificationId);
                existingNotification.setGatewayId(this.gatewayId);
                existingNotification.setTitle(this.title);
                existingNotification.setNotificationMessage(this.notificationMessage);
                existingNotification.setPublishedDate(this.publishedTime);
                existingNotification.setExpirationDate(this.expirationTime);
                existingNotification.setCreationDate(this.creationTime);
                existingNotification.setPriority(this.priority);
                em.merge((Object)existingNotification);
            } else {
                Notification notification = new Notification();
                notification.setNotificationId(this.notificationId);
                notification.setGatewayId(this.gatewayId);
                notification.setTitle(this.title);
                notification.setNotificationMessage(this.notificationMessage);
                notification.setPublishedDate(this.publishedTime);
                notification.setExpirationDate(this.expirationTime);
                notification.setCreationDate(this.creationTime);
                notification.setPriority(this.priority);
                em.persist((Object)notification);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for user resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public List<ExperimentCatResource> getAllNotifications(String gatewayId) throws RegistryException {
        ArrayList<ExperimentCatResource> resourceList = new ArrayList<ExperimentCatResource>();
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Notification", new Object[0][]);
            generator.setParameter("gatewayId", gatewayId);
            Query q = generator.selectQuery(em);
            List results = q.getResultList();
            if (results.size() != 0) {
                for (Object result : results) {
                    Notification notification = (Notification)result;
                    NotificationResource notificationResource = (NotificationResource)Utils.getResource(ResourceType.NOTIFICATION, notification);
                    resourceList.add(notificationResource);
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }
}

