/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.db.event.manager;

import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.IServer;
import org.apache.airavata.db.event.manager.messaging.DBEventManagerMessagingFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DBEventManagerRunner
implements IServer {
    private static final Logger log = LogManager.getLogger(DBEventManagerRunner.class);
    private static final String SERVER_NAME = "DB Event Manager";
    private static final String SERVER_VERSION = "1.0";
    private IServer.ServerStatus status;

    private void startDBEventManagerRunner() {
        try {
            log.info((Object)"Starting DB Event manager publisher");
            DBEventManagerMessagingFactory.getDBEventPublisher();
            log.debug((Object)"DB Event manager publisher is running");
            log.info((Object)"Starting DB Event manager subscriber");
            DBEventManagerMessagingFactory.getDBEventSubscriber();
            log.debug((Object)"DB Event manager subscriber is listening");
        }
        catch (AiravataException e) {
            log.error((Object)"Error starting DB Event Manager.", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    DBEventManagerRunner dBEventManagerRunner = new DBEventManagerRunner();
                    dBEventManagerRunner.startDBEventManagerRunner();
                }
            };
            log.info((Object)"Starting the DB Event Manager runner.");
            new Thread(runner).start();
        }
        catch (Exception ex) {
            log.error((Object)("Something went wrong with the DB Event Manager runner. Error: " + ex), (Throwable)ex);
        }
    }

    public String getName() {
        return SERVER_NAME;
    }

    public String getVersion() {
        return SERVER_VERSION;
    }

    public void start() throws Exception {
        try {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    DBEventManagerRunner dBEventManagerRunner = new DBEventManagerRunner();
                    dBEventManagerRunner.startDBEventManagerRunner();
                }
            };
            log.info((Object)"Starting the DB Event Manager runner.");
            new Thread(runner).start();
            this.setStatus(IServer.ServerStatus.STARTED);
        }
        catch (Exception ex) {
            log.error((Object)("Something went wrong with the DB Event Manager runner. Error: " + ex), (Throwable)ex);
            this.setStatus(IServer.ServerStatus.FAILED);
        }
    }

    public void stop() throws Exception {
    }

    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    public void configure() throws Exception {
    }

    public IServer.ServerStatus getStatus() throws Exception {
        return this.status;
    }

    private void setStatus(IServer.ServerStatus stat) {
        this.status = stat;
        this.status.updateTime();
    }
}

