/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.security.userstore;

import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.security.UserStore;
import org.apache.airavata.security.UserStoreException;
import org.apache.airavata.security.userstore.JDBCUserStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractJDBCUserStore
implements UserStore {
    protected static Logger log = LoggerFactory.getLogger(JDBCUserStore.class);
    private String databaseURL = null;
    private String databaseDriver = null;
    private String databaseUserName = null;
    private String databasePassword = null;

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public String getDatabaseUserName() {
        return this.databaseUserName;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    @Override
    public void configure(Node node) throws UserStoreException {
        NodeList databaseNodeList = node.getChildNodes();
        Node databaseNode = null;
        for (int k = 0; k < databaseNodeList.getLength(); ++k) {
            Node n = databaseNodeList.item(k);
            if (n == null || n.getNodeType() != 1) continue;
            databaseNode = n;
        }
        if (databaseNode != null) {
            NodeList nodeList = databaseNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n = nodeList.item(i);
                if (n.getNodeType() != 1) continue;
                Element element = (Element)n;
                if (element.getNodeName().equals("jdbcUrl")) {
                    this.databaseURL = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (element.getNodeName().equals("databaseDriver")) {
                    this.databaseDriver = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (element.getNodeName().equals("userName")) {
                    this.databaseUserName = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (!element.getNodeName().equals("password")) continue;
                this.databasePassword = element.getFirstChild().getNodeValue();
            }
        }
        if (this.databaseURL == null || this.databaseUserName == null || this.databasePassword == null) {
            try {
                this.databaseDriver = ServerSettings.getCredentialStoreDBDriver();
                this.databaseURL = ServerSettings.getCredentialStoreDBURL();
                this.databaseUserName = ServerSettings.getCredentialStoreDBUser();
                this.databasePassword = ServerSettings.getCredentialStoreDBPassword();
            }
            catch (ApplicationSettingsException e) {
                log.error("Error reading default user store DB configurations.");
                throw new UserStoreException((Exception)((Object)e));
            }
            StringBuilder stringBuilder = new StringBuilder("User store configurations - dbDriver - ");
            stringBuilder.append(this.databaseDriver);
            stringBuilder.append(" URL - ").append(this.databaseURL).append(" DB user - ").append(this.databaseUserName);
            log.info(stringBuilder.toString());
        }
    }
}

